/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.policyinformation.JPolicyInformation;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DCertificatePolicies
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpCertificatePolicies;
    private JLabel jlCertificatePolicies;
    private JPolicyInformation jpiCertificatePolicies;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DCertificatePolicies(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DCertificatePolicies.Title"));
        this.initComponents();
    }

    public DCertificatePolicies(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DCertificatePolicies.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlCertificatePolicies = new JLabel(res.getString("DCertificatePolicies.jlCertificatePolicies.text"));
        GridBagConstraints gbc_jlCertificatePolicies = new GridBagConstraints();
        gbc_jlCertificatePolicies.gridx = 0;
        gbc_jlCertificatePolicies.gridy = 1;
        gbc_jlCertificatePolicies.gridwidth = 1;
        gbc_jlCertificatePolicies.gridheight = 1;
        gbc_jlCertificatePolicies.insets = new Insets(5, 5, 5, 5);
        gbc_jlCertificatePolicies.anchor = 12;
        this.jpiCertificatePolicies = new JPolicyInformation(res.getString("DCertificatePolicies.PolicyInformation.Title"));
        this.jpiCertificatePolicies.setPreferredSize(new Dimension(400, 150));
        GridBagConstraints gbc_jpiCertificatePolicies = new GridBagConstraints();
        gbc_jpiCertificatePolicies.gridx = 1;
        gbc_jpiCertificatePolicies.gridy = 1;
        gbc_jpiCertificatePolicies.gridwidth = 1;
        gbc_jpiCertificatePolicies.gridheight = 1;
        gbc_jpiCertificatePolicies.insets = new Insets(5, 5, 5, 5);
        gbc_jpiCertificatePolicies.anchor = 17;
        this.jpCertificatePolicies = new JPanel(new GridBagLayout());
        this.jpCertificatePolicies.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        this.jpCertificatePolicies.add((Component)this.jlCertificatePolicies, gbc_jlCertificatePolicies);
        this.jpCertificatePolicies.add((Component)this.jpiCertificatePolicies, gbc_jpiCertificatePolicies);
        this.jbOK = new JButton(res.getString("DCertificatePolicies.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCertificatePolicies.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DCertificatePolicies.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCertificatePolicies.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DCertificatePolicies.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpCertificatePolicies, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DCertificatePolicies.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)value);
        ArrayList<PolicyInformation> accessDescriptionList = new ArrayList<PolicyInformation>(Arrays.asList(certificatePolicies.getPolicyInformation()));
        this.jpiCertificatePolicies.setPolicyInformation(accessDescriptionList);
    }

    private void okPressed() {
        List<PolicyInformation> policyInformation = this.jpiCertificatePolicies.getPolicyInformation();
        if (policyInformation.isEmpty()) {
            JOptionPane.showMessageDialog(this, res.getString("DCertificatePolicies.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        CertificatePolicies certificatePolicies = new CertificatePolicies(policyInformation.toArray(new PolicyInformation[policyInformation.size()]));
        try {
            this.value = certificatePolicies.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

