/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.kse.crypto.x509.ExtendedKeyUsageType;
import org.kse.gui.CursorUtil;
import org.kse.gui.dialogs.extensions.DCustomExtKeyUsage;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;
import org.kse.utilities.DialogViewer;

public class DExtendedKeyUsage
extends DExtension {
    private static final long serialVersionUID = -972351635055954L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JLabel jlExtendedKeyUsage;
    private JCheckBox jcbCodeSigning;
    private JCheckBox jcbDocumentSigning;
    private JCheckBox jcbEmailProtection;
    private JCheckBox jcbEncryptedFileSystem;
    private JCheckBox jcbIpSecurityEndSystem;
    private JCheckBox jcbIpSecurityTunnelTermination;
    private JCheckBox jcbIpSecurityUser;
    private JCheckBox jcbOcspStamping;
    private JCheckBox jcbTimeStamping;
    private JCheckBox jcbTlsWebClientAuthentication;
    private JCheckBox jcbTlsWebServerAuthentication;
    private JCheckBox jcbSmartcardLogon;
    private JCheckBox jcbAnyExtendedKeyUsage;
    private JCheckBox jcbAdobePDFSigning;
    private JCheckBox jcbTslSigning;
    private JCheckBox jcbCustomExtKeyUsage;
    private Set<ASN1ObjectIdentifier> customExtKeyUsagesOids = new HashSet<ASN1ObjectIdentifier>();
    private JButton jbAddEku;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DExtendedKeyUsage(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DExtendedKeyUsage.Title"));
        this.initComponents();
    }

    public DExtendedKeyUsage(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DExtendedKeyUsage.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlExtendedKeyUsage = new JLabel(res.getString("DExtendedKeyUsage.jlExtendedKeyUsage.text"));
        this.jcbCodeSigning = new JCheckBox(res.getString("DExtendedKeyUsage.jcbCodeSigning.text"));
        this.jcbDocumentSigning = new JCheckBox(res.getString("DExtendedKeyUsage.jcbDocumentSigning.text"));
        this.jcbAdobePDFSigning = new JCheckBox(res.getString("DExtendedKeyUsage.jcbAdobePDFSigning.text"));
        this.jcbTslSigning = new JCheckBox(res.getString("DExtendedKeyUsage.jcbTslSigning.text"));
        this.jcbEncryptedFileSystem = new JCheckBox(res.getString("DExtendedKeyUsage.jcbEncryptedFileSystem.text"));
        this.jcbEmailProtection = new JCheckBox(res.getString("DExtendedKeyUsage.jcbEmailProtection.text"));
        this.jcbIpSecurityEndSystem = new JCheckBox(res.getString("DExtendedKeyUsage.jcbIpSecurityEndSystem.text"));
        this.jcbIpSecurityTunnelTermination = new JCheckBox(res.getString("DExtendedKeyUsage.jcbIpSecurityTunnelTermination.text"));
        this.jcbIpSecurityUser = new JCheckBox(res.getString("DExtendedKeyUsage.jcbIpSecurityUser.text"));
        this.jcbOcspStamping = new JCheckBox(res.getString("DExtendedKeyUsage.jcbOcspStamping.text"));
        this.jcbTimeStamping = new JCheckBox(res.getString("DExtendedKeyUsage.jcbTimeStamping.text"));
        this.jcbTlsWebClientAuthentication = new JCheckBox(res.getString("DExtendedKeyUsage.jcbTlsWebClientAuthentication.text"));
        this.jcbTlsWebServerAuthentication = new JCheckBox(res.getString("DExtendedKeyUsage.jcbTlsWebServerAuthentication.text"));
        this.jcbSmartcardLogon = new JCheckBox(res.getString("DExtendedKeyUsage.jcbSmartcardLogon.text"));
        this.jcbAnyExtendedKeyUsage = new JCheckBox(res.getString("DExtendedKeyUsage.jcbAnyExtendedKeyUsage.text"));
        this.jcbCustomExtKeyUsage = new JCheckBox(res.getString("DExtendedKeyUsage.jcbCustomExtendedKeyUsage.text"));
        this.jbAddEku = new JButton(res.getString("DExtendedKeyUsage.jbAddEku.text"));
        this.jbOK = new JButton(res.getString("DExtendedKeyUsage.jbOK.text"));
        this.jbCancel = new JButton(res.getString("DExtendedKeyUsage.jbCancel.text"));
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "", ""));
        pane.add((Component)this.jlExtendedKeyUsage, "spanx, wrap unrel");
        pane.add((Component)this.jcbAdobePDFSigning, "");
        pane.add((Component)this.jcbAnyExtendedKeyUsage, "");
        pane.add((Component)this.jcbCodeSigning, "wrap");
        pane.add((Component)this.jcbDocumentSigning, "");
        pane.add((Component)this.jcbEncryptedFileSystem, "");
        pane.add((Component)this.jcbEmailProtection, "wrap");
        pane.add((Component)this.jcbIpSecurityEndSystem, "");
        pane.add((Component)this.jcbIpSecurityTunnelTermination, "");
        pane.add((Component)this.jcbIpSecurityUser, "wrap");
        pane.add((Component)this.jcbOcspStamping, "");
        pane.add((Component)this.jcbSmartcardLogon, "");
        pane.add((Component)this.jcbTimeStamping, "wrap");
        pane.add((Component)this.jcbTlsWebClientAuthentication, "");
        pane.add((Component)this.jcbTlsWebServerAuthentication, "");
        pane.add((Component)this.jcbTslSigning, "wrap");
        pane.add((Component)this.jcbCustomExtKeyUsage, "spanx, split");
        pane.add((Component)this.jbAddEku, "wrap unrel");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap 15:push");
        pane.add((Component)this.jbCancel, "spanx, split 2, tag cancel");
        pane.add((Component)this.jbOK, "tag ok");
        this.jcbCustomExtKeyUsage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExtendedKeyUsage.this);
                    if (DExtendedKeyUsage.this.customExtKeyUsagesOids.isEmpty()) {
                        DExtendedKeyUsage.this.addCustomExtKeyUsagePressed();
                    }
                }
                finally {
                    CursorUtil.setCursorFree(DExtendedKeyUsage.this);
                }
            }
        });
        this.jbAddEku.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExtendedKeyUsage.this);
                    DExtendedKeyUsage.this.addCustomExtKeyUsagePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExtendedKeyUsage.this);
                }
            }
        });
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExtendedKeyUsage.this.okPressed();
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExtendedKeyUsage.this.cancelPressed();
            }
        });
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1792160787358938936L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExtendedKeyUsage.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DExtendedKeyUsage.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.getInstance((Object)value);
        for (KeyPurposeId keyPurposeId : extendedKeyUsage.getUsages()) {
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)keyPurposeId.toASN1Primitive();
            ExtendedKeyUsageType type = ExtendedKeyUsageType.resolveOid(oid.getId());
            if (type == ExtendedKeyUsageType.SERVER_AUTH) {
                this.jcbTlsWebServerAuthentication.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.CLIENT_AUTH) {
                this.jcbTlsWebClientAuthentication.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.CODE_SIGNING) {
                this.jcbCodeSigning.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.DOCUMENT_SIGNING) {
                this.jcbDocumentSigning.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.ADOBE_PDF_SIGNING) {
                this.jcbAdobePDFSigning.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.TSL_SIGNING) {
                this.jcbTslSigning.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.EMAIL_PROTECTION) {
                this.jcbEmailProtection.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.ENCRYPTED_FILE_SYSTEM) {
                this.jcbEncryptedFileSystem.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.IPSEC_END_SYSTEM) {
                this.jcbIpSecurityEndSystem.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.IPSEC_TUNNEL) {
                this.jcbIpSecurityTunnelTermination.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.IPSEC_USER) {
                this.jcbIpSecurityUser.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.SMARTCARD_LOGON) {
                this.jcbSmartcardLogon.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.TIME_STAMPING) {
                this.jcbTimeStamping.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.OCSP_SIGNING) {
                this.jcbOcspStamping.setSelected(true);
                continue;
            }
            if (type == ExtendedKeyUsageType.ANY_EXTENDED_KEY_USAGE) {
                this.jcbAnyExtendedKeyUsage.setSelected(true);
                continue;
            }
            this.customExtKeyUsagesOids.add(oid);
        }
        this.jcbCustomExtKeyUsage.setSelected(this.customExtKeyUsagesOids.size() > 0);
    }

    private void addCustomExtKeyUsagePressed() {
        DCustomExtKeyUsage dCustomExtKeyUsage = new DCustomExtKeyUsage(this, this.customExtKeyUsagesOids);
        dCustomExtKeyUsage.setLocationRelativeTo(this);
        dCustomExtKeyUsage.setVisible(true);
        this.customExtKeyUsagesOids = dCustomExtKeyUsage.getObjectIds();
        this.jcbCustomExtKeyUsage.setSelected(this.customExtKeyUsagesOids.size() > 0);
    }

    private void okPressed() {
        if (!(this.jcbTlsWebServerAuthentication.isSelected() || this.jcbTlsWebClientAuthentication.isSelected() || this.jcbCodeSigning.isSelected() || this.jcbEmailProtection.isSelected() || this.jcbIpSecurityEndSystem.isSelected() || this.jcbIpSecurityTunnelTermination.isSelected() || this.jcbIpSecurityUser.isSelected() || this.jcbTimeStamping.isSelected() || this.jcbOcspStamping.isSelected() || this.jcbDocumentSigning.isSelected() || this.jcbAdobePDFSigning.isSelected() || this.jcbTslSigning.isSelected() || this.jcbEncryptedFileSystem.isSelected() || this.jcbAnyExtendedKeyUsage.isSelected() || this.jcbSmartcardLogon.isSelected() || this.jcbCustomExtKeyUsage.isSelected())) {
            JOptionPane.showMessageDialog(this, res.getString("DExtendedKeyUsage.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        ArrayList<KeyPurposeId> keyPurposeIds = new ArrayList<KeyPurposeId>();
        if (this.jcbTlsWebServerAuthentication.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.SERVER_AUTH.oid())));
        }
        if (this.jcbTlsWebClientAuthentication.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.CLIENT_AUTH.oid())));
        }
        if (this.jcbCodeSigning.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.CODE_SIGNING.oid())));
        }
        if (this.jcbDocumentSigning.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.DOCUMENT_SIGNING.oid())));
        }
        if (this.jcbAdobePDFSigning.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.ADOBE_PDF_SIGNING.oid())));
        }
        if (this.jcbTslSigning.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.TSL_SIGNING.oid())));
        }
        if (this.jcbEmailProtection.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.EMAIL_PROTECTION.oid())));
        }
        if (this.jcbEncryptedFileSystem.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.ENCRYPTED_FILE_SYSTEM.oid())));
        }
        if (this.jcbIpSecurityEndSystem.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.IPSEC_END_SYSTEM.oid())));
        }
        if (this.jcbIpSecurityTunnelTermination.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.IPSEC_TUNNEL.oid())));
        }
        if (this.jcbIpSecurityUser.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.IPSEC_USER.oid())));
        }
        if (this.jcbTimeStamping.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.TIME_STAMPING.oid())));
        }
        if (this.jcbOcspStamping.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.OCSP_SIGNING.oid())));
        }
        if (this.jcbSmartcardLogon.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.SMARTCARD_LOGON.oid())));
        }
        if (this.jcbAnyExtendedKeyUsage.isSelected()) {
            keyPurposeIds.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ExtendedKeyUsageType.ANY_EXTENDED_KEY_USAGE.oid())));
        }
        if (this.jcbCustomExtKeyUsage.isSelected()) {
            for (ASN1ObjectIdentifier customExcKeyUsageOid : this.customExtKeyUsagesOids) {
                keyPurposeIds.add(KeyPurposeId.getInstance((Object)customExcKeyUsageOid));
            }
        }
        ExtendedKeyUsage extendedKeyUsage = new ExtendedKeyUsage(keyPurposeIds.toArray(new KeyPurposeId[keyPurposeIds.size()]));
        try {
            this.value = extendedKeyUsage.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        DExtendedKeyUsage dialog = new DExtendedKeyUsage(new JDialog());
        DialogViewer.run(dialog);
    }
}

