/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DKeyUsage
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpKeyUsage;
    private JLabel jlKeyUsage;
    private JPanel jpKeyUsages;
    private JCheckBox jcbCertificateSigning;
    private JCheckBox jcbCrlSign;
    private JCheckBox jcbDataEncipherment;
    private JCheckBox jcbDecipherOnly;
    private JCheckBox jcbDigitalSignature;
    private JCheckBox jcbEncipherOnly;
    private JCheckBox jcbKeyAgreement;
    private JCheckBox jcbKeyEncipherment;
    private JCheckBox jcbNonRepudiation;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DKeyUsage(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DKeyUsage.Title"));
        this.initComponents();
    }

    public DKeyUsage(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DKeyUsage.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlKeyUsage = new JLabel(res.getString("DKeyUsage.jlKeyUsage.text"));
        this.jlKeyUsage.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.jcbCertificateSigning = new JCheckBox(res.getString("DKeyUsage.jcbCertificateSigning.text"));
        this.jcbCrlSign = new JCheckBox(res.getString("DKeyUsage.jcbCrlSign.text"));
        this.jcbDataEncipherment = new JCheckBox(res.getString("DKeyUsage.jcbDataEncipherment.text"));
        this.jcbDecipherOnly = new JCheckBox(res.getString("DKeyUsage.jcbDecipherOnly.text"));
        this.jcbDigitalSignature = new JCheckBox(res.getString("DKeyUsage.jcbDigitalSignature.text"));
        this.jcbEncipherOnly = new JCheckBox(res.getString("DKeyUsage.jcbEncipherOnly.text"));
        this.jcbKeyAgreement = new JCheckBox(res.getString("DKeyUsage.jcbKeyAgreement.text"));
        this.jcbKeyEncipherment = new JCheckBox(res.getString("DKeyUsage.jcbKeyEncipherment.text"));
        this.jcbNonRepudiation = new JCheckBox(res.getString("DKeyUsage.jcbNonRepudiation.text"));
        JPanel jpFirstColumn = new JPanel();
        jpFirstColumn.setLayout(new BoxLayout(jpFirstColumn, 1));
        jpFirstColumn.add(this.jcbCertificateSigning);
        jpFirstColumn.add(this.jcbCrlSign);
        jpFirstColumn.add(this.jcbDataEncipherment);
        JPanel jpSecondColumn = new JPanel();
        jpSecondColumn.setLayout(new BoxLayout(jpSecondColumn, 1));
        jpSecondColumn.add(this.jcbDecipherOnly);
        jpSecondColumn.add(this.jcbDigitalSignature);
        jpSecondColumn.add(this.jcbEncipherOnly);
        JPanel jpThirdColumn = new JPanel();
        jpThirdColumn.setLayout(new BoxLayout(jpThirdColumn, 1));
        jpThirdColumn.add(this.jcbKeyAgreement);
        jpThirdColumn.add(this.jcbKeyEncipherment);
        jpThirdColumn.add(this.jcbNonRepudiation);
        this.jpKeyUsages = new JPanel();
        this.jpKeyUsages.setLayout(new BoxLayout(this.jpKeyUsages, 0));
        this.jpKeyUsages.add(jpFirstColumn);
        this.jpKeyUsages.add(jpSecondColumn);
        this.jpKeyUsages.add(jpThirdColumn);
        this.jpKeyUsage = new JPanel(new BorderLayout(5, 5));
        this.jpKeyUsage.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpKeyUsage.add((Component)this.jlKeyUsage, "North");
        this.jpKeyUsage.add((Component)this.jpKeyUsages, "Center");
        this.jbOK = new JButton(res.getString("DKeyUsage.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DKeyUsage.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DKeyUsage.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DKeyUsage.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DKeyUsage.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpKeyUsage, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DKeyUsage.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(value);){
            DERBitString keyUsage = DERBitString.getInstance((Object)asn1InputStream.readObject());
            int keyUsageValue = keyUsage.intValue();
            this.jcbDigitalSignature.setSelected(this.hasKeyUsage(keyUsageValue, 128));
            this.jcbNonRepudiation.setSelected(this.hasKeyUsage(keyUsageValue, 64));
            this.jcbKeyEncipherment.setSelected(this.hasKeyUsage(keyUsageValue, 32));
            this.jcbDataEncipherment.setSelected(this.hasKeyUsage(keyUsageValue, 16));
            this.jcbKeyAgreement.setSelected(this.hasKeyUsage(keyUsageValue, 8));
            this.jcbCertificateSigning.setSelected(this.hasKeyUsage(keyUsageValue, 4));
            this.jcbCrlSign.setSelected(this.hasKeyUsage(keyUsageValue, 2));
            this.jcbEncipherOnly.setSelected(this.hasKeyUsage(keyUsageValue, 1));
            this.jcbDecipherOnly.setSelected(this.hasKeyUsage(keyUsageValue, 32768));
        }
    }

    private boolean hasKeyUsage(int keyUsages, int keyusage) {
        return (keyUsages & keyusage) == keyusage;
    }

    private void okPressed() {
        if (!(this.jcbDigitalSignature.isSelected() || this.jcbNonRepudiation.isSelected() || this.jcbKeyEncipherment.isSelected() || this.jcbDataEncipherment.isSelected() || this.jcbKeyAgreement.isSelected() || this.jcbCertificateSigning.isSelected() || this.jcbCrlSign.isSelected() || this.jcbEncipherOnly.isSelected() || this.jcbDecipherOnly.isSelected())) {
            JOptionPane.showMessageDialog(this, res.getString("DKeyUsage.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        int keyUsageIntValue = 0;
        keyUsageIntValue |= this.jcbDigitalSignature.isSelected() ? 128 : 0;
        keyUsageIntValue |= this.jcbNonRepudiation.isSelected() ? 64 : 0;
        keyUsageIntValue |= this.jcbKeyEncipherment.isSelected() ? 32 : 0;
        keyUsageIntValue |= this.jcbDataEncipherment.isSelected() ? 16 : 0;
        keyUsageIntValue |= this.jcbKeyAgreement.isSelected() ? 8 : 0;
        keyUsageIntValue |= this.jcbCertificateSigning.isSelected() ? 4 : 0;
        keyUsageIntValue |= this.jcbCrlSign.isSelected() ? 2 : 0;
        keyUsageIntValue |= this.jcbEncipherOnly.isSelected() ? 1 : 0;
        KeyUsage keyUsage = new KeyUsage(keyUsageIntValue |= this.jcbDecipherOnly.isSelected() ? 32768 : 0);
        try {
            this.value = keyUsage.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

