/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.kse.crypto.x509.GeneralSubtrees;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.generalsubtree.JGeneralSubtrees;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DNameConstraints
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpNameConstraints;
    private JLabel jlPermittedSubtrees;
    private JGeneralSubtrees jgsPermittedSubtrees;
    private JLabel jlExcludedSubtrees;
    private JGeneralSubtrees jgsExcludedSubtrees;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DNameConstraints(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DNameConstraints.Title"));
        this.initComponents();
    }

    public DNameConstraints(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DNameConstraints.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlPermittedSubtrees = new JLabel(res.getString("DNameConstraints.jlPermittedSubtrees.text"));
        GridBagConstraints gbc_jlPermittedSubtrees = new GridBagConstraints();
        gbc_jlPermittedSubtrees.gridx = 0;
        gbc_jlPermittedSubtrees.gridy = 0;
        gbc_jlPermittedSubtrees.gridwidth = 1;
        gbc_jlPermittedSubtrees.gridheight = 1;
        gbc_jlPermittedSubtrees.insets = new Insets(5, 5, 5, 5);
        gbc_jlPermittedSubtrees.anchor = 12;
        this.jgsPermittedSubtrees = new JGeneralSubtrees(res.getString("DNameConstraints.PermittedSubtrees.Title"));
        this.jgsPermittedSubtrees.setToolTipText(res.getString("DNameConstraints.jgsPermittedSubtrees.tooltip"));
        GridBagConstraints gbc_jgsPermittedSubtrees = new GridBagConstraints();
        gbc_jgsPermittedSubtrees.gridx = 1;
        gbc_jgsPermittedSubtrees.gridy = 0;
        gbc_jgsPermittedSubtrees.gridwidth = 1;
        gbc_jgsPermittedSubtrees.gridheight = 1;
        gbc_jgsPermittedSubtrees.insets = new Insets(5, 5, 5, 5);
        gbc_jgsPermittedSubtrees.anchor = 17;
        this.jlExcludedSubtrees = new JLabel(res.getString("DNameConstraints.jlExcludedSubtrees.text"));
        GridBagConstraints gbc_jlExcludedSubtrees = new GridBagConstraints();
        gbc_jlExcludedSubtrees.gridx = 0;
        gbc_jlExcludedSubtrees.gridy = 1;
        gbc_jlExcludedSubtrees.gridwidth = 1;
        gbc_jlExcludedSubtrees.gridheight = 1;
        gbc_jlExcludedSubtrees.insets = new Insets(5, 5, 5, 5);
        gbc_jlExcludedSubtrees.anchor = 12;
        this.jgsExcludedSubtrees = new JGeneralSubtrees(res.getString("DNameConstraints.ExcludedSubtrees.Title"));
        this.jgsExcludedSubtrees.setToolTipText(res.getString("DNameConstraints.jgsExcludedSubtrees.tooltip"));
        GridBagConstraints gbc_jgsExcludedSubtrees = new GridBagConstraints();
        gbc_jgsExcludedSubtrees.gridx = 1;
        gbc_jgsExcludedSubtrees.gridy = 1;
        gbc_jgsExcludedSubtrees.gridwidth = 1;
        gbc_jgsExcludedSubtrees.gridheight = 1;
        gbc_jgsExcludedSubtrees.insets = new Insets(5, 5, 5, 5);
        gbc_jgsExcludedSubtrees.anchor = 17;
        this.jpNameConstraints = new JPanel(new GridBagLayout());
        this.jpNameConstraints.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpNameConstraints.add((Component)this.jlPermittedSubtrees, gbc_jlPermittedSubtrees);
        this.jpNameConstraints.add((Component)this.jgsPermittedSubtrees, gbc_jgsPermittedSubtrees);
        this.jpNameConstraints.add((Component)this.jlExcludedSubtrees, gbc_jlExcludedSubtrees);
        this.jpNameConstraints.add((Component)this.jgsExcludedSubtrees, gbc_jgsExcludedSubtrees);
        this.jbOK = new JButton(res.getString("DNameConstraints.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNameConstraints.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DNameConstraints.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNameConstraints.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNameConstraints.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpNameConstraints, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DNameConstraints.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        NameConstraints nameConstraints = NameConstraints.getInstance((Object)value);
        if (nameConstraints.getPermittedSubtrees() != null) {
            this.jgsPermittedSubtrees.setGeneralSubtrees(new GeneralSubtrees(nameConstraints.getPermittedSubtrees()));
        }
        if (nameConstraints.getExcludedSubtrees() != null) {
            this.jgsExcludedSubtrees.setGeneralSubtrees(new GeneralSubtrees(nameConstraints.getExcludedSubtrees()));
        }
    }

    private void okPressed() {
        List<GeneralSubtree> permittedSubtrees = this.jgsPermittedSubtrees.getGeneralSubtrees().getGeneralSubtrees();
        List<GeneralSubtree> excludedSubtrees = this.jgsExcludedSubtrees.getGeneralSubtrees().getGeneralSubtrees();
        GeneralSubtree[] permittedSubtreesArray = permittedSubtrees.toArray(new GeneralSubtree[permittedSubtrees.size()]);
        GeneralSubtree[] excludedSubtreesArray = excludedSubtrees.toArray(new GeneralSubtree[excludedSubtrees.size()]);
        NameConstraints nameConstraints = new NameConstraints(permittedSubtreesArray, excludedSubtreesArray);
        try {
            this.value = nameConstraints.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

