/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.DERIA5String;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DNetscapeSslServerName
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpNetscapeSslServerName;
    private JLabel jlNetscapeSslServerName;
    private JTextField jtfNetscapeSslServerName;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DNetscapeSslServerName(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DNetscapeSslServerName.Title"));
        this.initComponents();
    }

    public DNetscapeSslServerName(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DNetscapeSslServerName.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlNetscapeSslServerName = new JLabel(res.getString("DNetscapeSslServerName.jlNetscapeSslServerName.text"));
        this.jtfNetscapeSslServerName = new JTextField(40);
        this.jpNetscapeSslServerName = new JPanel(new BorderLayout(5, 5));
        this.jpNetscapeSslServerName.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpNetscapeSslServerName.add((Component)this.jlNetscapeSslServerName, "North");
        this.jpNetscapeSslServerName.add((Component)this.jtfNetscapeSslServerName, "Center");
        this.jbOK = new JButton(res.getString("DNetscapeSslServerName.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNetscapeSslServerName.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DNetscapeSslServerName.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNetscapeSslServerName.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DNetscapeSslServerName.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpNetscapeSslServerName, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DNetscapeSslServerName.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        DERIA5String netscapeSslServerName = DERIA5String.getInstance((Object)value);
        this.jtfNetscapeSslServerName.setText(netscapeSslServerName.getString());
        this.jtfNetscapeSslServerName.setCaretPosition(0);
    }

    private void okPressed() {
        String netscapeSslServerNameStr = this.jtfNetscapeSslServerName.getText().trim();
        if (netscapeSslServerNameStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DNetscapeSslServerName.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        DERIA5String netscapeSslServerName = new DERIA5String(netscapeSslServerNameStr);
        try {
            this.value = netscapeSslServerName.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

