/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.x509.PolicyConstraints;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DPolicyConstraints
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpPolicyConstraints;
    private JLabel jlPolicyConstraints;
    private JLabel jlRequireExplicitPolicy;
    private JTextField jtfRequireExplicitPolicy;
    private JLabel jlInhibitPolicyMapping;
    private JTextField jtfInhibitPolicyMapping;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DPolicyConstraints(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DPolicyConstraints.Title"));
        this.initComponents();
    }

    public DPolicyConstraints(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DPolicyConstraints.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlPolicyConstraints = new JLabel(res.getString("DPolicyConstraints.jlPolicyConstraints.text"));
        GridBagConstraints gbc_jlPolicyConstraints = new GridBagConstraints();
        gbc_jlPolicyConstraints.gridx = 0;
        gbc_jlPolicyConstraints.gridy = 0;
        gbc_jlPolicyConstraints.gridwidth = 2;
        gbc_jlPolicyConstraints.insets = new Insets(5, 5, 5, 5);
        gbc_jlPolicyConstraints.anchor = 17;
        this.jlRequireExplicitPolicy = new JLabel(res.getString("DPolicyConstraints.jlRequireExplicitPolicy.text"));
        GridBagConstraints gbc_jlRequireExplicitPolicy = new GridBagConstraints();
        gbc_jlRequireExplicitPolicy.gridx = 0;
        gbc_jlRequireExplicitPolicy.gridy = 1;
        gbc_jlRequireExplicitPolicy.gridwidth = 1;
        gbc_jlRequireExplicitPolicy.insets = new Insets(5, 5, 5, 5);
        gbc_jlRequireExplicitPolicy.anchor = 13;
        this.jtfRequireExplicitPolicy = new JTextField(3);
        GridBagConstraints gbc_jtfRequireExplicitPolicy = new GridBagConstraints();
        gbc_jtfRequireExplicitPolicy.gridx = 1;
        gbc_jtfRequireExplicitPolicy.gridy = 1;
        gbc_jtfRequireExplicitPolicy.gridwidth = 1;
        gbc_jtfRequireExplicitPolicy.insets = new Insets(5, 5, 5, 5);
        gbc_jtfRequireExplicitPolicy.anchor = 17;
        this.jlInhibitPolicyMapping = new JLabel(res.getString("DPolicyConstraints.jlInhibitPolicyMapping.text"));
        GridBagConstraints gbc_jlInhibitPolicyMapping = new GridBagConstraints();
        gbc_jlInhibitPolicyMapping.gridx = 0;
        gbc_jlInhibitPolicyMapping.gridy = 2;
        gbc_jlInhibitPolicyMapping.gridwidth = 1;
        gbc_jlInhibitPolicyMapping.insets = new Insets(5, 5, 5, 5);
        gbc_jlInhibitPolicyMapping.anchor = 13;
        this.jtfInhibitPolicyMapping = new JTextField(3);
        GridBagConstraints gbc_jtfInhibitPolicyMapping = new GridBagConstraints();
        gbc_jtfInhibitPolicyMapping.gridx = 1;
        gbc_jtfInhibitPolicyMapping.gridy = 2;
        gbc_jtfInhibitPolicyMapping.gridwidth = 1;
        gbc_jtfInhibitPolicyMapping.insets = new Insets(5, 5, 5, 5);
        gbc_jtfInhibitPolicyMapping.anchor = 17;
        this.jpPolicyConstraints = new JPanel(new GridBagLayout());
        this.jpPolicyConstraints.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpPolicyConstraints.add((Component)this.jlPolicyConstraints, gbc_jlPolicyConstraints);
        this.jpPolicyConstraints.add((Component)this.jlRequireExplicitPolicy, gbc_jlRequireExplicitPolicy);
        this.jpPolicyConstraints.add((Component)this.jtfRequireExplicitPolicy, gbc_jtfRequireExplicitPolicy);
        this.jpPolicyConstraints.add((Component)this.jlInhibitPolicyMapping, gbc_jlInhibitPolicyMapping);
        this.jpPolicyConstraints.add((Component)this.jtfInhibitPolicyMapping, gbc_jtfInhibitPolicyMapping);
        this.jbOK = new JButton(res.getString("DPolicyConstraints.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyConstraints.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DPolicyConstraints.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyConstraints.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyConstraints.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpPolicyConstraints, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DPolicyConstraints.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        BigInteger inhibitPolicyMapping;
        PolicyConstraints policyConstraints = PolicyConstraints.getInstance((Object)value);
        BigInteger requireExplictPolicy = policyConstraints.getRequireExplicitPolicyMapping();
        if (requireExplictPolicy != null) {
            this.jtfRequireExplicitPolicy.setText("" + requireExplictPolicy);
            this.jtfRequireExplicitPolicy.setCaretPosition(0);
        }
        if ((inhibitPolicyMapping = policyConstraints.getInhibitPolicyMapping()) != null) {
            this.jtfInhibitPolicyMapping.setText("" + inhibitPolicyMapping);
            this.jtfInhibitPolicyMapping.setCaretPosition(0);
        }
    }

    private void okPressed() {
        BigInteger requireExplicitPolicy = null;
        String requireExplicitPolicyStr = this.jtfRequireExplicitPolicy.getText().trim();
        if (requireExplicitPolicyStr.length() != 0) {
            try {
                requireExplicitPolicy = new BigInteger(requireExplicitPolicyStr);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, res.getString("DPolicyConstraints.InvalidRequireExplicitPolicyValue.message"), this.getTitle(), 2);
                return;
            }
            if (requireExplicitPolicy.signum() == -1) {
                JOptionPane.showMessageDialog(this, res.getString("DPolicyConstraints.InvalidRequireExplicitPolicyValue.message"), this.getTitle(), 2);
                return;
            }
        }
        BigInteger inhibitPolicyMapping = null;
        String inhibitPolicyMappingStr = this.jtfInhibitPolicyMapping.getText().trim();
        if (inhibitPolicyMappingStr.length() != 0) {
            try {
                inhibitPolicyMapping = new BigInteger(inhibitPolicyMappingStr);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, res.getString("DPolicyConstraints.InvalidInhibitPolicyMappingValue.message"), this.getTitle(), 2);
                return;
            }
            if (inhibitPolicyMapping.signum() == -1) {
                JOptionPane.showMessageDialog(this, res.getString("DPolicyConstraints.InvalidInhibitPolicyMappingValue.message"), this.getTitle(), 2);
                return;
            }
        }
        if (requireExplicitPolicy == null && inhibitPolicyMapping == null) {
            JOptionPane.showMessageDialog(this, res.getString("DPolicyConstraints.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        PolicyConstraints policyConstraints = new PolicyConstraints(requireExplicitPolicy, inhibitPolicyMapping);
        try {
            this.value = policyConstraints.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

