/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.importexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.crypto.Password;
import org.kse.crypto.privatekey.Pkcs8PbeType;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JavaFXFileChooser;
import org.kse.gui.PlatformUtil;
import org.kse.gui.password.JPasswordQualityField;
import org.kse.gui.password.PasswordQualityConfig;
import org.kse.utilities.io.FileNameUtil;

public class DExportPrivateKeyPkcs8
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/importexport/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpOptions;
    private JLabel jlEncrypt;
    private JCheckBox jcbEncrypt;
    private JLabel jlPbeAlg;
    private JComboBox<Pkcs8PbeType> jcbPbeAlg;
    private JLabel jlPassword;
    private JComponent jpfPassword;
    private JLabel jlConfirmPassword;
    private JPasswordField jpfConfirmPassword;
    private JLabel jlExportPem;
    private JCheckBox jcbExportPem;
    private JLabel jlExportFile;
    private JTextField jtfExportFile;
    private JButton jbBrowse;
    private JPanel jpButtons;
    private JButton jbExport;
    private JButton jbCancel;
    private String entryAlias;
    private PasswordQualityConfig passwordQualityConfig;
    private boolean exportSelected = false;
    private File exportFile;
    private boolean encrypt;
    private Pkcs8PbeType pbeAlgorithm;
    private Password exportPassword;
    private boolean pemEncode;

    public DExportPrivateKeyPkcs8(JFrame parent, String entryAlias, PasswordQualityConfig passwordQualityConfig) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.entryAlias = entryAlias;
        this.passwordQualityConfig = passwordQualityConfig;
        this.initComponents();
    }

    private void initComponents() {
        GridBagConstraints gbcLbl = new GridBagConstraints();
        gbcLbl.gridx = 0;
        gbcLbl.gridwidth = 3;
        gbcLbl.gridheight = 1;
        gbcLbl.insets = new Insets(5, 5, 5, 5);
        gbcLbl.anchor = 13;
        GridBagConstraints gbcEdCtrl = new GridBagConstraints();
        gbcEdCtrl.gridx = 3;
        gbcEdCtrl.gridwidth = 3;
        gbcEdCtrl.gridheight = 1;
        gbcEdCtrl.insets = new Insets(5, 5, 5, 5);
        gbcEdCtrl.anchor = 17;
        this.jlEncrypt = new JLabel(res.getString("DExportPrivateKeyPkcs8.jlEncrypt.text"));
        GridBagConstraints gbc_jlEncrypt = (GridBagConstraints)gbcLbl.clone();
        gbc_jlEncrypt.gridy = 0;
        this.jcbEncrypt = new JCheckBox();
        this.jcbEncrypt.setSelected(true);
        this.jcbEncrypt.setToolTipText(res.getString("DExportPrivateKeyPkcs8.jcbEncrypt.tooltip"));
        GridBagConstraints gbc_jcbEncrypt = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jcbEncrypt.gridy = 0;
        this.jlPbeAlg = new JLabel(res.getString("DExportPrivateKeyPkcs8.jlPbeAlg.text"));
        GridBagConstraints gbc_jlPbeAlg = (GridBagConstraints)gbcLbl.clone();
        gbc_jlPbeAlg.gridy = 1;
        this.jcbPbeAlg = new JComboBox();
        this.populatePbeAlgs();
        this.jcbPbeAlg.setToolTipText(res.getString("DExportPrivateKeyPkcs8.jcbPbeAlg.tooltip"));
        this.jcbPbeAlg.setSelectedIndex(0);
        GridBagConstraints gbc_jcbPbeAlg = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jcbPbeAlg.gridy = 1;
        this.jlPassword = new JLabel(res.getString("DExportPrivateKeyPkcs8.jlPassword.text"));
        GridBagConstraints gbc_jlPassword = (GridBagConstraints)gbcLbl.clone();
        gbc_jlPassword.gridy = 2;
        this.jpfPassword = this.passwordQualityConfig.getEnabled() ? (this.passwordQualityConfig.getEnforced() ? new JPasswordQualityField(15, this.passwordQualityConfig.getMinimumQuality()) : new JPasswordQualityField(15)) : new JPasswordField(15);
        this.jpfPassword.setToolTipText(res.getString("DExportPrivateKeyPkcs8.jpqfPassword.tooltip"));
        GridBagConstraints gbc_jpfPassword = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jpfPassword.gridy = 2;
        this.jlConfirmPassword = new JLabel(res.getString("DExportPrivateKeyPkcs8.jlConfirmPassword.text"));
        GridBagConstraints gbc_jlConfirmPassword = (GridBagConstraints)gbcLbl.clone();
        gbc_jlConfirmPassword.gridy = 3;
        this.jpfConfirmPassword = new JPasswordField(15);
        this.jpfConfirmPassword.setToolTipText(res.getString("DExportPrivateKeyPkcs8.jpfConfirmPassword.tooltip"));
        GridBagConstraints gbc_jpfConfirmPassword = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jpfConfirmPassword.gridy = 3;
        this.jlExportPem = new JLabel(res.getString("DExportPrivateKeyPkcs8.jlExportPem.text"));
        GridBagConstraints gbc_jlExportPem = (GridBagConstraints)gbcLbl.clone();
        gbc_jlExportPem.gridy = 4;
        this.jcbExportPem = new JCheckBox();
        this.jcbExportPem.setSelected(true);
        this.jcbExportPem.setToolTipText(res.getString("DExportPrivateKeyPkcs8.jcbExportPem.tooltip"));
        GridBagConstraints gbc_jcbExportPem = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jcbExportPem.gridy = 4;
        this.jlExportFile = new JLabel(res.getString("DExportPrivateKeyPkcs8.jlExportFile.text"));
        GridBagConstraints gbc_jlExportFile = (GridBagConstraints)gbcLbl.clone();
        gbc_jlExportFile.gridy = 5;
        this.jtfExportFile = new JTextField(30);
        this.jtfExportFile.setToolTipText(res.getString("DExportPrivateKeyPkcs8.jtfExportFile.tooltip"));
        GridBagConstraints gbc_jtfExportFile = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jtfExportFile.gridy = 5;
        gbc_jtfExportFile.gridwidth = 6;
        this.jbBrowse = new JButton(res.getString("DExportPrivateKeyPkcs8.jbBrowse.text"));
        this.jbBrowse.setToolTipText(res.getString("DExportPrivateKeyPkcs8.jbBrowse.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbBrowse, res.getString("DExportPrivateKeyPkcs8.jbBrowse.mnemonic").charAt(0));
        GridBagConstraints gbc_jbBrowse = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jbBrowse.gridy = 5;
        gbc_jbBrowse.gridx = 9;
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExportPrivateKeyPkcs8.this);
                    DExportPrivateKeyPkcs8.this.browsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExportPrivateKeyPkcs8.this);
                }
            }
        });
        this.jpOptions = new JPanel(new GridBagLayout());
        this.jpOptions.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()), new EmptyBorder(5, 5, 5, 5)));
        this.jpOptions.add((Component)this.jlEncrypt, gbc_jlEncrypt);
        this.jpOptions.add((Component)this.jcbEncrypt, gbc_jcbEncrypt);
        this.jpOptions.add((Component)this.jlPbeAlg, gbc_jlPbeAlg);
        this.jpOptions.add(this.jcbPbeAlg, gbc_jcbPbeAlg);
        this.jpOptions.add((Component)this.jlPassword, gbc_jlPassword);
        this.jpOptions.add((Component)this.jpfPassword, gbc_jpfPassword);
        this.jpOptions.add((Component)this.jlConfirmPassword, gbc_jlConfirmPassword);
        this.jpOptions.add((Component)this.jpfConfirmPassword, gbc_jpfConfirmPassword);
        this.jpOptions.add((Component)this.jlExportPem, gbc_jlExportPem);
        this.jpOptions.add((Component)this.jcbExportPem, gbc_jcbExportPem);
        this.jpOptions.add((Component)this.jlExportFile, gbc_jlExportFile);
        this.jpOptions.add((Component)this.jtfExportFile, gbc_jtfExportFile);
        this.jpOptions.add((Component)this.jbBrowse, gbc_jbBrowse);
        this.jcbEncrypt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (DExportPrivateKeyPkcs8.this.jcbEncrypt.isSelected()) {
                    DExportPrivateKeyPkcs8.this.jcbPbeAlg.setEnabled(true);
                    DExportPrivateKeyPkcs8.this.jpfPassword.setEnabled(true);
                    DExportPrivateKeyPkcs8.this.jpfConfirmPassword.setEnabled(true);
                } else {
                    DExportPrivateKeyPkcs8.this.jcbPbeAlg.setEnabled(false);
                    DExportPrivateKeyPkcs8.this.jpfPassword.setEnabled(false);
                    if (DExportPrivateKeyPkcs8.this.jpfPassword instanceof JPasswordQualityField) {
                        ((JPasswordQualityField)DExportPrivateKeyPkcs8.this.jpfPassword).setText("");
                    } else {
                        ((JPasswordField)DExportPrivateKeyPkcs8.this.jpfPassword).setText("");
                    }
                    DExportPrivateKeyPkcs8.this.jpfConfirmPassword.setEnabled(false);
                    DExportPrivateKeyPkcs8.this.jpfConfirmPassword.setText("");
                }
            }
        });
        this.jbExport = new JButton(res.getString("DExportPrivateKeyPkcs8.jbExport.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbExport, res.getString("DExportPrivateKeyPkcs8.jbExport.mnemonic").charAt(0));
        this.jbExport.setToolTipText(res.getString("DExportPrivateKeyPkcs8.jbExport.tooltip"));
        this.jbExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExportPrivateKeyPkcs8.this);
                    DExportPrivateKeyPkcs8.this.exportPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExportPrivateKeyPkcs8.this);
                }
            }
        });
        this.jbCancel = new JButton(res.getString("DExportPrivateKeyPkcs8.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExportPrivateKeyPkcs8.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExportPrivateKeyPkcs8.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbExport, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpOptions, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DExportPrivateKeyPkcs8.this.closeDialog();
            }
        });
        this.setTitle(MessageFormat.format(res.getString("DExportPrivateKeyPkcs8.Title"), this.entryAlias));
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbExport);
        this.populateExportFileName();
        this.pack();
    }

    private void populateExportFileName() {
        File currentDirectory = CurrentDirectory.get();
        String sanitizedAlias = FileNameUtil.cleanFileName(this.entryAlias);
        File csrFile = new File(currentDirectory, sanitizedAlias + "." + "pkcs8");
        this.jtfExportFile.setText(csrFile.getPath());
    }

    public boolean exportSelected() {
        return this.exportSelected;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public boolean encrypt() {
        return this.encrypt;
    }

    public Pkcs8PbeType getPbeAlgorithm() {
        return this.pbeAlgorithm;
    }

    public Password getExportPassword() {
        return this.exportPassword;
    }

    public boolean pemEncode() {
        return this.pemEncode;
    }

    private void populatePbeAlgs() {
        Pkcs8PbeType[] pbeAlgs = Pkcs8PbeType.values();
        for (int i = 0; i < pbeAlgs.length; ++i) {
            this.jcbPbeAlg.addItem(pbeAlgs[i]);
        }
        this.jcbPbeAlg.setSelectedIndex(0);
    }

    private void browsePressed() {
        int rtnValue;
        JFileChooser chooser = FileChooserFactory.getPkcs8FileChooser();
        File currentExportFile = new File(this.jtfExportFile.getText().trim());
        if (currentExportFile.getParentFile() != null && currentExportFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentExportFile.getParentFile());
            chooser.setSelectedFile(currentExportFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DExportPrivateKeyPkcs8.ChooseExportFile.Title"));
        chooser.setMultiSelectionEnabled(false);
        int n = rtnValue = JavaFXFileChooser.isFxAvailable() ? chooser.showSaveDialog(this) : chooser.showDialog(this, res.getString("DExportPrivateKeyPkcs8.ChooseExportFile.button"));
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfExportFile.setText(chosenFile.toString());
            this.jtfExportFile.setCaretPosition(0);
        }
    }

    private void exportPressed() {
        String message;
        int selected;
        this.encrypt = this.jcbEncrypt.isSelected();
        if (this.encrypt) {
            Password firstPassword;
            this.pbeAlgorithm = (Pkcs8PbeType)this.jcbPbeAlg.getSelectedItem();
            if (this.jpfPassword instanceof JPasswordQualityField) {
                char[] firstPasswordChars = ((JPasswordQualityField)this.jpfPassword).getPassword();
                if (firstPasswordChars == null) {
                    JOptionPane.showMessageDialog(this, res.getString("DExportPrivateKeyPkcs8.MinimumPasswordQualityNotMet.message"), res.getString("DExportPrivateKeyPkcs8.Simple.Title"), 2);
                    return;
                }
                firstPassword = new Password(firstPasswordChars);
            } else {
                firstPassword = new Password(((JPasswordField)this.jpfPassword).getPassword());
            }
            Password confirmPassword = new Password(this.jpfConfirmPassword.getPassword());
            if (firstPassword.equals(confirmPassword)) {
                this.exportPassword = firstPassword;
            } else {
                JOptionPane.showMessageDialog(this, res.getString("DExportPrivateKeyPkcs8.PasswordsNoMatch.message"), res.getString("DExportPrivateKeyPkcs8.Simple.Title"), 2);
                return;
            }
        }
        this.pemEncode = this.jcbExportPem.isSelected();
        String exportFileStr = this.jtfExportFile.getText().trim();
        if (exportFileStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DExportPrivateKeyPkcs8.ExportFileRequired.message"), res.getString("DExportPrivateKeyPkcs8.Simple.Title"), 2);
            return;
        }
        File exportFile = new File(exportFileStr);
        if (exportFile.isFile() && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DExportPrivateKeyPkcs8.OverWriteExportFile.message"), exportFile), res.getString("DExportPrivateKeyPkcs8.Simple.Title"), 0)) != 0) {
            return;
        }
        this.exportFile = exportFile;
        this.exportSelected = true;
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

