/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.importexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.crypto.Password;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JavaFXFileChooser;
import org.kse.gui.PlatformUtil;
import org.kse.gui.password.JPasswordQualityField;
import org.kse.gui.password.PasswordQualityConfig;
import org.kse.utilities.io.FileNameUtil;

public class DExportPrivateKeyPvk
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/importexport/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpOptions;
    private JLabel jlKeyType;
    private JRadioButton jrbExchange;
    private JRadioButton jrbSignature;
    private JLabel jlEncrypt;
    private JLabel jlEncryptionStrength;
    private JRadioButton jrbStrong;
    private JRadioButton jrbWeak;
    private JCheckBox jcbEncrypt;
    private JLabel jlPassword;
    private JComponent jpfPassword;
    private JLabel jlConfirmPassword;
    private JPasswordField jpfConfirmPassword;
    private JLabel jlExportFile;
    private JTextField jtfExportFile;
    private JButton jbBrowse;
    private JPanel jpButtons;
    private JButton jbExport;
    private JButton jbCancel;
    private String entryAlias;
    private PrivateKey privateKey;
    private PasswordQualityConfig passwordQualityConfig;
    private boolean exportSelected = false;
    private File exportFile;
    private int keyType;
    private boolean encrypt;
    private boolean strongEncryption;
    private Password exportPassword;

    public DExportPrivateKeyPvk(JFrame parent, String entryAlias, PrivateKey privateKey, PasswordQualityConfig passwordQualityConfig) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.entryAlias = entryAlias;
        this.privateKey = privateKey;
        this.passwordQualityConfig = passwordQualityConfig;
        this.initComponents();
    }

    private void initComponents() {
        GridBagConstraints gbcLbl = new GridBagConstraints();
        gbcLbl.gridx = 0;
        gbcLbl.gridwidth = 3;
        gbcLbl.gridheight = 1;
        gbcLbl.insets = new Insets(5, 5, 5, 5);
        gbcLbl.anchor = 13;
        GridBagConstraints gbcEdCtrl = new GridBagConstraints();
        gbcEdCtrl.gridx = 3;
        gbcEdCtrl.gridwidth = 3;
        gbcEdCtrl.gridheight = 1;
        gbcEdCtrl.insets = new Insets(5, 5, 5, 5);
        gbcEdCtrl.anchor = 17;
        this.jlKeyType = new JLabel(res.getString("DExportPrivateKeyPvk.jlKeyType.text"));
        GridBagConstraints gbc_jlKeyType = (GridBagConstraints)gbcLbl.clone();
        gbc_jlKeyType.gridy = 0;
        this.jrbExchange = new JRadioButton(res.getString("DExportPrivateKeyPvk.jrbExchange.text"));
        this.jrbExchange.setToolTipText(res.getString("DExportPrivateKeyPvk.jrbExchange.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbExchange, res.getString("DExportPrivateKeyPvk.jrbExchange.mnemonic").charAt(0));
        this.jrbExchange.setSelected(true);
        GridBagConstraints gbc_jrbExchange = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jrbExchange.gridy = 0;
        this.jrbSignature = new JRadioButton(res.getString("DExportPrivateKeyPvk.jrbSignature.text"));
        this.jrbSignature.setToolTipText(res.getString("DExportPrivateKeyPvk.jrbSignature.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbSignature, res.getString("DExportPrivateKeyPvk.jrbSignature.mnemonic").charAt(0));
        GridBagConstraints gbc_jrbSignature = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jrbSignature.gridy = 0;
        gbc_jrbSignature.gridx = 6;
        ButtonGroup keyTypes = new ButtonGroup();
        keyTypes.add(this.jrbExchange);
        keyTypes.add(this.jrbSignature);
        if (this.privateKey instanceof DSAPrivateKey) {
            this.jrbSignature.setSelected(true);
            this.jrbExchange.setEnabled(false);
            this.jrbSignature.setEnabled(false);
        }
        this.jlEncrypt = new JLabel(res.getString("DExportPrivateKeyPvk.jlEncrypt.text"));
        GridBagConstraints gbc_jlEncrypt = (GridBagConstraints)gbcLbl.clone();
        gbc_jlEncrypt.gridy = 1;
        this.jcbEncrypt = new JCheckBox();
        this.jcbEncrypt.setSelected(true);
        this.jcbEncrypt.setToolTipText(res.getString("DExportPrivateKeyPvk.jcbEncrypt.tooltip"));
        GridBagConstraints gbc_jcbEncrypt = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jcbEncrypt.gridy = 1;
        this.jlEncryptionStrength = new JLabel(res.getString("DExportPrivateKeyPvk.jlEncryptionStrength.text"));
        GridBagConstraints gbc_jlEncryptionStrength = (GridBagConstraints)gbcLbl.clone();
        gbc_jlEncryptionStrength.gridy = 2;
        this.jrbStrong = new JRadioButton(res.getString("DExportPrivateKeyPvk.jrbStrong.text"));
        this.jrbStrong.setToolTipText(res.getString("DExportPrivateKeyPvk.jrbStrong.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbStrong, res.getString("DExportPrivateKeyPvk.jrbStrong.mnemonic").charAt(0));
        this.jrbStrong.setSelected(true);
        GridBagConstraints gbc_jrbStrong = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jrbStrong.gridy = 2;
        this.jrbWeak = new JRadioButton(res.getString("DExportPrivateKeyPvk.jrbWeak.text"));
        this.jrbWeak.setToolTipText(res.getString("DExportPrivateKeyPvk.jrbWeak.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbWeak, res.getString("DExportPrivateKeyPvk.jrbWeak.mnemonic").charAt(0));
        GridBagConstraints gbc_jrbWeak = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jrbWeak.gridy = 2;
        gbc_jrbWeak.gridx = 6;
        ButtonGroup encryptionStrengths = new ButtonGroup();
        encryptionStrengths.add(this.jrbStrong);
        encryptionStrengths.add(this.jrbWeak);
        this.jlPassword = new JLabel(res.getString("DExportPrivateKeyPvk.jlPassword.text"));
        GridBagConstraints gbc_jlPassword = (GridBagConstraints)gbcLbl.clone();
        gbc_jlPassword.gridy = 3;
        this.jpfPassword = this.passwordQualityConfig.getEnabled() ? (this.passwordQualityConfig.getEnforced() ? new JPasswordQualityField(15, this.passwordQualityConfig.getMinimumQuality()) : new JPasswordQualityField(15)) : new JPasswordField(15);
        this.jpfPassword.setToolTipText(res.getString("DExportPrivateKeyPvk.jpqfPassword.tooltip"));
        GridBagConstraints gbc_jpfPassword = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jpfPassword.gridy = 3;
        gbc_jpfPassword.gridwidth = 6;
        this.jlConfirmPassword = new JLabel(res.getString("DExportPrivateKeyPvk.jlConfirmPassword.text"));
        GridBagConstraints gbc_jlConfirmPassword = (GridBagConstraints)gbcLbl.clone();
        gbc_jlConfirmPassword.gridy = 4;
        this.jpfConfirmPassword = new JPasswordField(15);
        this.jpfConfirmPassword.setToolTipText(res.getString("DExportPrivateKeyPvk.jpfConfirmPassword.tooltip"));
        GridBagConstraints gbc_jpfConfirmPassword = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jpfConfirmPassword.gridy = 4;
        gbc_jpfConfirmPassword.gridwidth = 6;
        this.jlExportFile = new JLabel(res.getString("DExportPrivateKeyPvk.jlExportFile.text"));
        GridBagConstraints gbc_jlExportFile = (GridBagConstraints)gbcLbl.clone();
        gbc_jlExportFile.gridy = 5;
        this.jtfExportFile = new JTextField(30);
        this.jtfExportFile.setToolTipText(res.getString("DExportPrivateKeyPvk.jtfExportFile.tooltip"));
        GridBagConstraints gbc_jtfExportFile = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jtfExportFile.gridy = 5;
        gbc_jtfExportFile.gridwidth = 6;
        this.jbBrowse = new JButton(res.getString("DExportPrivateKeyPvk.jbBrowse.text"));
        this.jbBrowse.setToolTipText(res.getString("DExportPrivateKeyPvk.jbBrowse.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbBrowse, res.getString("DExportPrivateKeyPvk.jbBrowse.mnemonic").charAt(0));
        GridBagConstraints gbc_jbBrowse = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jbBrowse.gridy = 5;
        gbc_jbBrowse.gridx = 9;
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExportPrivateKeyPvk.this);
                    DExportPrivateKeyPvk.this.browsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExportPrivateKeyPvk.this);
                }
            }
        });
        this.jpOptions = new JPanel(new GridBagLayout());
        this.jpOptions.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()), new EmptyBorder(5, 5, 5, 5)));
        this.jpOptions.add((Component)this.jlKeyType, gbc_jlKeyType);
        this.jpOptions.add((Component)this.jrbExchange, gbc_jrbExchange);
        this.jpOptions.add((Component)this.jrbSignature, gbc_jrbSignature);
        this.jpOptions.add((Component)this.jlEncrypt, gbc_jlEncrypt);
        this.jpOptions.add((Component)this.jcbEncrypt, gbc_jcbEncrypt);
        this.jpOptions.add((Component)this.jrbStrong, gbc_jrbStrong);
        this.jpOptions.add((Component)this.jrbWeak, gbc_jrbWeak);
        this.jpOptions.add((Component)this.jlEncryptionStrength, gbc_jlEncryptionStrength);
        this.jpOptions.add((Component)this.jlEncryptionStrength, gbc_jlEncryptionStrength);
        this.jpOptions.add((Component)this.jlPassword, gbc_jlPassword);
        this.jpOptions.add((Component)this.jpfPassword, gbc_jpfPassword);
        this.jpOptions.add((Component)this.jlConfirmPassword, gbc_jlConfirmPassword);
        this.jpOptions.add((Component)this.jpfConfirmPassword, gbc_jpfConfirmPassword);
        this.jpOptions.add((Component)this.jlExportFile, gbc_jlExportFile);
        this.jpOptions.add((Component)this.jtfExportFile, gbc_jtfExportFile);
        this.jpOptions.add((Component)this.jbBrowse, gbc_jbBrowse);
        this.jcbEncrypt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (DExportPrivateKeyPvk.this.jcbEncrypt.isSelected()) {
                    DExportPrivateKeyPvk.this.jrbStrong.setEnabled(true);
                    DExportPrivateKeyPvk.this.jrbWeak.setEnabled(true);
                    DExportPrivateKeyPvk.this.jpfPassword.setEnabled(true);
                    DExportPrivateKeyPvk.this.jpfConfirmPassword.setEnabled(true);
                } else {
                    DExportPrivateKeyPvk.this.jrbStrong.setEnabled(false);
                    DExportPrivateKeyPvk.this.jrbWeak.setEnabled(false);
                    DExportPrivateKeyPvk.this.jpfPassword.setEnabled(false);
                    if (DExportPrivateKeyPvk.this.jpfPassword instanceof JPasswordQualityField) {
                        ((JPasswordQualityField)DExportPrivateKeyPvk.this.jpfPassword).setText("");
                    } else {
                        ((JPasswordField)DExportPrivateKeyPvk.this.jpfPassword).setText("");
                    }
                    DExportPrivateKeyPvk.this.jpfConfirmPassword.setEnabled(false);
                    DExportPrivateKeyPvk.this.jpfConfirmPassword.setText("");
                }
            }
        });
        this.jbExport = new JButton(res.getString("DExportPrivateKeyPvk.jbExport.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbExport, res.getString("DExportPrivateKeyPvk.jbExport.mnemonic").charAt(0));
        this.jbExport.setToolTipText(res.getString("DExportPrivateKeyPvk.jbExport.tooltip"));
        this.jbExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExportPrivateKeyPvk.this);
                    DExportPrivateKeyPvk.this.exportPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExportPrivateKeyPvk.this);
                }
            }
        });
        this.jbCancel = new JButton(res.getString("DExportPrivateKeyPvk.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExportPrivateKeyPvk.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExportPrivateKeyPvk.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbExport, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpOptions, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DExportPrivateKeyPvk.this.closeDialog();
            }
        });
        this.setTitle(MessageFormat.format(res.getString("DExportPrivateKeyPvk.Title"), this.entryAlias));
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbExport);
        this.populateExportFileName();
        this.pack();
    }

    private void populateExportFileName() {
        File currentDirectory = CurrentDirectory.get();
        String sanitizedAlias = FileNameUtil.cleanFileName(this.entryAlias);
        File csrFile = new File(currentDirectory, sanitizedAlias + "." + "pvk");
        this.jtfExportFile.setText(csrFile.getPath());
    }

    public boolean exportSelected() {
        return this.exportSelected;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public int getKeyType() {
        return this.keyType;
    }

    public boolean encrypt() {
        return this.encrypt;
    }

    public boolean useStrongEncryption() {
        return this.strongEncryption;
    }

    public Password getExportPassword() {
        return this.exportPassword;
    }

    private void browsePressed() {
        int rtnValue;
        JFileChooser chooser = FileChooserFactory.getPvkFileChooser();
        File currentExportFile = new File(this.jtfExportFile.getText().trim());
        if (currentExportFile.getParentFile() != null && currentExportFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentExportFile.getParentFile());
            chooser.setSelectedFile(currentExportFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DExportPrivateKeyPvk.ChooseExportFile.Title"));
        chooser.setMultiSelectionEnabled(false);
        int n = rtnValue = JavaFXFileChooser.isFxAvailable() ? chooser.showSaveDialog(this) : chooser.showDialog(this, res.getString("DExportPrivateKeyPvk.ChooseExportFile.button"));
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfExportFile.setText(chosenFile.toString());
            this.jtfExportFile.setCaretPosition(0);
        }
    }

    private void exportPressed() {
        String message;
        int selected;
        String exportFileChars;
        this.keyType = this.jrbExchange.isSelected() ? 1 : 2;
        this.encrypt = this.jcbEncrypt.isSelected();
        if (this.encrypt) {
            Password firstPassword;
            this.strongEncryption = this.jrbStrong.isSelected();
            if (this.jpfPassword instanceof JPasswordQualityField) {
                char[] firstPasswordChars = ((JPasswordQualityField)this.jpfPassword).getPassword();
                if (firstPasswordChars == null) {
                    JOptionPane.showMessageDialog(this, res.getString("DExportPrivateKeyPvk.MinimumPasswordQualityNotMet.message"), res.getString("DExportPrivateKeyPvk.Simple.Title"), 2);
                    return;
                }
                firstPassword = new Password(firstPasswordChars);
            } else {
                firstPassword = new Password(((JPasswordField)this.jpfPassword).getPassword());
            }
            Password confirmPassword = new Password(this.jpfConfirmPassword.getPassword());
            if (firstPassword.equals(confirmPassword)) {
                this.exportPassword = firstPassword;
            } else {
                JOptionPane.showMessageDialog(this, res.getString("DExportPrivateKeyPvk.PasswordsNoMatch.message"), res.getString("DExportPrivateKeyPvk.Simple.Title"), 2);
                return;
            }
        }
        if ((exportFileChars = this.jtfExportFile.getText().trim()).length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DExportPrivateKeyPvk.ExportFileRequired.message"), res.getString("DExportPrivateKeyPvk.Simple.Title"), 2);
            return;
        }
        File exportFile = new File(exportFileChars);
        if (exportFile.isFile() && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DExportPrivateKeyPvk.OverWriteExportFile.message"), exportFile), res.getString("DExportPrivateKeyPvk.Simple.Title"), 0)) != 0) {
            return;
        }
        this.exportFile = exportFile;
        this.exportSelected = true;
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

