/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.ticker;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.kse.gui.ticker.DefaultTickerModel;
import org.kse.gui.ticker.DefaultTickerRenderer;
import org.kse.gui.ticker.TickerModel;
import org.kse.gui.ticker.TickerRenderer;

public class JTicker
extends JComponent
implements ActionListener,
ListDataListener {
    private static final long serialVersionUID = 1L;
    protected TickerRenderer renderer;
    protected TickerModel model;
    protected int interval = 40;
    protected int increment = 2;
    protected int gap = 20;
    protected CellRendererPane renderPane = new CellRendererPane();
    protected int[] positions;
    protected int offset;
    protected Timer timer;

    public JTicker() {
        this(new DefaultTickerModel());
    }

    public JTicker(TickerModel model) {
        this(model, new DefaultTickerRenderer());
    }

    public JTicker(TickerModel model, TickerRenderer renderer) {
        this.setRenderer(renderer);
        this.setModel(model);
    }

    public void start() {
        this.calculatePositionArray();
        this.setPreferredSize(this.calculatePreferredSize());
        this.offset = this.getWidth();
        this.timer = new Timer(this.interval, this);
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    public void addItem(Object item) {
        this.model.add(item);
    }

    public void removeItem(Object item) {
        this.model.remove(item);
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setRenderer(TickerRenderer renderer) {
        this.renderer = renderer;
        this.calculatePositionArray();
    }

    public TickerRenderer getRenderer() {
        return this.renderer;
    }

    public void setModel(TickerModel model) {
        if (model != null) {
            model.removeListDataListener(this);
            model.addListDataListener(this);
        }
        this.model = model;
        this.calculatePositionArray();
    }

    public TickerModel getModel() {
        return this.model;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.offset -= this.increment;
        int last = this.positions.length - 1;
        int min = -this.positions[last];
        if (this.offset < min) {
            this.offset = 0;
        }
        this.repaint();
    }

    @Override
    public void intervalAdded(ListDataEvent event) {
        this.calculatePositionArray();
        this.setPreferredSize(this.calculatePreferredSize());
    }

    @Override
    public void intervalRemoved(ListDataEvent event) {
        this.calculatePositionArray();
        this.setPreferredSize(this.calculatePreferredSize());
    }

    @Override
    public void contentsChanged(ListDataEvent event) {
        this.calculatePositionArray();
        this.setPreferredSize(this.calculatePreferredSize());
    }

    protected void calculatePositionArray() {
        if (this.model == null) {
            return;
        }
        int pos = 0;
        int items = this.model.getSize();
        this.positions = new int[items + 1];
        this.positions[0] = 0;
        for (int i = 0; i < items; ++i) {
            Object value = this.model.getElementAt(i);
            JComponent component = this.renderer.getTickerRendererComponent(this, value);
            Dimension size = component.getPreferredSize();
            this.positions[i + 1] = pos += size.width + this.gap;
        }
    }

    protected Dimension calculatePreferredSize() {
        int width = (int)this.getPreferredSize().getWidth();
        int height = 0;
        int items = this.model.getSize();
        for (int i = 0; i < items; ++i) {
            Object value = this.model.get(i);
            JComponent component = this.renderer.getTickerRendererComponent(this, value);
            Dimension cell = component.getPreferredSize();
            height = Math.max(height, (int)cell.getHeight());
        }
        Insets insets = this.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int width = this.getSize().width;
        int height = this.getSize().height;
        Insets insets = this.getInsets();
        graphics.setColor(this.getBackground());
        graphics.fillRect(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
        int items = this.model.getSize();
        int right = this.positions[this.positions.length - 1];
        for (int i = 0; i < items * 2; ++i) {
            int index = i < items ? i : i - items;
            int adjust = insets.left + this.offset;
            int head = this.positions[index] + adjust;
            int tail = this.positions[index + 1] + adjust;
            if (i >= items) {
                head += right;
                tail += right;
            }
            if (head >= width || tail <= 0) continue;
            Object value = this.model.getElementAt(index);
            JComponent component = this.renderer.getTickerRendererComponent(this, value);
            Dimension size = component.getPreferredSize();
            this.renderPane.paintComponent(graphics, component, this, head, insets.top, size.width, size.height);
        }
    }
}

