/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.tipoftheday;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.html.HTMLEditorKit;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;

public class DTipOfTheDay
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/tipoftheday/resources");
    private static final String CLOSE_KEY = "CLOSE_KEY";
    private JPanel jpTipOfTheDay;
    private JPanel jpTipMargin;
    private JLabel jlTipMarginBulb;
    private JPanel jpTipBody;
    private JPanel jpTipHeader;
    private JLabel jlTipHeader;
    private JEditorPane jepTip;
    private JScrollPane jspTip;
    private JPanel jpControls;
    private JPanel jpShowTipsOnStartup;
    private JCheckBox jcbShowTipsOnStartup;
    private JPanel jpNavigation;
    private JButton jbPreviousTip;
    private JButton jbNextTip;
    private JButton jbClose;
    private String[] tipsText;
    private int tipIndex;

    public DTipOfTheDay(JFrame parent, boolean showTipsOnStartup, ResourceBundle tips, int tipIndex) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.tipIndex = tipIndex;
        this.readTips(tips, "TipOfTheDayAction.TipOfTheDay");
        this.initComponents(showTipsOnStartup);
    }

    private void initComponents(boolean showTipsOnStartup) {
        this.jpTipOfTheDay = new JPanel(new BorderLayout());
        this.jpTipOfTheDay.setBorder(new CompoundBorder(new EmptyBorder(10, 10, 5, 10), new LineBorder(Color.LIGHT_GRAY, 1)));
        this.jpTipMargin = new JPanel(new FlowLayout());
        this.jpTipMargin.setBackground(Color.LIGHT_GRAY);
        this.jlTipMarginBulb = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/tip.png"))));
        this.jpTipMargin.add(this.jlTipMarginBulb);
        this.jpTipBody = new JPanel(new BorderLayout());
        this.jpTipOfTheDay.add((Component)this.jpTipMargin, "West");
        this.jpTipOfTheDay.add((Component)this.jpTipBody, "Center");
        this.jpTipHeader = new JPanel(new FlowLayout(0));
        this.jpTipHeader.setBackground(Color.WHITE);
        this.jpTipHeader.setBorder(new MatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        this.jlTipHeader = new JLabel(res.getString("DTipOfTheDay.jlTipHeader.text"));
        this.jlTipHeader.setFont(this.jlTipHeader.getFont().deriveFont(1, 18.0f));
        this.jlTipHeader.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jpTipHeader.add(this.jlTipHeader);
        this.jepTip = new JEditorPane();
        this.jepTip.setEditorKit(new HTMLEditorKit());
        this.jepTip.setContentType("text/html");
        this.jepTip.setText(this.getCurrentTip());
        this.jepTip.setEditable(false);
        this.jepTip.setBackground(Color.WHITE);
        this.jepTip.setCaretPosition(0);
        this.jepTip.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.jspTip = PlatformUtil.createScrollPane(20, 31);
        this.jspTip.setPreferredSize(new Dimension(300, 150));
        this.jspTip.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.jspTip.getViewport().add(this.jepTip);
        this.jpTipBody.add((Component)this.jpTipHeader, "North");
        this.jpTipBody.add((Component)this.jspTip, "Center");
        this.jpShowTipsOnStartup = new JPanel(new FlowLayout());
        this.jpShowTipsOnStartup.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jcbShowTipsOnStartup = new JCheckBox(res.getString("DTipOfTheDay.jcbShowTipsOnStartup.text"), showTipsOnStartup);
        PlatformUtil.setMnemonic((AbstractButton)this.jcbShowTipsOnStartup, res.getString("DTipOfTheDay.jcbShowTipsOnStartup.mnemonic").charAt(0));
        this.jpShowTipsOnStartup.add(this.jcbShowTipsOnStartup);
        this.jpNavigation = new JPanel(new FlowLayout());
        this.jpNavigation.setBorder(new EmptyBorder(5, 10, 10, 10));
        this.jbPreviousTip = new JButton(res.getString("DTipOfTheDay.jbPreviousTip.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbPreviousTip, res.getString("DTipOfTheDay.jbPreviousTip.mnemonic").charAt(0));
        this.jbPreviousTip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CursorUtil.setCursorBusy(DTipOfTheDay.this);
                    DTipOfTheDay.this.jepTip.setText(DTipOfTheDay.this.getPreviousTip());
                    DTipOfTheDay.this.jepTip.setCaretPosition(0);
                }
                finally {
                    CursorUtil.setCursorFree(DTipOfTheDay.this);
                }
            }
        });
        this.jbNextTip = new JButton(res.getString("DTipOfTheDay.jbNextTip.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbNextTip, res.getString("DTipOfTheDay.jbNextTip.mnemonic").charAt(0));
        this.jbNextTip.setDefaultCapable(true);
        this.jbNextTip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CursorUtil.setCursorBusy(DTipOfTheDay.this);
                    DTipOfTheDay.this.jepTip.setText(DTipOfTheDay.this.getNextTip());
                    DTipOfTheDay.this.jepTip.setCaretPosition(0);
                }
                finally {
                    CursorUtil.setCursorFree(DTipOfTheDay.this);
                }
            }
        });
        this.jbClose = new JButton(res.getString("DTipOfTheDay.jbClose.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbClose, res.getString("DTipOfTheDay.jbClose.mnemonic").charAt(0));
        this.jbClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DTipOfTheDay.this.closePressed();
            }
        });
        this.jbClose.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CLOSE_KEY);
        this.jbClose.getActionMap().put(CLOSE_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DTipOfTheDay.this.closePressed();
            }
        });
        this.jpNavigation = PlatformUtil.createDialogButtonPanel(this.jbClose, null, new JButton[]{this.jbPreviousTip, this.jbNextTip});
        this.jpNavigation.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jpControls = new JPanel(new BorderLayout());
        this.jpControls.add((Component)this.jpShowTipsOnStartup, "West");
        this.jpControls.add((Component)this.jpNavigation, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)this.jpTipOfTheDay, "Center");
        this.add((Component)this.jpControls, "South");
        this.getRootPane().setDefaultButton(this.jbClose);
        this.setTitle(res.getString("DTipOfTheDay.Title"));
        this.setResizable(false);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DTipOfTheDay.this.jbClose.requestFocus();
            }
        });
    }

    private void readTips(ResourceBundle tips, String tipPrefix) {
        ArrayList<String> tipList = new ArrayList<String>();
        try {
            int i = 0;
            while (true) {
                String tip = tips.getString(tipPrefix + i);
                tipList.add(tip);
                ++i;
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.tipsText = tipList.toArray(new String[tipList.size()]);
            if (this.tipsText.length == 0) {
                throw new IllegalArgumentException(res.getString("NoTipsOfTheDaySupplied.exception.message"));
            }
            return;
        }
    }

    private String getNextTip() {
        this.tipIndex = this.tipIndex + 1 >= this.tipsText.length ? 0 : ++this.tipIndex;
        return this.tipsText[this.tipIndex];
    }

    private String getPreviousTip() {
        this.tipIndex = this.tipIndex - 1 < 0 ? this.tipsText.length - 1 : --this.tipIndex;
        return this.tipsText[this.tipIndex];
    }

    private String getCurrentTip() {
        if (this.tipIndex < 0 || this.tipIndex >= this.tipsText.length) {
            this.tipIndex = 0;
        }
        return this.tipsText[this.tipIndex];
    }

    public boolean showTipsOnStartup() {
        return this.jcbShowTipsOnStartup.isSelected();
    }

    public int nextTipIndex() {
        if (this.tipIndex + 1 >= this.tipsText.length) {
            return 0;
        }
        return this.tipIndex + 1;
    }

    private void closePressed() {
        this.setVisible(false);
        this.dispose();
    }
}

