/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.history;

import java.io.File;
import java.security.KeyStore;
import java.security.Provider;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.utilities.history.AlwaysIdenticalKeyStoreState;
import org.kse.utilities.history.KeyStoreState;

public class KeyStoreHistory {
    private KeyStoreState initialState;
    private KeyStoreState currentState;
    private KeyStoreState savedState;
    private File file;
    private String name;
    private Provider explicitProvider;

    public KeyStoreHistory(KeyStore keyStore, String name, Password password, Provider explicitProvider) {
        this.name = name;
        this.explicitProvider = explicitProvider;
        KeyStoreType type = KeyStoreType.resolveJce(keyStore.getType());
        this.initialState = type.isFileBased() ? new KeyStoreState(this, keyStore, password) : new AlwaysIdenticalKeyStoreState(this, keyStore, password);
        this.currentState = this.initialState;
    }

    public KeyStoreHistory(KeyStore keyStore, File file, Password password) {
        this.file = file;
        this.name = file.getName();
        this.currentState = this.initialState = new KeyStoreState(this, keyStore, password);
        this.savedState = this.initialState;
    }

    public KeyStoreState getCurrentState() {
        return this.currentState;
    }

    public void nullPasswords() {
        KeyStoreState state = this.initialState;
        do {
            state.nullPasswords();
        } while ((state = state.nextState()) != null);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.name = file.getName();
    }

    public String getPath() {
        if (this.file != null) {
            return this.file.getPath();
        }
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    KeyStoreState getInitialState() {
        return this.initialState;
    }

    void setCurrentState(KeyStoreState state) {
        this.currentState = state;
    }

    KeyStoreState getSavedState() {
        return this.savedState;
    }

    void setSavedState(KeyStoreState state) {
        this.savedState = state;
    }

    public Provider getExplicitProvider() {
        return this.explicitProvider;
    }

    public String toString() {
        return this.getName();
    }
}

