/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.kse.utilities.io.IOUtils;

public class CopyUtil {
    private CopyUtil() {
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int i;
        byte[] buffer = new byte[2048];
        while ((i = in.read(buffer)) > 0) {
            out.write(buffer, 0, i);
        }
    }

    public static void copyClose(InputStream in, OutputStream out) throws IOException {
        try {
            CopyUtil.copy(in, out);
        }
        finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        int i;
        char[] buffer = new char[2048];
        while ((i = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, i);
        }
    }

    public static void copyClose(Reader reader, Writer writer) throws IOException {
        try {
            CopyUtil.copy(reader, writer);
        }
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(writer);
        }
    }
}

