/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.oid;

import java.util.Comparator;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kse.utilities.oid.InvalidObjectIdException;
import org.kse.utilities.oid.ObjectIdUtil;

public class ObjectIdComparator
implements Comparator<ASN1ObjectIdentifier> {
    @Override
    public int compare(ASN1ObjectIdentifier oid1, ASN1ObjectIdentifier oid2) {
        int i;
        int[] arcs2;
        int[] arcs1;
        try {
            arcs1 = ObjectIdUtil.extractArcs(oid1);
            arcs2 = ObjectIdUtil.extractArcs(oid2);
        }
        catch (InvalidObjectIdException ex) {
            throw new RuntimeException(ex);
        }
        for (i = 0; i < arcs1.length && i < arcs2.length; ++i) {
            if (arcs1[i] > arcs2[i]) {
                return 1;
            }
            if (arcs1[i] >= arcs2[i]) continue;
            return -1;
        }
        if (arcs2.length > arcs1.length) {
            for (i = arcs1.length; i < arcs2.length; ++i) {
                if (arcs2[i] == 0) continue;
                return -1;
            }
        }
        if (arcs1.length > arcs2.length) {
            for (i = arcs2.length; i < arcs1.length; ++i) {
                if (arcs1[i] == 0) continue;
                return 1;
            }
        }
        return 0;
    }
}

