/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.ssl;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.kse.utilities.ssl.SslConnectionInfos;

public class RetrieveSslInfosHandshakeListener
implements HandshakeCompletedListener {
    private SslConnectionInfos sslConnectionInfos = new SslConnectionInfos();

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        SSLSession session = event.getSession();
        this.sslConnectionInfos.setPeerHost(session.getPeerHost());
        this.sslConnectionInfos.setPeerPort(session.getPeerPort());
        this.sslConnectionInfos.setProtocol(session.getProtocol());
        this.sslConnectionInfos.setCipherSuite(session.getCipherSuite());
        Certificate[] locChain = session.getLocalCertificates();
        if (locChain != null) {
            X509Certificate[] clientCertificates = (X509Certificate[])Arrays.copyOf(locChain, locChain.length, X509Certificate[].class);
            this.sslConnectionInfos.setClientCertificates(clientCertificates);
        }
        try {
            Certificate[] chain = session.getPeerCertificates();
            if (chain != null) {
                X509Certificate[] serverCertificates = (X509Certificate[])Arrays.copyOf(chain, chain.length, X509Certificate[].class);
                this.sslConnectionInfos.setServerCertificates(serverCertificates);
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
    }

    public SslConnectionInfos getSslConnectionInfos() {
        return this.sslConnectionInfos;
    }
}

