/*
 * Decompiled with CFR 0.152.
 */
package org.kse.version;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.kse.version.VersionException;

public class Version
implements Comparable<Object>,
Serializable {
    private static final long serialVersionUID = 775513157889646154L;
    private static transient ResourceBundle res = ResourceBundle.getBundle("org/kse/version/resources");
    private List<Integer> iSections;

    public Version(String version) throws VersionException {
        this(version, ".");
    }

    public Version(String version, String delimiters) {
        StringTokenizer strTok = new StringTokenizer(version.trim(), delimiters);
        ArrayList<Integer> versionSections = new ArrayList<Integer>();
        while (strTok.hasMoreTokens()) {
            try {
                Integer i = new Integer(strTok.nextToken());
                if (i < 0) {
                    throw new VersionException(MessageFormat.format(res.getString("NoParseVersion.exception.message"), version, delimiters));
                }
                versionSections.add(i);
            }
            catch (NumberFormatException ex) {
                throw new VersionException(MessageFormat.format(res.getString("NoParseVersion.exception.message"), version, delimiters));
            }
        }
        if (versionSections.isEmpty()) {
            throw new VersionException(MessageFormat.format(res.getString("NoParseVersion.exception.message"), version, delimiters));
        }
        this.iSections = versionSections;
    }

    private List<Integer> getSections() {
        return new ArrayList<Integer>(this.iSections);
    }

    @Override
    public int compareTo(Object object) {
        int i;
        Version cmpVersion = (Version)object;
        List<Integer> cmpSections = cmpVersion.getSections();
        for (i = 0; i < this.iSections.size() && i < cmpSections.size(); ++i) {
            if (this.iSections.get(i) > cmpSections.get(i)) {
                return 1;
            }
            if (this.iSections.get(i) >= cmpSections.get(i)) continue;
            return -1;
        }
        if (cmpSections.size() > this.iSections.size()) {
            for (i = this.iSections.size(); i < cmpSections.size(); ++i) {
                if (cmpSections.get(i) == 0) continue;
                return -1;
            }
        }
        if (this.iSections.size() > cmpSections.size()) {
            for (i = cmpSections.size(); i < this.iSections.size(); ++i) {
                if (this.iSections.get(i) == 0) continue;
                return 1;
            }
        }
        return 0;
    }

    public int getMajor() {
        return this.iSections.get(0);
    }

    public int getMinor() {
        if (this.iSections.size() > 1) {
            return this.iSections.get(1);
        }
        return 0;
    }

    public int getBugfix() {
        if (this.iSections.size() > 2) {
            return this.iSections.get(2);
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        int result = 27;
        for (Integer integer : this.iSections) {
            result = 53 * result + integer;
        }
        return result;
    }

    public String toString() {
        StringBuffer strBuff = new StringBuffer();
        for (int i = 0; i < this.iSections.size(); ++i) {
            strBuff.append(this.iSections.get(i));
            if (i + 1 >= this.iSections.size()) continue;
            strBuff.append('.');
        }
        return strBuff.toString();
    }
}

