/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class LinearSliderRenderer
extends Renderer {
    @NotNull
    private static final ReusableCompositor.PixelOperator blender = new Blender();
    @NotNull
    protected final SliderConfiguration g;
    @NotNull
    protected final Renderer trackRenderer;
    @NotNull
    protected final Insetter trackInsets;
    @Nullable
    protected final Renderer tickMarkRenderer;
    @NotNull
    protected final Renderer thumbRenderer;
    @NotNull
    protected final Insetter thumbInsets;
    protected final boolean isThumbTranslucent;

    public LinearSliderRenderer(@NotNull SliderConfiguration sliderConfiguration, @NotNull Renderer renderer, @NotNull Insetter insetter, @Nullable Renderer renderer2, @NotNull Renderer renderer3, @NotNull Insetter insetter2, boolean bl) {
        this.g = sliderConfiguration;
        this.trackRenderer = renderer;
        this.trackInsets = insetter;
        this.tickMarkRenderer = renderer2;
        this.thumbRenderer = renderer3;
        this.thumbInsets = insetter2;
        this.isThumbTranslucent = bl;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
        float f = reusableCompositor.getWidth();
        float f2 = reusableCompositor.getHeight();
        Rectangle2D rectangle2D = this.trackInsets.apply2D(f, f2);
        Renderer renderer = Renderer.createOffsetRenderer(this.trackRenderer, rectangle2D);
        renderer.composeTo(reusableCompositor);
        if (this.tickMarkRenderer != null) {
            this.tickMarkRenderer.composeTo(reusableCompositor);
        }
        rectangle2D = this.thumbInsets.apply2D(f, f2);
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        Renderer renderer2 = Renderer.createOffsetRenderer(this.thumbRenderer, d, d2, rectangle2D.getWidth(), rectangle2D.getHeight());
        if (this.isThumbTranslucent) {
            ReusableCompositor reusableCompositor2 = reusableCompositor.createSimilar();
            renderer2.composeTo(reusableCompositor2);
            reusableCompositor.blendFrom(reusableCompositor2, blender);
        } else {
            renderer2.composeTo(reusableCompositor);
        }
    }

    private static class Blender
    implements ReusableCompositor.PixelOperator {
        private Blender() {
        }

        @Override
        public int combine(int n, int n2) {
            int n3 = n2 >> 24 & 0xFF;
            if (n3 == 0) {
                return n;
            }
            if (n3 > 20) {
                return n2;
            }
            return JNRUtils.combine(n, n2);
        }
    }
}

