/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.treetable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.violetlib.treetable.AbstractTreeColumnModel;
import org.violetlib.treetable.MutableTreeTableNode;
import org.violetlib.treetable.TreeTableNode;

public class DefaultTreeColumnModel
extends AbstractTreeColumnModel {
    private List<?> columnNames;
    private int editableColumns = -1;
    private int hierarchialColumn;
    private TreeTableNode root;

    public DefaultTreeColumnModel(int n) {
        this(null, n);
    }

    public DefaultTreeColumnModel(TreeTableNode treeTableNode) {
        this(treeTableNode, Collections.nCopies(treeTableNode.getColumnCount(), null));
    }

    public DefaultTreeColumnModel(TreeTableNode treeTableNode, Object ... objectArray) {
        this(treeTableNode, Arrays.asList(objectArray));
    }

    public DefaultTreeColumnModel(TreeTableNode treeTableNode, List<?> list) {
        this.root = treeTableNode;
        this.columnNames = list;
    }

    @Override
    public String getColumnName(int n) {
        Object obj = this.columnNames.get(n);
        String string = obj == null ? null : obj.toString();
        return string != null ? string : super.getColumnName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (this.root == null) {
            return Object.class;
        }
        Object object = this.root.getValueAt(n);
        if (object instanceof Class) {
            return (Class)object;
        }
        return object == null ? Object.class : object.getClass();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public Object getValueAt(Object object, int n) {
        return ((TreeTableNode)object).getValueAt(n);
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
        ((MutableTreeTableNode)object2).setValueAt(this.convertValue(object, object2, n), n);
        this.fireTreeColumnChanged(DefaultTreeColumnModel.pathToRoot(this.root, (TreeNode)object2), n);
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return (this.editableColumns & 1 << n) != 0;
    }

    public void setAllColumnsEditable(boolean bl) {
        this.editableColumns = bl ? -1 : 0;
    }

    public void setColumnEditable(int n, boolean bl) {
        if (n > 31) {
            throw new IllegalArgumentException();
        }
        this.editableColumns = bl ? (this.editableColumns |= 1 << n) : (this.editableColumns &= ~(1 << n));
    }

    @Override
    public int getHierarchicalColumn() {
        return this.hierarchialColumn;
    }

    public void setHierarchialColumn(int n) {
        this.hierarchialColumn = n;
    }
}

