/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.digest;

public enum DigestType {
    MD2("MD2", "1.2.840.113549.2.2", "MD2"),
    MD4("MD4", "1.2.840.113549.2.4", "MD4"),
    MD5("MD5", "1.2.840.113549.2.5", "MD5"),
    RIPEMD128("RIPEMD128", "1.3.36.3.2.2", "RIPEMD-128"),
    RIPEMD160("RIPEMD160", "1.3.36.3.2.1", "RIPEMD-160"),
    RIPEMD256("RIPEMD256", "1.3.36.3.2.3", "RIPEMD-256"),
    SHA1("SHA1", "1.3.14.3.2.26", "SHA-1"),
    SHA224("SHA-224", "2.16.840.1.101.3.4.2.4", "SHA-224"),
    SHA256("SHA-256", "2.16.840.1.101.3.4.2.1", "SHA-256"),
    SHA384("SHA-384", "2.16.840.1.101.3.4.2.2", "SHA-384"),
    SHA512("SHA-512", "2.16.840.1.101.3.4.2.3", "SHA-512"),
    SHA3_224("SHA3-224", "2.16.840.1.101.3.4.2.7", "SHA3-224"),
    SHA3_256("SHA3-256", "2.16.840.1.101.3.4.2.8", "SHA3-256"),
    SHA3_384("SHA3-384", "2.16.840.1.101.3.4.2.9", "SHA3-384"),
    SHA3_512("SHA3-512", "2.16.840.1.101.3.4.2.10", "SHA3-512");

    private String jce;
    private String oid;
    private String friendly;

    private DigestType(String jce, String oid, String friendly) {
        this.jce = jce;
        this.oid = oid;
        this.friendly = friendly;
    }

    public String jce() {
        return this.jce;
    }

    public String oid() {
        return this.oid;
    }

    public String friendly() {
        return this.friendly;
    }

    public static DigestType resolveJce(String jce) {
        for (DigestType digestType : DigestType.values()) {
            if (!jce.equals(digestType.jce())) continue;
            return digestType;
        }
        return null;
    }

    public String toString() {
        return this.friendly();
    }
}

