/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.digest;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.kse.crypto.CryptoException;
import org.kse.crypto.digest.DigestType;
import org.kse.utilities.io.HexUtil;
import org.kse.utilities.io.IOUtils;

public final class DigestUtil {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/digest/resources");

    private DigestUtil() {
    }

    public static byte[] getMessageDigest(InputStream istream, DigestType digestType) throws CryptoException {
        MessageDigest messageDigester = DigestUtil.getMessageDigester(digestType);
        try {
            byte[] messageDigest;
            byte[] buffer = new byte[2048];
            int read = 0;
            while ((read = istream.read(buffer)) != -1) {
                messageDigester.update(buffer, 0, read);
            }
            byte[] byArray = messageDigest = messageDigester.digest();
            return byArray;
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("NoCreateDigest.exception.message"), ex);
        }
        finally {
            IOUtils.closeQuietly(istream);
        }
    }

    public static byte[] getMessageDigest(byte[] message, DigestType digestType) throws CryptoException {
        MessageDigest messageDigester = DigestUtil.getMessageDigester(digestType);
        return messageDigester.digest(message);
    }

    public static String getFriendlyMessageDigest(byte[] message, DigestType digestType) throws CryptoException {
        byte[] messageDigest = DigestUtil.getMessageDigest(message, digestType);
        return HexUtil.getHexStringWithSep(messageDigest, ':');
    }

    public static MessageDigest getMessageDigester(DigestType digestType) throws CryptoException {
        try {
            return MessageDigest.getInstance(digestType.jce());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoCreateDigester.exception.message"), digestType.jce()), ex);
        }
    }
}

