/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.filetype;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLSequence;
import org.kse.crypto.csr.CsrType;
import org.kse.crypto.csr.pkcs10.Pkcs10Util;
import org.kse.crypto.csr.spkac.Spkac;
import org.kse.crypto.csr.spkac.SpkacException;
import org.kse.crypto.filetype.CryptoFileType;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.privatekey.EncryptionType;
import org.kse.crypto.privatekey.MsPvkUtil;
import org.kse.crypto.privatekey.OpenSslPvkUtil;
import org.kse.crypto.privatekey.Pkcs8Util;
import org.kse.crypto.publickey.OpenSslPubUtil;
import org.kse.crypto.x509.X509CertUtil;

public class CryptoFileUtil {
    private static final int JKS_MAGIC_NUMBER = -17957139;
    private static final int JCEKS_MAGIC_NUMBER = -825307442;

    private CryptoFileUtil() {
    }

    public static CryptoFileType detectFileType(File file) throws IOException {
        return CryptoFileUtil.detectFileType(FileUtils.readFileToByteArray((File)file));
    }

    public static CryptoFileType detectFileType(byte[] data) throws IOException {
        EncryptionType openSslPvkEncType;
        EncryptionType msPvkEncType;
        EncryptionType pkcs8EncType = Pkcs8Util.getEncryptionType(data);
        if (pkcs8EncType != null) {
            if (pkcs8EncType == EncryptionType.ENCRYPTED) {
                return CryptoFileType.ENC_PKCS8_PVK;
            }
            if (pkcs8EncType == EncryptionType.UNENCRYPTED) {
                return CryptoFileType.UNENC_PKCS8_PVK;
            }
        }
        if ((msPvkEncType = MsPvkUtil.getEncryptionType(data)) != null) {
            if (msPvkEncType == EncryptionType.ENCRYPTED) {
                return CryptoFileType.ENC_MS_PVK;
            }
            if (msPvkEncType == EncryptionType.UNENCRYPTED) {
                return CryptoFileType.UNENC_MS_PVK;
            }
        }
        if ((openSslPvkEncType = OpenSslPvkUtil.getEncryptionType(data)) != null) {
            if (openSslPvkEncType == EncryptionType.ENCRYPTED) {
                return CryptoFileType.ENC_OPENSSL_PVK;
            }
            if (openSslPvkEncType == EncryptionType.UNENCRYPTED) {
                return CryptoFileType.UNENC_OPENSSL_PVK;
            }
        }
        try {
            OpenSslPubUtil.load(data);
            return CryptoFileType.OPENSSL_PUB;
        }
        catch (Exception exception) {
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            if (X509CertUtil.loadCertificates(data).length > 0) {
                return CryptoFileType.CERT;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            X509CertUtil.loadCRL(data);
            return CryptoFileType.CRL;
        }
        catch (Exception exception) {
            CsrType csrType = CryptoFileUtil.detectCsrType(data);
            if (csrType != null) {
                return csrType.getCryptoFileType();
            }
            KeyStoreType keyStoreType = CryptoFileUtil.detectKeyStoreType(data);
            if (keyStoreType != null) {
                return keyStoreType.getCryptoFileType();
            }
            return CryptoFileType.UNKNOWN;
        }
    }

    private static CsrType detectCsrType(byte[] csrData) throws IOException {
        try {
            Pkcs10Util.loadCsr(csrData);
            return CsrType.PKCS10;
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (Exception exception) {
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            new Spkac(csrData);
            return CsrType.SPKAC;
        }
        catch (SpkacException spkacException) {
            return null;
        }
    }

    public static KeyStoreType detectKeyStoreType(File file) throws IOException {
        return CryptoFileUtil.detectKeyStoreType(FileUtils.readFileToByteArray((File)file));
    }

    public static KeyStoreType detectKeyStoreType(byte[] data) throws IOException {
        ASN1Sequence sequence;
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));){
            if (dis.available() < 4) {
                KeyStoreType keyStoreType = null;
                return keyStoreType;
            }
            int i1 = dis.readInt();
            if (i1 == -17957139) {
                KeyStoreType keyStoreType = KeyStoreType.JKS;
                return keyStoreType;
            }
            if (i1 == -825307442) {
                KeyStoreType keyStoreType = KeyStoreType.JCEKS;
                return keyStoreType;
            }
            if (i1 == 0 || i1 == 1 || i1 == 2) {
                if (data.length < 26) {
                    KeyStoreType keyStoreType = null;
                    return keyStoreType;
                }
                dis.skip((long)data.length - 25L);
                if (dis.readByte() == 0) {
                    if (i1 == 1) {
                        KeyStoreType keyStoreType = KeyStoreType.BKS_V1;
                        return keyStoreType;
                    }
                    KeyStoreType keyStoreType = KeyStoreType.BKS;
                    return keyStoreType;
                }
                KeyStoreType keyStoreType = KeyStoreType.UBER;
                return keyStoreType;
            }
        }
        ASN1Primitive pfx = null;
        try {
            pfx = ASN1Primitive.fromByteArray((byte[])data);
        }
        catch (IOException e) {
            return null;
        }
        if (pfx != null && pfx instanceof ASN1Sequence && ((sequence = (ASN1Sequence)pfx).size() == 2 || sequence.size() == 3)) {
            ASN1Encodable firstComponent = sequence.getObjectAt(0);
            if (firstComponent instanceof ASN1Integer) {
                ASN1Integer version = (ASN1Integer)firstComponent;
                if (version.getValue().intValue() == 3) {
                    return KeyStoreType.PKCS12;
                }
            } else if (firstComponent instanceof DLSequence) {
                return KeyStoreType.BCFKS;
            }
        }
        return null;
    }
}

