/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.publickey;

import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.kse.crypto.CryptoException;
import org.kse.crypto.digest.DigestType;
import org.kse.crypto.digest.DigestUtil;

public class KeyIdentifierGenerator {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/publickey/resources");
    private PublicKey publicKey;

    public KeyIdentifierGenerator(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public byte[] generate160BitHashId() throws CryptoException {
        try {
            DERBitString publicKeyBitString = this.encodePublicKeyAsBitString(this.publicKey);
            return DigestUtil.getMessageDigest(publicKeyBitString.getBytes(), DigestType.SHA1);
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("NoGenerateKeyIdentifier.exception.message"), ex);
        }
    }

    public byte[] generate64BitHashId() throws CryptoException {
        try {
            DERBitString publicKeyBitString = this.encodePublicKeyAsBitString(this.publicKey);
            byte[] hash = DigestUtil.getMessageDigest(publicKeyBitString.getBytes(), DigestType.SHA1);
            byte[] subHash = Arrays.copyOfRange(hash, 12, 20);
            subHash[0] = (byte)(subHash[0] & 0xF);
            subHash[0] = (byte)(subHash[0] | 0x40);
            return subHash;
        }
        catch (IOException ex) {
            throw new CryptoException(res.getString("NoGenerateKeyIdentifier.exception.message"), ex);
        }
    }

    private DERBitString encodePublicKeyAsBitString(PublicKey publicKey) throws IOException {
        byte[] encodedPublicKey = publicKey instanceof RSAPublicKey ? this.encodeRsaPublicKeyAsBitString((RSAPublicKey)publicKey) : (publicKey instanceof ECPublicKey ? this.encodeEcPublicKeyAsBitString((ECPublicKey)publicKey) : this.encodeDsaPublicKeyAsBitString((DSAPublicKey)publicKey));
        return new DERBitString(encodedPublicKey);
    }

    private byte[] encodeRsaPublicKeyAsBitString(RSAPublicKey rsaPublicKey) throws IOException {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1Integer(rsaPublicKey.getModulus()));
        vec.add((ASN1Encodable)new ASN1Integer(rsaPublicKey.getPublicExponent()));
        DERSequence derSequence = new DERSequence(vec);
        return derSequence.getEncoded();
    }

    private byte[] encodeEcPublicKeyAsBitString(ECPublicKey ecPublicKey) {
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)ecPublicKey.getEncoded());
        byte[] bytes = publicKeyInfo.getPublicKeyData().getBytes();
        return bytes;
    }

    private byte[] encodeDsaPublicKeyAsBitString(DSAPublicKey dsaPublicKey) throws IOException {
        ASN1Integer publicKey = new ASN1Integer(dsaPublicKey.getY());
        return publicKey.getEncoded("DER");
    }
}

