/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.signing;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.kse.crypto.CryptoException;
import org.kse.crypto.digest.DigestType;
import org.kse.crypto.digest.DigestUtil;
import org.kse.crypto.signing.SignatureType;
import org.kse.crypto.signing.TimeStampingClient;
import org.kse.utilities.io.CopyUtil;

public class JarSigner {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/signing/resources");
    private static final String CRLF = "\r\n";
    private static final String ATTR_TEMPLATE = "{0}: {1}";
    private static final String MANIFEST_VERSION_ATTR = "Manifest-Version";
    private static final String MANIFEST_VERSION = "1.0";
    private static final String CREATED_BY_ATTR = "Created-By";
    private static final String DIGEST_ATTR = "{0}-Digest";
    private static final String NAME_ATTR = "Name";
    private static final String DIGEST_MANIFEST_ATTR = "{0}-Digest-Manifest";
    private static final String DIGEST_MANIFEST_MAIN_ATTRIBUTES_ATTR = "{0}-Digest-Manifest-Main-Attributes";
    private static final String SIGNATURE_VERSION_ATTR = "Signature-Version";
    private static final String SIGNATURE_VERSION = "1.0";
    private static final String MANIFEST_LOCATION = "META-INF/MANIFEST.MF";
    private static final String DSA_SIG_BLOCK_EXT = "DSA";
    private static final String RSA_SIG_BLOCK_EXT = "RSA";
    private static final String SIGNATURE_EXT = "SF";
    private static final String METAINF_FILE_LOCATION = "META-INF/{0}.{1}";

    private JarSigner() {
    }

    public static void sign(File jsrFile, PrivateKey privateKey, X509Certificate[] certificateChain, SignatureType signatureType, String signatureName, String signer, DigestType digestType, String tsaUrl, Provider provider) throws IOException, CryptoException {
        File tmpFile = File.createTempFile("kse", "tmp");
        tmpFile.deleteOnExit();
        JarSigner.sign(jsrFile, tmpFile, privateKey, certificateChain, signatureType, signatureName, signer, digestType, tsaUrl, provider);
        CopyUtil.copyClose(new FileInputStream(tmpFile), new FileOutputStream(jsrFile));
        tmpFile.delete();
    }

    public static void sign(File jarFile, File signedJarFile, PrivateKey privateKey, X509Certificate[] certificateChain, SignatureType signatureType, String signatureName, String signer, DigestType digestType, String tsaUrl, Provider provider) throws IOException, CryptoException {
        try (JarFile jar = new JarFile(jarFile);
             JarOutputStream jos = new JarOutputStream(new FileOutputStream(signedJarFile));){
            signatureName = JarSigner.convertSignatureName(signatureName);
            StringBuilder sbManifest = new StringBuilder();
            String manifestMainAttrs = JarSigner.getManifestMainAttrs(jar, signer);
            sbManifest.append(manifestMainAttrs);
            String entryManifestAttrs = JarSigner.getManifestEntriesAttrs(jar);
            if (entryManifestAttrs.length() > 0) {
                sbManifest.append(entryManifestAttrs);
                sbManifest.append(CRLF);
            }
            StringBuilder sbSf = new StringBuilder();
            Enumeration<JarEntry> jarEntries = jar.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                if (jarEntry.isDirectory() || JarSigner.ignoreJarEntry(jarEntry)) continue;
                String manifestEntry = JarSigner.getDigestManifestAttrs(jar, jarEntry, digestType);
                sbManifest.append(manifestEntry);
                byte[] mdSf = DigestUtil.getMessageDigest(manifestEntry.getBytes(), digestType);
                byte[] mdSf64 = Base64.encode((byte[])mdSf);
                String mdSf64Str = new String(mdSf64);
                sbSf.append(JarSigner.createAttributeText(NAME_ATTR, jarEntry.getName()));
                sbSf.append(CRLF);
                sbSf.append(JarSigner.createAttributeText(MessageFormat.format(DIGEST_ATTR, digestType.jce()), mdSf64Str));
                sbSf.append(CRLF);
                sbSf.append(CRLF);
            }
            byte[] manifest = sbManifest.toString().getBytes();
            byte[] digestMf = DigestUtil.getMessageDigest(manifest, digestType);
            String digestMfStr = new String(Base64.encode((byte[])digestMf));
            byte[] mainfestMainAttrs = manifestMainAttrs.getBytes();
            byte[] digestMfMainAttrs = DigestUtil.getMessageDigest(mainfestMainAttrs, digestType);
            String digestMfMainAttrsStr = new String(Base64.encode((byte[])digestMfMainAttrs));
            sbSf.insert(0, CRLF);
            sbSf.insert(0, CRLF);
            sbSf.insert(0, JarSigner.createAttributeText(MessageFormat.format(DIGEST_MANIFEST_ATTR, digestType.jce()), digestMfStr));
            sbSf.insert(0, CRLF);
            sbSf.insert(0, JarSigner.createAttributeText(MessageFormat.format(DIGEST_MANIFEST_MAIN_ATTRIBUTES_ATTR, digestType.jce()), digestMfMainAttrsStr));
            sbSf.insert(0, CRLF);
            sbSf.insert(0, JarSigner.createAttributeText(CREATED_BY_ATTR, signer));
            sbSf.insert(0, CRLF);
            sbSf.insert(0, JarSigner.createAttributeText(SIGNATURE_VERSION_ATTR, "1.0"));
            byte[] sf = sbSf.toString().getBytes();
            JarSigner.writeJarEntries(jar, jos, signatureName);
            JarSigner.writeManifest(manifest, jos);
            JarSigner.writeSignatureFile(sf, signatureName, jos);
            byte[] sigBlock = JarSigner.createSignatureBlock(sf, privateKey, certificateChain, signatureType, tsaUrl, provider);
            JarSigner.writeSignatureBlock(sigBlock, signatureType, signatureName, jos);
        }
    }

    private static boolean ignoreJarEntry(JarEntry jarEntry) {
        String entryName = jarEntry.getName();
        if (entryName.startsWith("META-INF/")) {
            if (entryName.equalsIgnoreCase(MANIFEST_LOCATION)) {
                return true;
            }
            if (entryName.toUpperCase().endsWith(SIGNATURE_EXT)) {
                return true;
            }
            if (entryName.toUpperCase().endsWith(RSA_SIG_BLOCK_EXT)) {
                return true;
            }
            if (entryName.toUpperCase().endsWith(DSA_SIG_BLOCK_EXT)) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasSignature(File jarFile, String signatureName) throws IOException {
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> jarEntries = jar.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().equalsIgnoreCase(MessageFormat.format(METAINF_FILE_LOCATION, signatureName, DSA_SIG_BLOCK_EXT)) && !jarEntry.getName().equalsIgnoreCase(MessageFormat.format(METAINF_FILE_LOCATION, signatureName, RSA_SIG_BLOCK_EXT))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static String getManifestMainAttrs(JarFile jar, String signer) throws IOException {
        StringBuilder sbManifest = new StringBuilder();
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            sbManifest.append(JarSigner.createAttributeText(MANIFEST_VERSION_ATTR, "1.0"));
            sbManifest.append(CRLF);
            sbManifest.append(JarSigner.createAttributeText(CREATED_BY_ATTR, signer));
            sbManifest.append(CRLF);
            sbManifest.append(CRLF);
        } else {
            String manifestMainAttrs = JarSigner.getManifestMainAttrs(jar);
            sbManifest.append(manifestMainAttrs);
            sbManifest.append(CRLF);
        }
        return sbManifest.toString();
    }

    private static String getManifestEntriesAttrs(JarFile jar) throws IOException {
        StringBuilder sbManifest = new StringBuilder();
        Manifest manifest = jar.getManifest();
        if (manifest != null) {
            Map<String, Attributes> entries = manifest.getEntries();
            boolean firstEntry = true;
            for (String entryName : entries.keySet()) {
                Attributes entryAttrs = entries.get(entryName);
                if (entryAttrs.size() == 1 && entryAttrs.keySet().toArray()[0].toString().endsWith("-Digest")) continue;
                if (!firstEntry) {
                    sbManifest.append(CRLF);
                }
                String manifestEntryAttributes = JarSigner.getManifestEntryAttrs(jar, entryName);
                sbManifest.append(manifestEntryAttributes);
                firstEntry = false;
            }
        }
        return sbManifest.toString();
    }

    private static String getDigestManifestAttrs(JarFile jar, JarEntry jarEntry, DigestType digestType) throws IOException, CryptoException {
        try (InputStream jis = jar.getInputStream(jarEntry);){
            byte[] md = DigestUtil.getMessageDigest(jis, digestType);
            byte[] md64 = Base64.encode((byte[])md);
            String md64Str = new String(md64);
            StringBuilder sbManifestEntry = new StringBuilder();
            sbManifestEntry.append(JarSigner.createAttributeText(NAME_ATTR, jarEntry.getName()));
            sbManifestEntry.append(CRLF);
            sbManifestEntry.append(JarSigner.createAttributeText(MessageFormat.format(DIGEST_ATTR, digestType.jce()), md64Str));
            sbManifestEntry.append(CRLF);
            sbManifestEntry.append(CRLF);
            String string = sbManifestEntry.toString();
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    private static String getManifest(JarFile jar) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static String getManifestMainAttrs(JarFile jar) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static String getManifestEntryAttrs(JarFile jar, String entryName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void writeJarEntries(JarFile jar, JarOutputStream jos, String signatureName) throws IOException {
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory()) continue;
            String entryName = jarEntry.getName();
            String sigFileLocation = MessageFormat.format(METAINF_FILE_LOCATION, signatureName, SIGNATURE_EXT).toUpperCase();
            String dsaSigBlockLocation = MessageFormat.format(METAINF_FILE_LOCATION, signatureName, DSA_SIG_BLOCK_EXT);
            String rsaSigBlockLocation = MessageFormat.format(METAINF_FILE_LOCATION, signatureName, RSA_SIG_BLOCK_EXT);
            if (entryName.equalsIgnoreCase(MANIFEST_LOCATION) || entryName.equalsIgnoreCase(sigFileLocation) || entryName.equalsIgnoreCase(dsaSigBlockLocation) || entryName.equalsIgnoreCase(rsaSigBlockLocation)) continue;
            JarEntry newJarEntry = new JarEntry(jarEntry.getName());
            newJarEntry.setMethod(jarEntry.getMethod());
            newJarEntry.setCompressedSize(jarEntry.getCompressedSize());
            newJarEntry.setCrc(jarEntry.getCrc());
            jos.putNextEntry(newJarEntry);
            InputStream jis = jar.getInputStream(jarEntry);
            Throwable throwable = null;
            try {
                byte[] buffer = new byte[2048];
                int read = -1;
                while ((read = jis.read(buffer)) != -1) {
                    jos.write(buffer, 0, read);
                }
                jos.closeEntry();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jis == null) continue;
                if (throwable != null) {
                    try {
                        jis.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                jis.close();
            }
        }
    }

    private static void writeManifest(byte[] manifest, JarOutputStream jos) throws IOException {
        JarEntry mfJarEntry = new JarEntry(MANIFEST_LOCATION);
        jos.putNextEntry(mfJarEntry);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(manifest);){
            byte[] buffer = new byte[2048];
            int read = -1;
            while ((read = bais.read(buffer)) != -1) {
                jos.write(buffer, 0, read);
            }
            jos.closeEntry();
        }
    }

    private static void writeSignatureFile(byte[] sf, String signatureName, JarOutputStream jos) throws IOException {
        JarEntry sfJarEntry = new JarEntry(MessageFormat.format(METAINF_FILE_LOCATION, signatureName, SIGNATURE_EXT).toUpperCase());
        jos.putNextEntry(sfJarEntry);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(sf);){
            byte[] buffer = new byte[2048];
            int read = -1;
            while ((read = bais.read(buffer)) != -1) {
                jos.write(buffer, 0, read);
            }
            jos.closeEntry();
        }
    }

    private static void writeSignatureBlock(byte[] sigBlock, SignatureType signatureType, String signatureName, JarOutputStream jos) throws IOException {
        String extension = null;
        extension = signatureType == SignatureType.SHA1_DSA ? DSA_SIG_BLOCK_EXT : RSA_SIG_BLOCK_EXT;
        JarEntry bkJarEntry = new JarEntry(MessageFormat.format(METAINF_FILE_LOCATION, signatureName, extension).toUpperCase());
        jos.putNextEntry(bkJarEntry);
        ByteArrayInputStream bais = new ByteArrayInputStream(sigBlock);
        byte[] buffer = new byte[2048];
        int read = -1;
        while ((read = bais.read(buffer)) != -1) {
            jos.write(buffer, 0, read);
        }
        jos.closeEntry();
    }

    private static String createAttributeText(String attributeName, String attributeValue) {
        String attributeText = MessageFormat.format(ATTR_TEMPLATE, attributeName, attributeValue);
        StringBuilder sb = new StringBuilder();
        String remainingText = attributeText;
        while (remainingText.length() > 70) {
            sb.append(remainingText.substring(0, 70));
            sb.append(CRLF);
            sb.append(" ");
            remainingText = remainingText.substring(70);
        }
        sb.append(remainingText);
        return sb.toString();
    }

    private static byte[] createSignatureBlock(byte[] toSign, PrivateKey privateKey, X509Certificate[] certificateChain, SignatureType signatureType, String tsaUrl, Provider provider) throws CryptoException {
        try {
            ArrayList certList = new ArrayList();
            Collections.addAll(certList, certificateChain);
            DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
            JcaContentSignerBuilder csb = new JcaContentSignerBuilder(signatureType.jce()).setSecureRandom(SecureRandom.getInstance("SHA1PRNG"));
            if (provider != null) {
                csb.setProvider(provider);
            }
            JcaSignerInfoGeneratorBuilder siGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(digCalcProv);
            SignerInfoGenerator sigGen = siGeneratorBuilder.build(csb.build(privateKey), certificateChain[0]);
            final CMSAttributeTableGenerator sAttrGen = sigGen.getSignedAttributeTableGenerator();
            sigGen = new SignerInfoGenerator(sigGen, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(){

                public AttributeTable getAttributes(Map parameters) {
                    AttributeTable ret = sAttrGen.getAttributes(parameters);
                    return ret.remove(CMSAttributes.cmsAlgorithmProtect);
                }
            }, sigGen.getUnsignedAttributeTableGenerator());
            CMSSignedDataGenerator dataGen = new CMSSignedDataGenerator();
            dataGen.addSignerInfoGenerator(sigGen);
            dataGen.addCertificates((Store)new JcaCertStore(certList));
            CMSSignedData signedData = dataGen.generate((CMSTypedData)new CMSProcessableByteArray(toSign), true);
            if (tsaUrl != null && !tsaUrl.isEmpty()) {
                signedData = JarSigner.addTimestamp(tsaUrl, signedData);
            }
            return signedData.getEncoded();
        }
        catch (Exception ex) {
            throw new CryptoException(res.getString("SignatureBlockCreationFailed.exception.message"), ex);
        }
    }

    private static CMSSignedData addTimestamp(String tsaUrl, CMSSignedData signedData) throws IOException {
        Collection signerInfos = signedData.getSignerInfos().getSigners();
        SignerInformation si = (SignerInformation)signerInfos.iterator().next();
        byte[] signature = si.getSignature();
        byte[] token = TimeStampingClient.getTimeStampToken(tsaUrl, signature, DigestType.SHA256);
        Attribute tokenAttr = new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Set)new DERSet((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])token)));
        ASN1EncodableVector timestampVector = new ASN1EncodableVector();
        timestampVector.add((ASN1Encodable)tokenAttr);
        AttributeTable at = new AttributeTable(timestampVector);
        si = SignerInformation.replaceUnsignedAttributes((SignerInformation)si, (AttributeTable)at);
        signerInfos.clear();
        signerInfos.add(si);
        SignerInformationStore newSignerStore = new SignerInformationStore(signerInfos);
        CMSSignedData newSignedData = CMSSignedData.replaceSigners((CMSSignedData)signedData, (SignerInformationStore)newSignerStore);
        return newSignedData;
    }

    private static String convertSignatureName(String signatureName) {
        StringBuilder sb = new StringBuilder(signatureName.length());
        for (int i = 0; i < signatureName.length(); ++i) {
            int c = signatureName.charAt(i);
            if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 45 || c == 95)) {
                c = 95;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }
}

