/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.util.ResourceBundle;

public enum AccessMethodType {
    OCSP("1.3.6.1.5.5.7.48.1", "OcspAccessMethod"),
    CA_ISSUERS("1.3.6.1.5.5.7.48.2", "CaIssuersAccessMethod"),
    TIME_STAMPING("1.3.6.1.5.5.7.48.3", "TimeStampingAccessMethod"),
    CA_REPOSITORY("1.3.6.1.5.5.7.48.5", "CaRepositoryAccessMethod");

    private static ResourceBundle res;
    private String oid;
    private String friendlyKey;

    private AccessMethodType(String oid, String friendlyKey) {
        this.oid = oid;
        this.friendlyKey = friendlyKey;
    }

    public String friendly() {
        return res.getString(this.friendlyKey);
    }

    public static AccessMethodType resolveOid(String oid) {
        for (AccessMethodType type : AccessMethodType.values()) {
            if (!oid.equals(type.oid())) continue;
            return type;
        }
        return null;
    }

    public String oid() {
        return this.oid;
    }

    static {
        res = ResourceBundle.getBundle("org/kse/crypto/x509/resources");
    }
}

