/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.util.ResourceBundle;

public enum CertificatePolicyQualifierType {
    PKIX_CPS_POINTER_QUALIFIER("1.3.6.1.5.5.7.2.1", "PkixCpsPointerQualifier"),
    PKIX_USER_NOTICE_QUALIFIER("1.3.6.1.5.5.7.2.2", "PkixUserNoticeQualifier");

    private static ResourceBundle res;
    private String oid;
    private String friendlyKey;

    private CertificatePolicyQualifierType(String oid, String friendlyKey) {
        this.oid = oid;
        this.friendlyKey = friendlyKey;
    }

    public String friendly() {
        return res.getString(this.friendlyKey);
    }

    public static CertificatePolicyQualifierType resolveOid(String oid) {
        for (CertificatePolicyQualifierType type : CertificatePolicyQualifierType.values()) {
            if (!oid.equals(type.oid())) continue;
            return type;
        }
        return null;
    }

    public String oid() {
        return this.oid;
    }

    static {
        res = ResourceBundle.getBundle("org/kse/crypto/x509/resources");
    }
}

