/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

public enum QcStatementType {
    QC_SYNTAX_V1("1.3.6.1.5.5.7.11.1", "QCSyntaxV1"),
    QC_SYNTAX_V2("1.3.6.1.5.5.7.11.2", "QCSyntaxV2"),
    QC_COMPLIANCE("0.4.0.1862.1.1", "QCCompliance"),
    QC_EU_LIMIT_VALUE("0.4.0.1862.1.2", "QCEuLimitValue"),
    QC_RETENTION_PERIOD("0.4.0.1862.1.3", "QCRetentionPeriod"),
    QC_SSCD("0.4.0.1862.1.4", "QCSSCD"),
    QC_PDS("0.4.0.1862.1.5", "QCPDS"),
    QC_TYPE("0.4.0.1862.1.6", "QCType"),
    UNKNOWN("0", "unknown");

    private String oid;
    private String friendlyKey;

    private QcStatementType(String oid, String friendlyKey) {
        this.oid = oid;
        this.friendlyKey = friendlyKey;
    }

    public static QcStatementType resolveOid(String oid) {
        for (QcStatementType type : QcStatementType.values()) {
            if (!oid.equals(type.oid())) continue;
            return type;
        }
        return UNKNOWN;
    }

    public String oid() {
        return this.oid;
    }

    public String getResKey() {
        return this.friendlyKey;
    }
}

