/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.isismtt.x509.AdmissionSyntax;
import org.bouncycastle.asn1.isismtt.x509.Admissions;
import org.bouncycastle.asn1.isismtt.x509.DeclarationOfMajority;
import org.bouncycastle.asn1.isismtt.x509.MonetaryLimit;
import org.bouncycastle.asn1.isismtt.x509.NamingAuthority;
import org.bouncycastle.asn1.isismtt.x509.ProcurationSyntax;
import org.bouncycastle.asn1.isismtt.x509.ProfessionInfo;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.DisplayText;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.NoticeReference;
import org.bouncycastle.asn1.x509.PolicyConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyMappings;
import org.bouncycastle.asn1.x509.PrivateKeyUsagePeriod;
import org.bouncycastle.asn1.x509.ReasonFlags;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.UserNotice;
import org.bouncycastle.asn1.x509.qualified.BiometricData;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.asn1.x509.qualified.SemanticsInformation;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.kse.crypto.x509.AccessMethodType;
import org.kse.crypto.x509.AttributeTypeType;
import org.kse.crypto.x509.CRLDistributionPoints;
import org.kse.crypto.x509.CertificatePolicyQualifierType;
import org.kse.crypto.x509.ExtendedKeyUsageType;
import org.kse.crypto.x509.GeneralNameUtil;
import org.kse.crypto.x509.GeneralSubtrees;
import org.kse.crypto.x509.HoldInstructionCodeType;
import org.kse.crypto.x509.InhibitAnyPolicy;
import org.kse.crypto.x509.QcStatementType;
import org.kse.crypto.x509.SubjectInfoAccess;
import org.kse.crypto.x509.ValidityModelType;
import org.kse.crypto.x509.X509ExtensionType;
import org.kse.utilities.StringUtils;
import org.kse.utilities.io.HexUtil;
import org.kse.utilities.io.IndentChar;
import org.kse.utilities.io.IndentSequence;
import org.kse.utilities.oid.ObjectIdUtil;

public class X509Ext {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/x509/resources");
    private String name;
    private ASN1ObjectIdentifier oid;
    private byte[] value;
    private boolean critical;
    public static final IndentSequence INDENT = new IndentSequence(IndentChar.SPACE, 4);
    public static final String NEWLINE = "\n";

    public X509Ext(ASN1ObjectIdentifier oid, byte[] value, boolean critical) {
        this.oid = oid;
        this.name = X509Ext.lookupFriendlyName(oid);
        this.critical = critical;
        this.value = new byte[value.length];
        System.arraycopy(value, 0, this.value, 0, this.value.length);
    }

    public X509Ext(String oid, byte[] value, boolean critical) {
        this(new ASN1ObjectIdentifier(oid), value, critical);
    }

    public ASN1ObjectIdentifier getOid() {
        return this.oid;
    }

    public byte[] getValue() {
        byte[] val = new byte[this.value.length];
        System.arraycopy(this.value, 0, val, 0, this.value.length);
        return val;
    }

    public boolean isCriticalExtension() {
        return this.critical;
    }

    public String getName() {
        return this.name;
    }

    public String getStringValue() throws IOException {
        byte[] octets = X509Ext.unwrapExtension(this.value);
        X509ExtensionType type = X509ExtensionType.resolveOid(this.oid.getId());
        switch (type) {
            case ENTRUST_VERSION_INFORMATION: {
                return X509Ext.getEntrustVersionInformationStringValue(octets);
            }
            case AUTHORITY_INFORMATION_ACCESS: {
                return X509Ext.getAuthorityInformationAccessStringValue(octets);
            }
            case SUBJECT_INFORMATION_ACCESS: {
                return X509Ext.getSubjectInformationAccessStringValue(octets);
            }
            case SUBJECT_DIRECTORY_ATTRIBUTES: {
                return X509Ext.getSubjectDirectoryAttributesStringValue(octets);
            }
            case SUBJECT_KEY_IDENTIFIER: {
                return X509Ext.getSubjectKeyIndentifierStringValue(octets);
            }
            case KEY_USAGE: {
                return X509Ext.getKeyUsageStringValue(octets);
            }
            case PRIVATE_KEY_USAGE_PERIOD: {
                return X509Ext.getPrivateKeyUsagePeriodStringValue(octets);
            }
            case SUBJECT_ALTERNATIVE_NAME: {
                return X509Ext.getSubjectAlternativeNameStringValue(octets);
            }
            case ISSUER_ALTERNATIVE_NAME: {
                return X509Ext.getIssuerAlternativeNameStringValue(octets);
            }
            case BASIC_CONSTRAINTS: {
                return X509Ext.getBasicConstraintsStringValue(octets);
            }
            case CRL_NUMBER: {
                return X509Ext.getCrlNumberStringValue(octets);
            }
            case REASON_CODE: {
                return X509Ext.getReasonCodeStringValue(octets);
            }
            case HOLD_INSTRUCTION_CODE: {
                return X509Ext.getHoldInstructionCodeStringValue(octets);
            }
            case INVALIDITY_DATE: {
                return X509Ext.getInvalidityDateStringValue(octets);
            }
            case DELTA_CRL_INDICATOR: {
                return X509Ext.getDeltaCrlIndicatorStringValue(octets);
            }
            case ISSUING_DISTRIBUTION_POINT: {
                return X509Ext.getIssuingDistributionPointStringValue(octets);
            }
            case CERTIFICATE_ISSUER: {
                return X509Ext.getCertificateIssuerStringValue(octets);
            }
            case NAME_CONSTRAINTS: {
                return X509Ext.getNameConstraintsStringValue(octets);
            }
            case CRL_DISTRIBUTION_POINTS: {
                return X509Ext.getCrlDistributionPointsStringValue(octets);
            }
            case CERTIFICATE_POLICIES: {
                return X509Ext.getCertificatePoliciesStringValue(octets);
            }
            case POLICY_MAPPINGS: {
                return X509Ext.getPolicyMappingsStringValue(octets);
            }
            case AUTHORITY_KEY_IDENTIFIER: {
                return X509Ext.getAuthorityKeyIdentifierStringValue(octets);
            }
            case POLICY_CONSTRAINTS: {
                return X509Ext.getPolicyConstraintsStringValue(octets);
            }
            case EXTENDED_KEY_USAGE: {
                return X509Ext.getExtendedKeyUsageStringValue(octets);
            }
            case FRESHEST_CRL: {
                return X509Ext.getFreshestCrlStringValue(octets);
            }
            case INHIBIT_ANY_POLICY: {
                return X509Ext.getInhibitAnyPolicyStringValue(octets);
            }
            case NETSCAPE_CERTIFICATE_TYPE: {
                return X509Ext.getNetscapeCertificateTypeStringValue(octets);
            }
            case NETSCAPE_BASE_URL: {
                return X509Ext.getNetscapeBaseUrlStringValue(octets);
            }
            case NETSCAPE_REVOCATION_URL: {
                return X509Ext.getNetscapeRevocationUrlStringValue(octets);
            }
            case NETSCAPE_CA_REVOCATION_URL: {
                return X509Ext.getNetscapeCaRevocationUrlStringValue(octets);
            }
            case NETSCAPE_CERTIFICATE_RENEWAL_URL: {
                return X509Ext.getNetscapeCertificateRenewalStringValue(octets);
            }
            case NETSCAPE_CA_POLICY_URL: {
                return X509Ext.getNetscapeCaPolicyUrlStringValue(octets);
            }
            case NETSCAPE_SSL_SERVER_NAME: {
                return X509Ext.getNetscapeSslServerNameStringValue(octets);
            }
            case NETSCAPE_COMMENT: {
                return X509Ext.getNetscapeCommentStringValue(octets);
            }
            case BIOMETRIC_INFO: {
                return X509Ext.getBiometricInfoStringValue(octets);
            }
            case QC_STATEMENTS: {
                return X509Ext.getQcStatementsStringValue(octets);
            }
            case OCSP_NO_CHECK: {
                return X509Ext.getOcspNoCheckStringValue();
            }
            case LIABILITY_LIMITATION_FLAG: {
                return X509Ext.getLiabilityLimitationFlagStringValue(octets);
            }
            case DATE_OF_CERT_GEN: {
                return X509Ext.getDateOfCertGenStringValue(octets);
            }
            case PROCURATION: {
                return X509Ext.getProcurationStringValue(octets);
            }
            case ADMISSION: {
                return X509Ext.getAdmissionStringValue(octets);
            }
            case MONETARY_LIMIT: {
                return X509Ext.getMonetaryLimitStringValue(octets);
            }
            case DECLARATION_OF_MAJORITY: {
                return X509Ext.getDeclarationOfMajorityStringValue(octets);
            }
            case ICCSN: {
                return X509Ext.getICCSNStringValue(octets);
            }
            case RESTRICTION: {
                return X509Ext.getRestrictionStringValue(octets);
            }
            case ADDITIONAL_INFORMATION: {
                return X509Ext.getAdditionalInformationStringValue(octets);
            }
            case VALIDITY_MODEL: {
                return X509Ext.getValidityModelStringValue(octets);
            }
            case MS_ENROLL_CERT_TYPE_EXTENSION: {
                return X509Ext.getMsCertTypeStringValue(octets);
            }
            case MS_CA_VERSION: {
                return X509Ext.getMsCaVersionStringValue(octets);
            }
            case MS_CRL_NEXT_PUBLISH: {
                return X509Ext.getMsCrlNextPublishStringValue(octets);
            }
            case MS_CERTIFICATE_TEMPLATE: {
                return X509Ext.getMsCertificateTemplateStringValue(octets);
            }
            case MS_APPLICATION_POLICIES: {
                return HexUtil.getHexClearDump(octets);
            }
            case SMIME_CAPABILITIES: {
                return X509Ext.getSMIMECapabilitiesStringValue(octets);
            }
            case VS_CZAG: 
            case VS_FIDELITY_TOKEN: 
            case VS_IN_BOX_V1: 
            case VS_IN_BOX_V2: 
            case VS_SERIAL_NUMBER_ROLLOVER: 
            case VS_ON_SITE_JURISDICTION_HASH: {
                return DERIA5String.getInstance((Object)octets).getString();
            }
            case VS_TOKEN_TYPE: 
            case VS_UNKNOWN: {
                return X509Ext.getBitString(octets);
            }
            case VS_NON_VERIFIED: {
                return X509Ext.getVeriSignNonVerified(octets);
            }
        }
        return HexUtil.getHexClearDump(octets);
    }

    public static byte[] unwrapExtension(byte[] extensionValue) {
        ASN1OctetString octetString = ASN1OctetString.getInstance((Object)extensionValue);
        return octetString.getOctets();
    }

    public static byte[] wrapInOctetString(byte[] extensionValue) throws IOException {
        return new DEROctetString(extensionValue).getEncoded("DER");
    }

    private static String lookupFriendlyName(ASN1ObjectIdentifier oid) {
        X509ExtensionType type = X509ExtensionType.resolveOid(oid.getId());
        if (type != null) {
            return type.friendly();
        }
        return oid.getId();
    }

    private static String getEntrustVersionInformationStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        ASN1Sequence entrustVersInfo = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])value);
        DERGeneralString entrustVers = (DERGeneralString)entrustVersInfo.getObjectAt(0);
        DERBitString entrustInfoFlags = (DERBitString)entrustVersInfo.getObjectAt(1);
        sb.append(MessageFormat.format(res.getString("EntrustVersion"), entrustVers.getString()));
        sb.append(NEWLINE);
        sb.append(MessageFormat.format(res.getString("EntrustInformationFlags"), entrustInfoFlags.getString()));
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getAuthorityInformationAccessStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        AuthorityInformationAccess authorityInfoAccess = AuthorityInformationAccess.getInstance((Object)value);
        int accessDesc = 0;
        for (AccessDescription accessDescription : authorityInfoAccess.getAccessDescriptions()) {
            ++accessDesc;
            ASN1ObjectIdentifier accessMethod = accessDescription.getAccessMethod();
            AccessMethodType accessMethodType = AccessMethodType.resolveOid(accessMethod.getId());
            String accessMethodStr = null;
            accessMethodStr = accessMethodType != null ? accessMethodType.friendly() : ObjectIdUtil.toString(accessMethod);
            GeneralName accessLocation = accessDescription.getAccessLocation();
            String accessLocationStr = GeneralNameUtil.toString(accessLocation);
            sb.append(MessageFormat.format(res.getString("AuthorityInformationAccess"), accessDesc));
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(MessageFormat.format(res.getString("AccessMethod"), accessMethodStr));
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(res.getString("AccessLocation"));
            sb.append(NEWLINE);
            sb.append(INDENT.toString(2));
            sb.append(accessLocationStr);
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getSubjectInformationAccessStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        SubjectInfoAccess subjectInfoAccess = SubjectInfoAccess.getInstance(value);
        int accessDesc = 0;
        for (AccessDescription accessDescription : subjectInfoAccess.getAccessDescriptionList()) {
            ++accessDesc;
            ASN1ObjectIdentifier accessMethod = accessDescription.getAccessMethod();
            AccessMethodType accessMethodType = AccessMethodType.resolveOid(accessMethod.getId());
            String accessMethodStr = null;
            accessMethodStr = accessMethodType != null ? accessMethodType.friendly() : ObjectIdUtil.toString(accessMethod);
            GeneralName accessLocation = accessDescription.getAccessLocation();
            String accessLocationStr = GeneralNameUtil.toString(accessLocation);
            sb.append(MessageFormat.format(res.getString("SubjectInformationAccess"), accessDesc));
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(MessageFormat.format(res.getString("AccessMethod"), accessMethodStr));
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(res.getString("AccessLocation"));
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(INDENT);
            sb.append(accessLocationStr);
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getSubjectDirectoryAttributesStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        SubjectDirectoryAttributes subjectDirectoryAttributes = SubjectDirectoryAttributes.getInstance((Object)value);
        for (Object attribute : subjectDirectoryAttributes.getAttributes()) {
            ASN1Encodable[] attributeValues;
            ASN1ObjectIdentifier attributeType = ((Attribute)attribute).getAttrType();
            AttributeTypeType att = AttributeTypeType.resolveOid(attributeType.getId());
            String attributeTypeStr = att == AttributeTypeType.UNKNOWN ? attributeType.getId() : att.friendly();
            for (ASN1Encodable attributeValue : attributeValues = ((Attribute)attribute).getAttributeValues()) {
                String attributeValueStr = X509Ext.getAttributeValueString(attributeType, attributeValue);
                sb.append(MessageFormat.format("{0}: {1}", attributeTypeStr, attributeValueStr));
                sb.append(NEWLINE);
            }
        }
        return sb.toString();
    }

    private static String getSubjectKeyIndentifierStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance((Object)value);
        byte[] keyIdentifierBytes = subjectKeyIdentifier.getKeyIdentifier();
        sb.append(MessageFormat.format(res.getString("SubjectKeyIdentifier"), HexUtil.getHexString(keyIdentifierBytes)));
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getAuthorityKeyIdentifierStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)value);
        byte[] keyIdentifier = authorityKeyIdentifier.getKeyIdentifier();
        GeneralNames authorityCertIssuer = authorityKeyIdentifier.getAuthorityCertIssuer();
        BigInteger certificateSerialNumber = authorityKeyIdentifier.getAuthorityCertSerialNumber();
        if (keyIdentifier != null) {
            sb.append(MessageFormat.format(res.getString("AuthorityKeyIdentifier"), HexUtil.getHexString(keyIdentifier)));
            sb.append(NEWLINE);
        }
        if (authorityCertIssuer != null) {
            sb.append(res.getString("CertificateIssuer"));
            sb.append(NEWLINE);
            for (GeneralName generalName : authorityCertIssuer.getNames()) {
                sb.append(INDENT);
                sb.append(GeneralNameUtil.toString(generalName));
                sb.append(NEWLINE);
            }
        }
        if (certificateSerialNumber != null) {
            sb.append(MessageFormat.format(res.getString("CertificateSerialNumber"), HexUtil.getHexString(certificateSerialNumber)));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getKeyUsageStringValue(byte[] value) throws IOException {
        DERBitString keyUsage = DERBitString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])value));
        int keyUsages = keyUsage.intValue();
        StringBuilder sb = new StringBuilder();
        if (X509Ext.hasKeyUsage(keyUsages, 128)) {
            sb.append(res.getString("DigitalSignatureKeyUsage"));
            sb.append(NEWLINE);
        }
        if (X509Ext.hasKeyUsage(keyUsages, 64)) {
            sb.append(res.getString("NonRepudiationKeyUsage"));
            sb.append(NEWLINE);
        }
        if (X509Ext.hasKeyUsage(keyUsages, 32)) {
            sb.append(res.getString("KeyEnciphermentKeyUsage"));
            sb.append(NEWLINE);
        }
        if (X509Ext.hasKeyUsage(keyUsages, 16)) {
            sb.append(res.getString("DataEnciphermentKeyUsage"));
            sb.append(NEWLINE);
        }
        if (X509Ext.hasKeyUsage(keyUsages, 8)) {
            sb.append(res.getString("KeyAgreementKeyUsage"));
            sb.append(NEWLINE);
        }
        if (X509Ext.hasKeyUsage(keyUsages, 4)) {
            sb.append(res.getString("KeyCertSignKeyUsage"));
            sb.append(NEWLINE);
        }
        if (X509Ext.hasKeyUsage(keyUsages, 2)) {
            sb.append(res.getString("CrlSignKeyUsage"));
            sb.append(NEWLINE);
        }
        if (X509Ext.hasKeyUsage(keyUsages, 1)) {
            sb.append(res.getString("EncipherOnlyKeyUsage"));
            sb.append(NEWLINE);
        }
        if (X509Ext.hasKeyUsage(keyUsages, 32768)) {
            sb.append(res.getString("DecipherOnlyKeyUsage"));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static boolean hasKeyUsage(int keyUsages, int keyUsage) {
        return (keyUsages & keyUsage) == keyUsage;
    }

    private static String getPrivateKeyUsagePeriodStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        PrivateKeyUsagePeriod privateKeyUsagePeriod = PrivateKeyUsagePeriod.getInstance((Object)value);
        ASN1GeneralizedTime notBefore = privateKeyUsagePeriod.getNotBefore();
        ASN1GeneralizedTime notAfter = privateKeyUsagePeriod.getNotAfter();
        if (notBefore != null) {
            sb.append(MessageFormat.format(res.getString("NotBeforePrivateKeyUsagePeriod"), X509Ext.getGeneralizedTimeString(notBefore)));
        } else {
            sb.append(MessageFormat.format(res.getString("NotBeforePrivateKeyUsagePeriod"), res.getString("NoValue")));
        }
        sb.append(NEWLINE);
        if (notAfter != null) {
            sb.append(MessageFormat.format(res.getString("NotAfterPrivateKeyUsagePeriod"), X509Ext.getGeneralizedTimeString(notAfter)));
        } else {
            sb.append(MessageFormat.format(res.getString("NotAfterPrivateKeyUsagePeriod"), res.getString("NoValue")));
        }
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getSubjectAlternativeNameStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        GeneralNames subjectAltName = GeneralNames.getInstance((Object)value);
        for (GeneralName generalName : subjectAltName.getNames()) {
            sb.append(GeneralNameUtil.toString(generalName));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getIssuerAlternativeNameStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        GeneralNames issuerAltName = GeneralNames.getInstance((Object)value);
        for (GeneralName generalName : issuerAltName.getNames()) {
            sb.append(GeneralNameUtil.toString(generalName));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getBasicConstraintsStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        BasicConstraints basicConstraints = BasicConstraints.getInstance((Object)value);
        boolean ca = basicConstraints.isCA();
        BigInteger pathLenConstraint = basicConstraints.getPathLenConstraint();
        if (ca) {
            sb.append(res.getString("SubjectIsCa"));
            sb.append(NEWLINE);
        } else {
            sb.append(res.getString("SubjectIsNotCa"));
            sb.append(NEWLINE);
        }
        if (pathLenConstraint != null) {
            sb.append(MessageFormat.format(res.getString("PathLengthConstraint"), pathLenConstraint.intValue()));
            sb.append(NEWLINE);
        } else {
            sb.append(res.getString("NoPathLengthConstraint"));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getCrlNumberStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        CRLNumber crlNumber = CRLNumber.getInstance((Object)value);
        sb.append(HexUtil.getHexString(crlNumber.getCRLNumber()));
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getReasonCodeStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        CRLReason crlReason = CRLReason.getInstance((Object)value);
        long crlReasonLong = crlReason.getValue().longValue();
        if (crlReasonLong == 0L) {
            sb.append(res.getString("UnspecifiedCrlReason"));
        } else if (crlReasonLong == 1L) {
            sb.append(res.getString("KeyCompromiseCrlReason"));
        } else if (crlReasonLong == 2L) {
            sb.append(res.getString("CaCompromiseCrlReason"));
        } else if (crlReasonLong == 3L) {
            sb.append(res.getString("AffiliationChangedCrlReason"));
        } else if (crlReasonLong == 4L) {
            sb.append(res.getString("SupersededCrlReason"));
        } else if (crlReasonLong == 5L) {
            sb.append(res.getString("CessationOfOperationCrlReason"));
        } else if (crlReasonLong == 6L) {
            sb.append(res.getString("CertificateHoldCrlReason"));
        } else if (crlReasonLong == 8L) {
            sb.append(res.getString("RemoveFromCrlCrlReason"));
        } else if (crlReasonLong == 9L) {
            sb.append(res.getString("PrivilegeWithdrawnCrlReason"));
        } else {
            sb.append(res.getString("AaCompromiseCrlReason"));
        }
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getHoldInstructionCodeStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        ASN1ObjectIdentifier holdInstructionCode = ASN1ObjectIdentifier.getInstance((Object)value);
        HoldInstructionCodeType holdInstructionCodeType = HoldInstructionCodeType.resolveOid(holdInstructionCode.getId());
        if (holdInstructionCodeType != null) {
            sb.append(holdInstructionCodeType.friendly());
        } else {
            sb.append(holdInstructionCode.getId());
        }
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getInvalidityDateStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        ASN1GeneralizedTime invalidityDate = ASN1GeneralizedTime.getInstance((Object)value);
        sb.append(X509Ext.getGeneralizedTimeString(invalidityDate));
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getDeltaCrlIndicatorStringValue(byte[] value) throws IOException {
        CRLNumber crlNumber = CRLNumber.getInstance((Object)value);
        BigInteger crlNum = crlNumber.getCRLNumber();
        return HexUtil.getHexString(crlNum) + NEWLINE;
    }

    private static String getIssuingDistributionPointStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        IssuingDistributionPoint issuingDistributionPoint = IssuingDistributionPoint.getInstance((Object)value);
        DistributionPointName distributionPointName = issuingDistributionPoint.getDistributionPoint();
        if (distributionPointName != null) {
            sb.append(X509Ext.getDistributionPointNameString(distributionPointName, ""));
        }
        boolean onlyContainsUserCerts = issuingDistributionPoint.onlyContainsUserCerts();
        sb.append(MessageFormat.format(res.getString("OnlyContainsUserCerts"), onlyContainsUserCerts));
        sb.append(NEWLINE);
        boolean onlyContainsCaCerts = issuingDistributionPoint.onlyContainsCACerts();
        sb.append(MessageFormat.format(res.getString("OnlyContainsCaCerts"), onlyContainsCaCerts));
        sb.append(NEWLINE);
        ReasonFlags onlySomeReasons = issuingDistributionPoint.getOnlySomeReasons();
        if (onlySomeReasons != null) {
            String[] reasonFlags;
            sb.append(res.getString("OnlySomeReasons"));
            sb.append(NEWLINE);
            for (String reasonFlag : reasonFlags = X509Ext.getReasonFlagsStrings(onlySomeReasons)) {
                sb.append(INDENT);
                sb.append(reasonFlag);
                sb.append(NEWLINE);
            }
        }
        boolean indirectCrl = issuingDistributionPoint.isIndirectCRL();
        sb.append(MessageFormat.format(res.getString("IndirectCrl"), indirectCrl));
        sb.append(NEWLINE);
        boolean onlyContainsAttributeCerts = issuingDistributionPoint.onlyContainsAttributeCerts();
        sb.append(MessageFormat.format(res.getString("OnlyContainsAttributeCerts"), onlyContainsAttributeCerts));
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getCertificateIssuerStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        GeneralNames certificateIssuer = GeneralNames.getInstance((Object)value);
        for (GeneralName generalName : certificateIssuer.getNames()) {
            sb.append(GeneralNameUtil.toString(generalName));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getNameConstraintsStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        NameConstraints nameConstraints = NameConstraints.getInstance((Object)value);
        GeneralSubtrees permittedSubtrees = null;
        if (nameConstraints.getPermittedSubtrees() != null && nameConstraints.getPermittedSubtrees().length != 0) {
            permittedSubtrees = new GeneralSubtrees(nameConstraints.getPermittedSubtrees());
        }
        sb.append(res.getString("PermittedSubtrees"));
        if (permittedSubtrees == null) {
            sb.append(" ").append(res.getString("NoValue"));
            sb.append(NEWLINE);
        } else {
            sb.append(NEWLINE);
            int permitted = 0;
            for (GeneralSubtree permittedSubtree : permittedSubtrees.getGeneralSubtrees()) {
                sb.append(INDENT);
                sb.append(MessageFormat.format(res.getString("PermittedSubtree"), ++permitted));
                sb.append(NEWLINE);
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(res.getString("Base"));
                sb.append(NEWLINE);
                GeneralName base = permittedSubtree.getBase();
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(GeneralNameUtil.toString(base));
                sb.append(NEWLINE);
                BigInteger minimum = permittedSubtree.getMinimum();
                int minimumInt = 0;
                if (minimum != null) {
                    minimumInt = minimum.intValue();
                }
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(MessageFormat.format(res.getString("Minimum"), minimumInt));
                sb.append(NEWLINE);
                BigInteger maximum = permittedSubtree.getMaximum();
                if (maximum == null) continue;
                int maximumInt = maximum.intValue();
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(MessageFormat.format(res.getString("Maximum"), maximumInt));
                sb.append(NEWLINE);
            }
        }
        GeneralSubtree[] excludedSubtreeArray = nameConstraints.getExcludedSubtrees();
        sb.append(res.getString("ExcludedSubtrees"));
        if (excludedSubtreeArray == null) {
            sb.append(" ").append(res.getString("NoValue"));
            sb.append(NEWLINE);
        } else {
            GeneralSubtrees excludedSubtrees = new GeneralSubtrees(excludedSubtreeArray);
            sb.append(NEWLINE);
            int excluded = 0;
            for (GeneralSubtree excludedSubtree : excludedSubtrees.getGeneralSubtrees()) {
                sb.append(INDENT);
                sb.append(MessageFormat.format(res.getString("ExcludedSubtree"), ++excluded));
                sb.append(NEWLINE);
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(res.getString("Base"));
                sb.append(NEWLINE);
                GeneralName base = excludedSubtree.getBase();
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(GeneralNameUtil.toString(base));
                sb.append(NEWLINE);
                BigInteger minimum = excludedSubtree.getMinimum();
                int minimumInt = minimum.intValue();
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(MessageFormat.format(res.getString("Minimum"), minimumInt));
                sb.append(NEWLINE);
                BigInteger maximum = excludedSubtree.getMaximum();
                if (maximum == null) continue;
                int maximumInt = maximum.intValue();
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(MessageFormat.format(res.getString("Maximum"), maximumInt));
                sb.append(NEWLINE);
            }
        }
        return sb.toString();
    }

    private static String getCrlDistributionPointsStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        CRLDistPoint crlDistributionPoints = CRLDistPoint.getInstance((Object)value);
        int distPoint = 0;
        for (DistributionPoint distributionPoint : crlDistributionPoints.getDistributionPoints()) {
            sb.append(MessageFormat.format(res.getString("CrlDistributionPoint"), ++distPoint));
            sb.append(NEWLINE);
            sb.append(X509Ext.getDistributionPointString(distributionPoint, INDENT.toString(1)));
        }
        return sb.toString();
    }

    private static String getCertificatePoliciesStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)value);
        int certPolicy = 0;
        for (PolicyInformation policyInformation : certificatePolicies.getPolicyInformation()) {
            sb.append(MessageFormat.format(res.getString("CertificatePolicy"), ++certPolicy));
            sb.append(NEWLINE);
            ASN1ObjectIdentifier policyIdentifier = policyInformation.getPolicyIdentifier();
            String policyIdentifierStr = ObjectIdUtil.toString(policyIdentifier);
            sb.append(INDENT);
            sb.append(MessageFormat.format(res.getString("PolicyIdentifier"), policyIdentifierStr));
            sb.append(NEWLINE);
            ASN1Sequence policyQualifiers = policyInformation.getPolicyQualifiers();
            if (policyQualifiers == null) continue;
            int policyQual = 0;
            for (ASN1Encodable policyQualifier : policyQualifiers.toArray()) {
                ASN1Sequence policyQualifierInfo = (ASN1Sequence)policyQualifier;
                sb.append(INDENT.toString(1));
                sb.append(MessageFormat.format(res.getString("PolicyQualifierInformation"), certPolicy, ++policyQual));
                sb.append(NEWLINE);
                ASN1ObjectIdentifier policyQualifierId = (ASN1ObjectIdentifier)policyQualifierInfo.getObjectAt(0);
                CertificatePolicyQualifierType certificatePolicyQualifierType = CertificatePolicyQualifierType.resolveOid(policyQualifierId.getId());
                if (certificatePolicyQualifierType == null) continue;
                sb.append(INDENT.toString(2));
                sb.append(certificatePolicyQualifierType.friendly());
                sb.append(NEWLINE);
                if (certificatePolicyQualifierType == CertificatePolicyQualifierType.PKIX_CPS_POINTER_QUALIFIER) {
                    DERIA5String cpsPointer = (DERIA5String)policyQualifierInfo.getObjectAt(1);
                    sb.append(INDENT.toString(2));
                    sb.append(MessageFormat.format(res.getString("CpsPointer"), "<a href=\"" + cpsPointer + "\">" + cpsPointer + "</a>"));
                    sb.append(NEWLINE);
                    continue;
                }
                if (certificatePolicyQualifierType != CertificatePolicyQualifierType.PKIX_USER_NOTICE_QUALIFIER) continue;
                ASN1Encodable userNoticeObj = policyQualifierInfo.getObjectAt(1);
                UserNotice userNotice = UserNotice.getInstance((Object)userNoticeObj);
                sb.append(INDENT.toString(2));
                sb.append(res.getString("UserNotice"));
                sb.append(NEWLINE);
                NoticeReference noticeReference = userNotice.getNoticeRef();
                DisplayText explicitText = userNotice.getExplicitText();
                if (noticeReference != null) {
                    sb.append(INDENT.toString(3));
                    sb.append(res.getString("NoticeReference"));
                    sb.append(NEWLINE);
                    DisplayText organization = noticeReference.getOrganization();
                    String organizationString = organization.getString();
                    sb.append(INDENT.toString(4));
                    sb.append(MessageFormat.format(res.getString("Organization"), organizationString));
                    sb.append(NEWLINE);
                    ASN1Integer[] noticeNumbers = noticeReference.getNoticeNumbers();
                    StringBuilder sbNoticeNumbers = new StringBuilder();
                    for (ASN1Integer noticeNumber : noticeNumbers) {
                        sbNoticeNumbers.append(noticeNumber.getValue().intValue());
                        sbNoticeNumbers.append(", ");
                    }
                    sbNoticeNumbers.setLength(sbNoticeNumbers.length() - 2);
                    sb.append(INDENT.toString(4));
                    sb.append(MessageFormat.format(res.getString("NoticeNumbers"), sbNoticeNumbers.toString()));
                    sb.append(NEWLINE);
                }
                if (explicitText == null) continue;
                String explicitTextString = explicitText.getString();
                sb.append(INDENT.toString(3));
                sb.append(MessageFormat.format(res.getString("ExplicitText"), explicitTextString));
                sb.append(NEWLINE);
            }
        }
        return sb.toString();
    }

    private static String getPolicyMappingsStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        PolicyMappings policyMappings = PolicyMappings.getInstance((Object)value);
        ASN1Sequence policyMappingsSeq = (ASN1Sequence)policyMappings.toASN1Primitive();
        int polMap = 0;
        for (ASN1Encodable policyMapping : policyMappingsSeq.toArray()) {
            ASN1Sequence policyMappingSeq = ASN1Sequence.getInstance((Object)policyMapping.toASN1Primitive());
            sb.append(MessageFormat.format(res.getString("PolicyMapping"), ++polMap));
            sb.append(NEWLINE);
            ASN1ObjectIdentifier issuerDomainPolicy = (ASN1ObjectIdentifier)policyMappingSeq.getObjectAt(0);
            ASN1ObjectIdentifier subjectDomainPolicy = (ASN1ObjectIdentifier)policyMappingSeq.getObjectAt(1);
            sb.append(INDENT);
            sb.append(MessageFormat.format(res.getString("IssuerDomainPolicy"), ObjectIdUtil.toString(issuerDomainPolicy)));
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(MessageFormat.format(res.getString("SubjectDomainPolicy"), ObjectIdUtil.toString(subjectDomainPolicy)));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getPolicyConstraintsStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        PolicyConstraints policyConstraints = PolicyConstraints.getInstance((Object)value);
        BigInteger requireExplicitPolicy = policyConstraints.getRequireExplicitPolicyMapping();
        BigInteger inhibitPolicyMapping = policyConstraints.getInhibitPolicyMapping();
        if (requireExplicitPolicy != null) {
            sb.append(MessageFormat.format(res.getString("RequireExplicitPolicy"), requireExplicitPolicy));
            sb.append(NEWLINE);
        }
        if (inhibitPolicyMapping != null) {
            sb.append(MessageFormat.format(res.getString("InhibitPolicyMapping"), inhibitPolicyMapping));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getExtendedKeyUsageStringValue(byte[] value) {
        StringBuilder sb = new StringBuilder();
        ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.getInstance((Object)value);
        for (KeyPurposeId keyPurposeId : extendedKeyUsage.getUsages()) {
            String oid = keyPurposeId.getId();
            ExtendedKeyUsageType type = ExtendedKeyUsageType.resolveOid(oid);
            if (type != null) {
                sb.append(type.friendly());
            } else {
                sb.append(oid);
            }
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getFreshestCrlStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        CRLDistributionPoints freshestCRL = CRLDistributionPoints.getInstance(value);
        int distPoint = 0;
        for (DistributionPoint distributionPoint : freshestCRL.getDistributionPointList()) {
            sb.append(MessageFormat.format(res.getString("FreshestCrlDistributionPoint"), ++distPoint));
            sb.append(NEWLINE);
            sb.append(X509Ext.getDistributionPointString(distributionPoint, INDENT.toString(1)));
        }
        return sb.toString();
    }

    private static String getInhibitAnyPolicyStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        InhibitAnyPolicy inhibitAnyPolicy = InhibitAnyPolicy.getInstance(value);
        int skipCerts = inhibitAnyPolicy.getSkipCerts();
        sb.append(MessageFormat.format(res.getString("InhibitAnyPolicy"), skipCerts));
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getNetscapeCertificateTypeStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        DERBitString netscapeCertType = DERBitString.getInstance((Object)new ASN1InputStream(value).readObject());
        int netscapeCertTypes = netscapeCertType.intValue();
        if (X509Ext.isCertType(netscapeCertTypes, 128)) {
            sb.append(res.getString("SslClientNetscapeCertificateType"));
            sb.append(NEWLINE);
        }
        if (X509Ext.isCertType(netscapeCertTypes, 64)) {
            sb.append(res.getString("SslServerNetscapeCertificateType"));
            sb.append(NEWLINE);
        }
        if (X509Ext.isCertType(netscapeCertTypes, 32)) {
            sb.append(res.getString("SmimeNetscapeCertificateType"));
            sb.append(NEWLINE);
        }
        if (X509Ext.isCertType(netscapeCertTypes, 16)) {
            sb.append(res.getString("ObjectSigningNetscapeCertificateType"));
            sb.append(NEWLINE);
        }
        if (X509Ext.isCertType(netscapeCertTypes, 8)) {
            sb.append(res.getString("ReservedNetscapeCertificateType"));
            sb.append(NEWLINE);
        }
        if (X509Ext.isCertType(netscapeCertTypes, 4)) {
            sb.append(res.getString("SslCaNetscapeCertificateType"));
            sb.append(NEWLINE);
        }
        if (X509Ext.isCertType(netscapeCertTypes, 2)) {
            sb.append(res.getString("SmimeCaNetscapeCertificateType"));
            sb.append(NEWLINE);
        }
        if (X509Ext.isCertType(netscapeCertTypes, 1)) {
            sb.append(res.getString("ObjectSigningCaNetscapeCertificateType"));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static boolean isCertType(int netscapeCertTypes, int certType) {
        return (netscapeCertTypes & certType) == certType;
    }

    private static String getNetscapeBaseUrlStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        DERIA5String netscapeBaseUrl = DERIA5String.getInstance((Object)value);
        sb.append(netscapeBaseUrl.getString());
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getNetscapeRevocationUrlStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        DERIA5String netscapeRevocationUrl = DERIA5String.getInstance((Object)value);
        sb.append(netscapeRevocationUrl.getString());
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getNetscapeCaRevocationUrlStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        DERIA5String netscapeCaRevocationUrl = DERIA5String.getInstance((Object)value);
        sb.append(netscapeCaRevocationUrl.getString());
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getNetscapeCertificateRenewalStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        DERIA5String netscapeCertRenewalUrl = DERIA5String.getInstance((Object)value);
        sb.append(netscapeCertRenewalUrl.getString());
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getNetscapeCaPolicyUrlStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        DERIA5String netscapeCaPolicyUrl = DERIA5String.getInstance((Object)value);
        sb.append(netscapeCaPolicyUrl.getString());
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getNetscapeSslServerNameStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        DERIA5String netscapeSslServerName = DERIA5String.getInstance((Object)value);
        sb.append(netscapeSslServerName.getString());
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getNetscapeCommentStringValue(byte[] value) throws IOException {
        StringBuilder sb = new StringBuilder();
        DERIA5String netscapeComment = DERIA5String.getInstance((Object)value);
        sb.append(netscapeComment.getString());
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getDistributionPointString(DistributionPoint distributionPoint, String baseIndent) throws IOException {
        StringBuilder sb = new StringBuilder();
        DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
        ReasonFlags reasons = distributionPoint.getReasons();
        GeneralNames crlIssuer = distributionPoint.getCRLIssuer();
        if (distributionPointName != null) {
            sb.append(X509Ext.getDistributionPointNameString(distributionPointName, baseIndent));
        }
        if (reasons != null) {
            String[] reasonFlags;
            sb.append(baseIndent);
            sb.append(res.getString("DistributionPointReasons"));
            sb.append(NEWLINE);
            String[] stringArray = reasonFlags = X509Ext.getReasonFlagsStrings(reasons);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String reasonFlag = stringArray[i];
                sb.append(baseIndent);
                sb.append(INDENT);
                sb.append(reasonFlag);
                sb.append(NEWLINE);
            }
        }
        if (crlIssuer != null) {
            sb.append(baseIndent);
            sb.append(res.getString("DistributionPointCrlIssuer"));
            sb.append(NEWLINE);
            for (GeneralName generalName : crlIssuer.getNames()) {
                sb.append(baseIndent);
                sb.append(INDENT);
                sb.append(GeneralNameUtil.toString(generalName));
                sb.append(NEWLINE);
            }
        }
        return sb.toString();
    }

    private static String getDistributionPointNameString(DistributionPointName distributionPointName, String baseIndent) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(baseIndent);
        sb.append(res.getString("DistributionPointName"));
        sb.append(NEWLINE);
        if (distributionPointName.getType() == 0) {
            sb.append(baseIndent);
            sb.append(INDENT);
            sb.append(res.getString("DistributionPointFullName"));
            sb.append(NEWLINE);
            GeneralNames generalNames = GeneralNames.getInstance((Object)distributionPointName.getName());
            for (GeneralName generalName : generalNames.getNames()) {
                sb.append(baseIndent);
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(GeneralNameUtil.toString(generalName));
                sb.append(NEWLINE);
            }
        } else {
            sb.append(baseIndent);
            sb.append(INDENT);
            sb.append(res.getString("DistributionPointNameRelativeToCrlIssuer"));
            sb.append(NEWLINE);
            RDN rdn = RDN.getInstance((Object)distributionPointName.getName());
            for (AttributeTypeAndValue attributeTypeAndValue : rdn.getTypesAndValues()) {
                ASN1ObjectIdentifier attributeType = attributeTypeAndValue.getType();
                ASN1Encodable attributeValue = attributeTypeAndValue.getValue();
                String attributeTypeStr = X509Ext.getAttributeTypeString(attributeType);
                String attributeValueStr = X509Ext.getAttributeValueString(attributeType, attributeValue);
                sb.append(baseIndent);
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(MessageFormat.format("{0}={1}", attributeTypeStr, attributeValueStr));
                sb.append(NEWLINE);
            }
        }
        return sb.toString();
    }

    private static String[] getReasonFlagsStrings(ReasonFlags reasonFlags) throws IOException {
        ArrayList<String> reasonFlagsList = new ArrayList<String>();
        DERBitString reasonFlagsBitString = (DERBitString)reasonFlags.toASN1Primitive();
        int reasonFlagsInt = reasonFlagsBitString.intValue();
        if (X509Ext.hasReasonFlag(reasonFlagsInt, 128)) {
            reasonFlagsList.add(res.getString("UnusedReasonFlag"));
        }
        if (X509Ext.hasReasonFlag(reasonFlagsInt, 64)) {
            reasonFlagsList.add(res.getString("KeyCompromiseReasonFlag"));
        }
        if (X509Ext.hasReasonFlag(reasonFlagsInt, 32)) {
            reasonFlagsList.add(res.getString("CaCompromiseReasonFlag"));
        }
        if (X509Ext.hasReasonFlag(reasonFlagsInt, 16)) {
            reasonFlagsList.add(res.getString("AffiliationChangedReasonFlag"));
        }
        if (X509Ext.hasReasonFlag(reasonFlagsInt, 8)) {
            reasonFlagsList.add(res.getString("SupersededReasonFlag"));
        }
        if (X509Ext.hasReasonFlag(reasonFlagsInt, 4)) {
            reasonFlagsList.add(res.getString("CessationOfOperationReasonFlag"));
        }
        if (X509Ext.hasReasonFlag(reasonFlagsInt, 2)) {
            reasonFlagsList.add(res.getString("CertificateHoldReasonFlag"));
        }
        if (X509Ext.hasReasonFlag(reasonFlagsInt, 1)) {
            reasonFlagsList.add(res.getString("PrivilegeWithdrawnReasonFlag"));
        }
        if (X509Ext.hasReasonFlag(reasonFlagsInt, 32768)) {
            reasonFlagsList.add(res.getString("AaCompromiseReasonFlag"));
        }
        return reasonFlagsList.toArray(new String[reasonFlagsList.size()]);
    }

    private static boolean hasReasonFlag(int reasonFlags, int reasonFlag) {
        return (reasonFlags & reasonFlag) == reasonFlag;
    }

    private static String getAttributeTypeString(ASN1ObjectIdentifier oid) {
        AttributeTypeType attributeTypeType = AttributeTypeType.resolveOid(oid.getId());
        if (attributeTypeType != null) {
            return attributeTypeType.friendly();
        }
        return ObjectIdUtil.toString(oid);
    }

    private static String getAttributeValueString(ASN1ObjectIdentifier attributeType, ASN1Encodable attributeValue) throws IOException {
        AttributeTypeType attributeTypeType = AttributeTypeType.resolveOid(attributeType.getId());
        switch (attributeTypeType) {
            case DATE_OF_BIRTH: {
                return X509Ext.getGeneralizedTimeString(ASN1GeneralizedTime.getInstance((Object)attributeValue));
            }
            case SERIAL_NUMBER: 
            case UNSTRUCTURED_ADDRESS: 
            case COUNTRY_NAME: 
            case GENDER: 
            case COUNTRY_OF_CITIZENSHIP: 
            case COUNTRY_OF_RESIDENCE: {
                return DERPrintableString.getInstance((Object)attributeValue).getString();
            }
            case COMMON_NAME: 
            case LOCALITY_NAME: 
            case STATE_NAME: 
            case STREET_ADDRESS: 
            case ORGANIZATION_NAME: 
            case ORGANIZATIONAL_UNIT: 
            case TITLE: 
            case USER_ID: 
            case PLACE_OF_BIRTH: {
                return DirectoryString.getInstance((Object)attributeValue).getString();
            }
            case MAIL: 
            case EMAIL_ADDRESS: 
            case UNSTRUCTURED_NAME: 
            case DOMAIN_COMPONENT: {
                return DERIA5String.getInstance((Object)attributeValue).getString();
            }
        }
        return HexUtil.getHexString(attributeValue.toASN1Primitive().getEncoded());
    }

    private static String getGeneralizedTimeString(ASN1GeneralizedTime notBefore) {
        Date date;
        try {
            date = notBefore.getDate();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse date");
        }
        return StringUtils.formatDate(date);
    }

    private static String getBiometricInfoStringValue(byte[] octets) {
        StringBuilder sb = new StringBuilder();
        int biometricDataNr = 0;
        ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)octets);
        for (ASN1Encodable asn1Encodable : asn1Sequence.toArray()) {
            BiometricData biometricData = BiometricData.getInstance((Object)asn1Encodable);
            TypeOfBiometricData typeOfBiometricData = biometricData.getTypeOfBiometricData();
            AlgorithmIdentifier hashAlgorithm = biometricData.getHashAlgorithm();
            ASN1OctetString biometricDataHash = biometricData.getBiometricDataHash();
            DERIA5String sourceDataUri = biometricData.getSourceDataUri();
            sb.append(MessageFormat.format(res.getString("BiometricInfo.BiometricData"), biometricDataNr));
            sb.append(NEWLINE);
            sb.append(INDENT);
            if (typeOfBiometricData.isPredefined()) {
                int type = typeOfBiometricData.getPredefinedBiometricType();
                sb.append(MessageFormat.format(res.getString("BiometricInfo.TypeOfBiometricData"), type));
            } else {
                String biometricDataOid = typeOfBiometricData.getBiometricDataOid().getId();
                sb.append(MessageFormat.format(res.getString("BiometricInfo.TypeOfBiometricData"), biometricDataOid));
            }
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(MessageFormat.format(res.getString("BiometricInfo.HashAlgorithm"), hashAlgorithm.getAlgorithm().getId()));
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(MessageFormat.format(res.getString("BiometricInfo.BiometricDataHash"), HexUtil.getHexString(biometricDataHash.getOctets())));
            sb.append(NEWLINE);
            if (sourceDataUri == null) continue;
            sb.append(INDENT);
            sb.append(MessageFormat.format(res.getString("BiometricInfo.SourceDataUri"), sourceDataUri.toString()));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getQcStatementsStringValue(byte[] octets) throws IOException {
        StringBuilder sb = new StringBuilder();
        int qcStatementNr = 0;
        ASN1Sequence qcStatements = ASN1Sequence.getInstance((Object)octets);
        block9: for (ASN1Encodable asn1Encodable : qcStatements.toArray()) {
            QCStatement qcStatement = QCStatement.getInstance((Object)asn1Encodable);
            ASN1ObjectIdentifier statementId = qcStatement.getStatementId();
            ASN1Encodable statementInfo = qcStatement.getStatementInfo();
            int indentLevel = 1;
            sb.append(MessageFormat.format(res.getString("QCStatement.QCStatement"), ++qcStatementNr));
            sb.append(NEWLINE);
            QcStatementType qcStatementType = QcStatementType.resolveOid(statementId.getId());
            switch (qcStatementType) {
                case QC_SYNTAX_V1: 
                case QC_SYNTAX_V2: {
                    SemanticsInformation semanticsInfo = SemanticsInformation.getInstance((Object)statementInfo);
                    sb.append(X509Ext.getSemanticInformationValueString(qcStatementType, semanticsInfo, indentLevel));
                    continue block9;
                }
                case QC_COMPLIANCE: {
                    sb.append(INDENT.toString(indentLevel));
                    sb.append(res.getString(QcStatementType.QC_COMPLIANCE.getResKey()));
                    sb.append(NEWLINE);
                    continue block9;
                }
                case QC_EU_LIMIT_VALUE: {
                    sb.append(INDENT.toString(indentLevel));
                    sb.append(res.getString(QcStatementType.QC_EU_LIMIT_VALUE.getResKey()));
                    sb.append(NEWLINE);
                    sb.append(X509Ext.getMonetaryValueStringValue(statementInfo, indentLevel + 1));
                    continue block9;
                }
                case QC_RETENTION_PERIOD: {
                    ASN1Integer asn1Integer = ASN1Integer.getInstance((Object)statementInfo);
                    sb.append(INDENT.toString(indentLevel));
                    sb.append(MessageFormat.format(res.getString(QcStatementType.QC_RETENTION_PERIOD.getResKey()), asn1Integer.getValue().toString()));
                    sb.append(NEWLINE);
                    continue block9;
                }
                case QC_SSCD: {
                    sb.append(INDENT.toString(indentLevel));
                    sb.append(res.getString(QcStatementType.QC_SSCD.getResKey()));
                    sb.append(NEWLINE);
                    continue block9;
                }
                case QC_PDS: {
                    ASN1Sequence pdsLocations = ASN1Sequence.getInstance((Object)statementInfo);
                    sb.append(INDENT.toString(indentLevel));
                    sb.append(res.getString(QcStatementType.QC_PDS.getResKey()));
                    for (ASN1Encodable pdsLoc : pdsLocations) {
                        sb.append(NEWLINE);
                        sb.append(INDENT.toString(indentLevel + 1));
                        DLSequence pds = (DLSequence)pdsLoc;
                        sb.append(MessageFormat.format(res.getString("QCPDS.locations"), pds.getObjectAt(1), pds.getObjectAt(0)));
                    }
                    sb.append(NEWLINE);
                    continue block9;
                }
                case QC_TYPE: {
                    sb.append(INDENT.toString(indentLevel));
                    sb.append(res.getString(QcStatementType.QC_TYPE.getResKey()));
                    ASN1Sequence qcTypes = ASN1Sequence.getInstance((Object)statementInfo);
                    for (ASN1Encodable type : qcTypes) {
                        sb.append(NEWLINE);
                        sb.append(INDENT.toString(indentLevel + 1));
                        sb.append(ObjectIdUtil.toString((ASN1ObjectIdentifier)type));
                    }
                    sb.append(NEWLINE);
                    continue block9;
                }
                default: {
                    sb.append(INDENT.toString(indentLevel));
                    sb.append(ObjectIdUtil.toString(statementId));
                    if (statementInfo != null) {
                        sb.append(statementInfo.toString());
                    }
                    sb.append(NEWLINE);
                }
            }
        }
        return sb.toString();
    }

    private static String getSemanticInformationValueString(QcStatementType qcStatementType, SemanticsInformation semanticsInfo, int baseIndentLevel) throws IOException {
        ASN1ObjectIdentifier semanticsIdentifier = semanticsInfo.getSemanticsIdentifier();
        GeneralName[] nameRegistrationAuthorities = semanticsInfo.getNameRegistrationAuthorities();
        StringBuilder sb = new StringBuilder();
        sb.append(INDENT.toString(baseIndentLevel));
        if (qcStatementType == QcStatementType.QC_SYNTAX_V1) {
            sb.append(res.getString(QcStatementType.QC_SYNTAX_V1.getResKey()));
        } else {
            sb.append(res.getString(QcStatementType.QC_SYNTAX_V2.getResKey()));
        }
        sb.append(NEWLINE);
        if (semanticsIdentifier != null) {
            sb.append(INDENT.toString(baseIndentLevel + 1));
            sb.append(MessageFormat.format(res.getString("QCSyntax.SemanticsIdentifier"), semanticsIdentifier.getId()));
            sb.append(NEWLINE);
        }
        if (nameRegistrationAuthorities != null) {
            sb.append(INDENT.toString(baseIndentLevel + 1));
            sb.append(res.getString("QCSyntax.NameRegistrationAuthorities"));
            sb.append(NEWLINE);
            for (GeneralName nameRegistrationAuthority : nameRegistrationAuthorities) {
                sb.append(INDENT.toString(baseIndentLevel + 2));
                sb.append(GeneralNameUtil.toString(nameRegistrationAuthority));
                sb.append(NEWLINE);
            }
        }
        return sb.toString();
    }

    private static String getMonetaryValueStringValue(ASN1Encodable asn1Encodable, int baseIndentLevel) {
        StringBuilder sb = new StringBuilder();
        MonetaryValue monetaryValue = MonetaryValue.getInstance((Object)asn1Encodable);
        BigInteger amount = monetaryValue.getAmount();
        Iso4217CurrencyCode currency = monetaryValue.getCurrency();
        BigInteger exponent = monetaryValue.getExponent();
        if (currency != null) {
            String currencyString = currency.isAlphabetic() ? currency.getAlphabetic() : "" + currency.getNumeric();
            sb.append(INDENT.toString(baseIndentLevel));
            sb.append(MessageFormat.format(res.getString("QCEuLimitValue.Currency"), currencyString));
            sb.append(NEWLINE);
        }
        if (amount != null) {
            sb.append(INDENT.toString(baseIndentLevel));
            sb.append(MessageFormat.format(res.getString("QCEuLimitValue.Amount"), amount.toString()));
            sb.append(NEWLINE);
        }
        if (exponent != null) {
            sb.append(INDENT.toString(baseIndentLevel));
            sb.append(MessageFormat.format(res.getString("QCEuLimitValue.Exponent"), exponent.toString()));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getOcspNoCheckStringValue() {
        return res.getString("OCSPNoCheck");
    }

    private static String getAdmissionStringValue(byte[] octets) throws IOException {
        StringBuilder sb = new StringBuilder();
        int indentLevel = 1;
        AdmissionSyntax admissionSyntax = AdmissionSyntax.getInstance((Object)ASN1Sequence.getInstance((Object)octets));
        GeneralName admissionAuthority = admissionSyntax.getAdmissionAuthority();
        if (admissionAuthority != null) {
            sb.append(MessageFormat.format(res.getString("Admission.AdmissionAuthority"), GeneralNameUtil.toString(admissionAuthority)));
            sb.append(NEWLINE);
        }
        Admissions[] admissions = admissionSyntax.getContentsOfAdmissions();
        int admissionNr = 0;
        for (Admissions admission : admissions) {
            sb.append(MessageFormat.format(res.getString("Admission.Admission"), ++admissionNr));
            sb.append(NEWLINE);
            admissionAuthority = admission.getAdmissionAuthority();
            NamingAuthority namingAuthority = admission.getNamingAuthority();
            ProfessionInfo[] professionInfos = admission.getProfessionInfos();
            if (admissionAuthority != null) {
                sb.append(INDENT.toString(indentLevel));
                sb.append(MessageFormat.format(res.getString("Admission.AdmissionAuthority"), GeneralNameUtil.toString(admissionAuthority)));
                sb.append(NEWLINE);
            }
            if (namingAuthority != null) {
                sb.append(X509Ext.getNamingAuthorityStringValue(namingAuthority, indentLevel));
            }
            for (ProfessionInfo professionInfo : professionInfos) {
                DirectoryString[] professionItems;
                namingAuthority = professionInfo.getNamingAuthority();
                ASN1ObjectIdentifier[] professionOIDs = professionInfo.getProfessionOIDs();
                String registrationNumber = professionInfo.getRegistrationNumber();
                ASN1OctetString addProfessionInfo = professionInfo.getAddProfessionInfo();
                sb.append(INDENT.toString(indentLevel));
                sb.append(res.getString("Admission.ProfessionInfo"));
                sb.append(NEWLINE);
                ++indentLevel;
                if (namingAuthority != null) {
                    sb.append(X509Ext.getNamingAuthorityStringValue(namingAuthority, indentLevel));
                }
                for (DirectoryString directoryString : professionItems = professionInfo.getProfessionItems()) {
                    sb.append(INDENT.toString(indentLevel));
                    sb.append(MessageFormat.format(res.getString("Admission.ProfessionItem"), directoryString.toString()));
                    sb.append(NEWLINE);
                }
                if (professionOIDs != null) {
                    for (DirectoryString directoryString : professionOIDs) {
                        sb.append(INDENT.toString(indentLevel));
                        sb.append(MessageFormat.format(res.getString("Admission.ProfessionOID"), directoryString.getId()));
                        sb.append(NEWLINE);
                    }
                }
                if (registrationNumber != null) {
                    sb.append(INDENT.toString(indentLevel));
                    sb.append(MessageFormat.format(res.getString("Admission.RegistrationNumber"), registrationNumber));
                    sb.append(NEWLINE);
                }
                if (addProfessionInfo != null) {
                    sb.append(INDENT.toString(indentLevel));
                    sb.append(MessageFormat.format(res.getString("Admission.AddProfessionInfo"), HexUtil.getHexString(addProfessionInfo.getOctets())));
                    sb.append(NEWLINE);
                }
                --indentLevel;
            }
        }
        return sb.toString();
    }

    private static String getNamingAuthorityStringValue(NamingAuthority namingAuthority, int indentLevel) throws IOException {
        StringBuilder sb = new StringBuilder();
        ASN1ObjectIdentifier namingAuthorityId = namingAuthority.getNamingAuthorityId();
        String namingAuthorityUrl = namingAuthority.getNamingAuthorityUrl();
        DirectoryString namingAuthorityText = namingAuthority.getNamingAuthorityText();
        if (namingAuthorityId != null) {
            sb.append(INDENT.toString(indentLevel));
            sb.append(MessageFormat.format(res.getString("Admission.NamingAuthorityOID"), namingAuthorityId.getId()));
            sb.append(NEWLINE);
        }
        if (namingAuthorityUrl != null) {
            sb.append(INDENT.toString(indentLevel));
            sb.append(MessageFormat.format(res.getString("Admission.NamingAuthorityURL"), namingAuthorityUrl));
            sb.append(NEWLINE);
        }
        if (namingAuthorityText != null) {
            sb.append(INDENT.toString(indentLevel));
            sb.append(MessageFormat.format(res.getString("Admission.NamingAuthorityText"), namingAuthorityText.toString()));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getLiabilityLimitationFlagStringValue(byte[] octets) {
        ASN1Boolean asn1Boolean = ASN1Boolean.getInstance((Object)octets);
        return asn1Boolean.toString();
    }

    private static String getDateOfCertGenStringValue(byte[] octets) {
        ASN1GeneralizedTime dateOfCertGenSyntax = ASN1GeneralizedTime.getInstance((Object)octets);
        return X509Ext.getGeneralizedTimeString(dateOfCertGenSyntax);
    }

    private static String getProcurationStringValue(byte[] octets) throws IOException {
        StringBuilder sb = new StringBuilder();
        ProcurationSyntax procurationSyntax = ProcurationSyntax.getInstance((Object)octets);
        String country = procurationSyntax.getCountry();
        DirectoryString typeOfSubstitution = procurationSyntax.getTypeOfSubstitution();
        GeneralName thirdPerson = procurationSyntax.getThirdPerson();
        IssuerSerial certRef = procurationSyntax.getCertRef();
        if (country != null) {
            sb.append(MessageFormat.format(res.getString("Procuration.Country"), country));
            sb.append(NEWLINE);
        }
        if (typeOfSubstitution != null) {
            sb.append(MessageFormat.format(res.getString("Procuration.TypeOfSubstitution"), typeOfSubstitution.toString()));
            sb.append(NEWLINE);
        }
        if (thirdPerson != null) {
            sb.append(MessageFormat.format(res.getString("Procuration.ThirdPerson"), GeneralNameUtil.toString(thirdPerson)));
            sb.append(NEWLINE);
        }
        if (certRef != null) {
            sb.append(res.getString("Procuration.CertRef"));
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(res.getString("Procuration.CertRef.Issuer"));
            for (GeneralName generalName : certRef.getIssuer().getNames()) {
                sb.append(INDENT);
                sb.append(INDENT);
                sb.append(GeneralNameUtil.toString(generalName));
                sb.append(NEWLINE);
            }
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(MessageFormat.format(res.getString("Procuration.CertRef.SN"), HexUtil.getHexString(certRef.getSerial().getValue())));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getMonetaryLimitStringValue(byte[] octets) {
        StringBuilder sb = new StringBuilder();
        MonetaryLimit monetaryLimit = MonetaryLimit.getInstance((Object)octets);
        String currency = monetaryLimit.getCurrency();
        BigInteger amount = monetaryLimit.getAmount();
        BigInteger exponent = monetaryLimit.getExponent();
        if (currency != null) {
            sb.append(MessageFormat.format(res.getString("MonetaryLimit.Currency"), currency));
            sb.append(NEWLINE);
        }
        if (amount != null) {
            sb.append(MessageFormat.format(res.getString("MonetaryLimit.Amount"), amount.toString()));
            sb.append(NEWLINE);
        }
        if (exponent != null) {
            sb.append(MessageFormat.format(res.getString("MonetaryLimit.Exponent"), exponent.toString()));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getDeclarationOfMajorityStringValue(byte[] octets) {
        StringBuilder sb = new StringBuilder();
        DeclarationOfMajority declarationOfMajority = DeclarationOfMajority.getInstance((Object)octets);
        int notYoungerThan = declarationOfMajority.notYoungerThan();
        ASN1Sequence fullAgeAtCountry = declarationOfMajority.fullAgeAtCountry();
        ASN1GeneralizedTime dateOfBirth = declarationOfMajority.getDateOfBirth();
        if (notYoungerThan != -1) {
            sb.append(MessageFormat.format(res.getString("DeclarationOfMajority.notYoungerThan"), notYoungerThan));
            sb.append(NEWLINE);
        }
        if (fullAgeAtCountry != null) {
            ASN1Boolean fullAge = ASN1Boolean.getInstance((Object)fullAgeAtCountry.getObjectAt(0));
            DERPrintableString country = DERPrintableString.getInstance((Object)fullAgeAtCountry.getObjectAt(1));
            sb.append(MessageFormat.format(res.getString("DeclarationOfMajority.fullAgeAtCountry"), country.toString(), fullAge.toString()));
            sb.append(NEWLINE);
        }
        if (dateOfBirth != null) {
            sb.append(MessageFormat.format(res.getString("DeclarationOfMajority.dateOfBirth"), dateOfBirth));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getICCSNStringValue(byte[] octets) {
        return HexUtil.getHexString(octets);
    }

    private static String getRestrictionStringValue(byte[] octets) throws IOException {
        return DirectoryString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])octets)).toString();
    }

    private static String getAdditionalInformationStringValue(byte[] octets) throws IOException {
        return DirectoryString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])octets)).toString();
    }

    private static String getValidityModelStringValue(byte[] octets) {
        ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)octets);
        ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance((Object)asn1Sequence.getObjectAt(0));
        ValidityModelType validityModel = ValidityModelType.resolveOid(oid.getId());
        return validityModel.friendly();
    }

    private static String getMsCertTypeStringValue(byte[] octets) {
        DERBMPString derbmpString = DERBMPString.getInstance((Object)octets);
        return derbmpString.toString();
    }

    private static String getMsCaVersionStringValue(byte[] octets) {
        ASN1Integer asn1Integer = ASN1Integer.getInstance((Object)octets);
        int version = asn1Integer.getValue().intValue();
        String certIndex = String.valueOf(version & 0xFFFF);
        String keyIndex = String.valueOf(version >> 16);
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format(res.getString("MSCaVersion.CertIndex"), certIndex));
        sb.append(NEWLINE);
        sb.append(MessageFormat.format(res.getString("MSCaVersion.KeyIndex"), keyIndex));
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String getMsCrlNextPublishStringValue(byte[] octets) {
        ASN1UTCTime time = ASN1UTCTime.getInstance((Object)octets);
        return time.getTime();
    }

    private static String getMsCertificateTemplateStringValue(byte[] octets) {
        ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)octets);
        ASN1ObjectIdentifier templateID = (ASN1ObjectIdentifier)asn1Sequence.getObjectAt(0);
        ASN1Integer majorVersion = (ASN1Integer)asn1Sequence.getObjectAt(1);
        ASN1Integer minorVersion = (ASN1Integer)asn1Sequence.getObjectAt(2);
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format(res.getString("MSCertificateTemplate.ID"), templateID.getId()));
        sb.append(NEWLINE);
        sb.append(MessageFormat.format(res.getString("MSCertificateTemplate.MajorVersion"), majorVersion));
        sb.append(NEWLINE);
        if (minorVersion != null) {
            sb.append(MessageFormat.format(res.getString("MSCertificateTemplate.MinorVersion"), minorVersion));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getSMIMECapabilitiesStringValue(byte[] octets) throws IOException {
        StringBuilder sb = new StringBuilder();
        int capabilityNr = 0;
        ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)octets);
        for (ASN1Encodable asn1Encodable : asn1Sequence.toArray()) {
            SMIMECapability capability = SMIMECapability.getInstance((Object)asn1Encodable);
            ASN1ObjectIdentifier oid = capability.getCapabilityID();
            ASN1Encodable parameters = capability.getParameters();
            sb.append(MessageFormat.format(res.getString("SMIMECapability"), ++capabilityNr));
            sb.append(NEWLINE);
            sb.append(INDENT);
            sb.append(MessageFormat.format(res.getString("SMIMECapability.ObjectID"), ObjectIdUtil.toString(oid)));
            sb.append(NEWLINE);
            if (parameters == null) continue;
            sb.append(INDENT);
            sb.append(MessageFormat.format(res.getString("SMIMECapability.Parameter"), HexUtil.getHexString(parameters.toASN1Primitive().getEncoded())));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private static String getBitString(byte[] octets) throws IOException {
        if (octets == null) {
            return "";
        }
        DERBitString derBitString = DERBitString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])octets));
        byte[] bitStringBytes = derBitString.getBytes();
        return new BigInteger(1, bitStringBytes).toString(2);
    }

    private static String getVeriSignNonVerified(byte[] octets) throws IOException {
        StringBuilder sb = new StringBuilder();
        ASN1Set asn1Set = ASN1Set.getInstance((Object)octets);
        for (ASN1Encodable attribute : asn1Set.toArray()) {
            ASN1ObjectIdentifier attributeId = ((Attribute)attribute).getAttrType();
            ASN1Set attributeValues = ((Attribute)attribute).getAttrValues();
            for (ASN1Encodable attributeValue : attributeValues.toArray()) {
                String attributeValueStr = X509Ext.getAttributeValueString(attributeId, attributeValue);
                sb.append(MessageFormat.format("{0}={1}", attributeId.getId(), attributeValueStr));
                sb.append(NEWLINE);
            }
        }
        return sb.toString();
    }
}

