/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.kse.utilities.os.OperatingSystem;

public class LnfUtil {
    private static final String VAQUA_LAF_CLASS = "org.violetlib.aqua.AquaLookAndFeel";

    private LnfUtil() {
    }

    public static boolean matchLnf(LookAndFeel lookAndFeel, UIManager.LookAndFeelInfo lookAndFeelInfo) {
        return lookAndFeel.getClass().getName().equals(lookAndFeelInfo.getClassName());
    }

    public static void installLnfs() {
        UIManager.installLookAndFeel("Flat Light", FlatLightLaf.class.getName());
        UIManager.installLookAndFeel("Flat Dark", FlatDarkLaf.class.getName());
        UIManager.installLookAndFeel("Flat IntelliJ", FlatIntelliJLaf.class.getName());
        UIManager.installLookAndFeel("Flat Darcula", FlatDarculaLaf.class.getName());
        if (OperatingSystem.isMacOs() && LnfUtil.isVAquaAvailable()) {
            UIManager.installLookAndFeel("macOS (VAqua)", VAQUA_LAF_CLASS);
        }
    }

    public static void useLnf(String lnfClassName) {
        try {
            UIManager.setLookAndFeel(lnfClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
    }

    public static String useLnfForPlatform() {
        String xdgCurrentDesktop;
        String lnfClassName = null;
        lnfClassName = OperatingSystem.isMacOs() || OperatingSystem.isWindows() ? UIManager.getSystemLookAndFeelClassName() : ("Unity".equalsIgnoreCase(xdgCurrentDesktop = System.getenv("XDG_CURRENT_DESKTOP")) || "XFCE".equalsIgnoreCase(xdgCurrentDesktop) || "GNOME".equalsIgnoreCase(xdgCurrentDesktop) || "X-Cinnamon".equalsIgnoreCase(xdgCurrentDesktop) || "LXDE".equalsIgnoreCase(xdgCurrentDesktop) ? UIManager.getSystemLookAndFeelClassName() : FlatLightLaf.class.getName());
        LnfUtil.useLnf(lnfClassName);
        return lnfClassName;
    }

    public static boolean usingMacLnf() {
        String lnfClass = UIManager.getLookAndFeel().getClass().getName();
        return OperatingSystem.isMacOs() && (UIManager.getSystemLookAndFeelClassName().equals(lnfClass) || lnfClass.equals(VAQUA_LAF_CLASS));
    }

    public static boolean usingMetalLnf() {
        return LnfUtil.usingLnf(MetalLookAndFeel.class.getName());
    }

    public static boolean usingWindowsLnf() {
        return LnfUtil.usingLnf(UIManager.getSystemLookAndFeelClassName());
    }

    private static boolean usingLnf(String lnfClass) {
        String currentLnfClass = UIManager.getLookAndFeel().getClass().getName();
        return currentLnfClass.equals(lnfClass);
    }

    public static boolean isDarkLnf() {
        return UIManager.getLookAndFeel().getClass().isAssignableFrom(FlatDarkLaf.class) || UIManager.getLookAndFeel().getClass().isAssignableFrom(FlatDarculaLaf.class);
    }

    public static boolean isVAquaAvailable() {
        try {
            Class.forName(VAQUA_LAF_CLASS);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static int getDefaultFontSize() {
        Font defaultFont = new JLabel().getFont();
        return defaultFont.getSize();
    }
}

