/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.about;

import java.util.Comparator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class EnvironmentVariablesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/about/resources");
    private String[] columnNames = new String[2];
    private String[][] data;

    public EnvironmentVariablesTableModel() {
        this.columnNames[0] = res.getString("EnvironmentVariablesTableModel.NameColumn");
        this.columnNames[1] = res.getString("EnvironmentVariablesTableModel.ValueColumn");
        this.data = new String[0][0];
    }

    public void load() {
        TreeMap<String, String> envs = new TreeMap<String, String>(new EnvironmentVariableComparator());
        envs.putAll(System.getenv());
        this.data = new String[envs.size()][2];
        int i = 0;
        for (Map.Entry property : envs.entrySet()) {
            this.data[i][0] = property.getKey();
            this.data[i][1] = (String)property.getValue();
            ++i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    private class EnvironmentVariableComparator
    implements Comparator<String> {
        private EnvironmentVariableComparator() {
        }

        @Override
        public int compare(String name1, String name2) {
            return name1.compareToIgnoreCase(name2);
        }
    }
}

