/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.KeyStore;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class DeleteKeyAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;

    public DeleteKeyAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("DeleteKeyAction.statusbar"));
        this.putValue("Name", res.getString("DeleteKeyAction.text"));
        this.putValue("ShortDescription", res.getString("DeleteKeyAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/delete.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        this.deleteSelectedEntry();
    }

    public void deleteSelectedEntry() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            String alias = this.kseFrame.getSelectedEntryAlias();
            String message = MessageFormat.format(res.getString("DeleteKeyAction.ConfirmDelete.message"), alias);
            int selected = JOptionPane.showConfirmDialog(this.frame, message, res.getString("DeleteKeyAction.DeleteEntry.Title"), 0);
            if (selected != 0) {
                return;
            }
            keyStore.deleteEntry(alias);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

