/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.keystore.KeyStoreUtil;
import org.kse.crypto.privatekey.Pkcs8PbeType;
import org.kse.crypto.privatekey.Pkcs8Util;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.importexport.DExportKeyPair;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class ExportKeyPairAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public ExportKeyPairAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("ExportKeyPairAction.statusbar"));
        this.putValue("Name", res.getString("ExportKeyPairAction.text"));
        this.putValue("ShortDescription", res.getString("ExportKeyPairAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/exportkeypair.png"))));
    }

    @Override
    protected void doAction() {
        File exportFile = null;
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            String alias = this.kseFrame.getSelectedEntryAlias();
            Password password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return;
            }
            KeyStore keyStore = currentState.getKeyStore();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            Certificate[] certificates = keyStore.getCertificateChain(alias);
            DExportKeyPair dExportKeyPair = new DExportKeyPair(this.frame, alias, this.applicationSettings.getPasswordQualityConfig());
            dExportKeyPair.setLocationRelativeTo(this.frame);
            dExportKeyPair.setVisible(true);
            if (!dExportKeyPair.isExportSelected()) {
                return;
            }
            exportFile = dExportKeyPair.getExportFile();
            Password exportPassword = dExportKeyPair.getExportPassword();
            DExportKeyPair.ExportFormat exportFormat = dExportKeyPair.getExportFormat();
            if (exportFormat == DExportKeyPair.ExportFormat.PKCS12) {
                this.exportAsPkcs12(exportFile, alias, privateKey, certificates, exportPassword);
            } else {
                this.exportAsPem(exportFile, privateKey, certificates, exportPassword);
            }
            JOptionPane.showMessageDialog(this.frame, res.getString("ExportKeyPairAction.ExportKeyPairSuccessful.message"), res.getString("ExportKeyPairAction.ExportKeyPair.Title"), 1);
        }
        catch (FileNotFoundException ex) {
            String message = MessageFormat.format(res.getString("ExportKeyPairAction.NoWriteFile.message"), exportFile);
            JOptionPane.showMessageDialog(this.frame, message, res.getString("ExportKeyPairAction.ExportKeyPair.Title"), 2);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private void exportAsPkcs12(File exportFile, String alias, PrivateKey privateKey, Certificate[] certificates, Password exportPassword) throws CryptoException, IOException, KeyStoreException {
        KeyStore pkcs12 = KeyStoreUtil.create(KeyStoreType.PKCS12);
        certificates = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(certificates));
        pkcs12.setKeyEntry(alias, privateKey, exportPassword.toCharArray(), certificates);
        KeyStoreUtil.save(pkcs12, exportFile, exportPassword);
    }

    private void exportAsPem(File exportFile, PrivateKey privateKey, Certificate[] certs, Password password) throws CryptoException, IOException {
        String pemEncodedPrivKey = null;
        pemEncodedPrivKey = password.isEmpty() ? Pkcs8Util.getPem(privateKey) : Pkcs8Util.getEncryptedPem(privateKey, Pkcs8PbeType.SHA1_3KEY_DESEDE, password);
        X509Certificate[] orderedCerts = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(certs));
        String pemEncodedCerts = X509CertUtil.getCertsEncodedX509Pem(orderedCerts);
        FileUtils.write((File)exportFile, (CharSequence)(pemEncodedPrivKey + pemEncodedCerts), (Charset)StandardCharsets.US_ASCII);
    }
}

