/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.crypto.CryptoException;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.importexport.DExportCertificates;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;

public class ExportKeyPairCertificateChainAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public ExportKeyPairCertificateChainAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("ExportKeyPairCertificateChainAction.statusbar"));
        this.putValue("Name", res.getString("ExportKeyPairCertificateChainAction.text"));
        this.putValue("ShortDescription", res.getString("ExportKeyPairCertificateChainAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/exportkeypaircertchain.png"))));
    }

    @Override
    protected void doAction() {
        File exportFile = null;
        try {
            String alias = this.kseFrame.getSelectedEntryAlias();
            DExportCertificates dExportCertificates = new DExportCertificates(this.frame, alias, true);
            dExportCertificates.setLocationRelativeTo(this.frame);
            dExportCertificates.setVisible(true);
            if (!dExportCertificates.exportSelected()) {
                return;
            }
            exportFile = dExportCertificates.getExportFile();
            boolean pemEncode = dExportCertificates.pemEncode();
            boolean exportChain = dExportCertificates.exportChain();
            byte[] encoded = null;
            if (exportChain) {
                X509Certificate[] certChain = this.getCertificateChain(alias);
                if (dExportCertificates.exportFormatX509()) {
                    encoded = X509CertUtil.getCertsEncodedX509Pem(certChain).getBytes();
                } else if (dExportCertificates.exportFormatPkcs7()) {
                    encoded = pemEncode ? X509CertUtil.getCertsEncodedPkcs7Pem(certChain).getBytes() : X509CertUtil.getCertsEncodedPkcs7(certChain);
                } else if (dExportCertificates.exportFormatPkiPath()) {
                    encoded = X509CertUtil.getCertsEncodedPkiPath(certChain);
                } else if (dExportCertificates.exportFormatSpc()) {
                    encoded = X509CertUtil.getCertsEncodedPkcs7(certChain);
                }
            } else {
                X509Certificate cert = this.getHeadCertificate(alias);
                if (dExportCertificates.exportFormatX509()) {
                    encoded = pemEncode ? X509CertUtil.getCertEncodedX509Pem(cert).getBytes() : X509CertUtil.getCertEncodedX509(cert);
                } else if (dExportCertificates.exportFormatPkcs7()) {
                    encoded = pemEncode ? X509CertUtil.getCertEncodedPkcs7Pem(cert).getBytes() : X509CertUtil.getCertEncodedPkcs7(cert);
                } else if (dExportCertificates.exportFormatPkiPath()) {
                    encoded = X509CertUtil.getCertEncodedPkiPath(cert);
                } else if (dExportCertificates.exportFormatSpc()) {
                    encoded = X509CertUtil.getCertEncodedPkcs7(cert);
                }
            }
            this.exportEncodedCertificates(encoded, exportFile);
            JOptionPane.showMessageDialog(this.frame, res.getString("ExportKeyPairCertificateChainAction.ExportCertificateChainSuccessful.message"), res.getString("ExportKeyPairCertificateChainAction.ExportCertificateChain.Title"), 1);
        }
        catch (FileNotFoundException ex) {
            String message = MessageFormat.format(res.getString("ExportKeyPairCertificateChainAction.NoWriteFile.message"), exportFile);
            JOptionPane.showMessageDialog(this.frame, message, res.getString("ExportKeyPairCertificateChainAction.ExportCertificateChain.Title"), 2);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private X509Certificate getHeadCertificate(String alias) throws CryptoException {
        return X509CertUtil.orderX509CertChain(this.getCertificateChain(alias))[0];
    }

    private X509Certificate[] getCertificateChain(String alias) throws CryptoException {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStore keyStore = history.getCurrentState().getKeyStore();
            return X509CertUtil.convertCertificates(keyStore.getCertificateChain(alias));
        }
        catch (KeyStoreException ex) {
            String message = MessageFormat.format(res.getString("ExportKeyPairCertificateChainAction.NoAccessEntry.message"), alias);
            throw new CryptoException(message, ex);
        }
    }

    private void exportEncodedCertificates(byte[] encoded, File exportFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(exportFile);){
            fos.write(encoded);
            fos.flush();
        }
    }
}

