/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.crypto.CryptoException;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.importexport.DExportCertificates;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;

public class ExportTrustedCertificateAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;
    private X509Certificate certFromConstructor;

    public ExportTrustedCertificateAction(KseFrame kseFrame) {
        this(kseFrame, null);
    }

    public ExportTrustedCertificateAction(KseFrame kseFrame, X509Certificate cert) {
        super(kseFrame);
        this.certFromConstructor = cert;
        this.putValue("LongDescription", res.getString("ExportTrustedCertificateAction.statusbar"));
        this.putValue("Name", res.getString("ExportTrustedCertificateAction.text"));
        this.putValue("ShortDescription", res.getString("ExportTrustedCertificateAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/exporttrustcert.png"))));
    }

    @Override
    protected void doAction() {
        File exportFile = null;
        try {
            DExportCertificates dExportCertificates = null;
            X509Certificate cert = null;
            if (this.certFromConstructor == null) {
                String alias = this.kseFrame.getSelectedEntryAlias();
                dExportCertificates = new DExportCertificates(this.frame, alias, false);
                cert = this.getCertificate(alias);
            } else {
                cert = this.certFromConstructor;
                dExportCertificates = new DExportCertificates(this.frame, X509CertUtil.getCertificateAlias(cert), false);
            }
            dExportCertificates.setLocationRelativeTo(this.frame);
            dExportCertificates.setVisible(true);
            if (!dExportCertificates.exportSelected()) {
                return;
            }
            exportFile = dExportCertificates.getExportFile();
            boolean pemEncode = dExportCertificates.pemEncode();
            byte[] encoded = null;
            if (dExportCertificates.exportFormatX509()) {
                encoded = pemEncode ? X509CertUtil.getCertEncodedX509Pem(cert).getBytes() : X509CertUtil.getCertEncodedX509(cert);
            } else if (dExportCertificates.exportFormatPkcs7()) {
                encoded = pemEncode ? X509CertUtil.getCertEncodedPkcs7Pem(cert).getBytes() : X509CertUtil.getCertEncodedPkcs7(cert);
            } else if (dExportCertificates.exportFormatPkiPath()) {
                encoded = X509CertUtil.getCertEncodedPkiPath(cert);
            } else if (dExportCertificates.exportFormatSpc()) {
                encoded = X509CertUtil.getCertEncodedPkcs7(cert);
            }
            this.exportEncodedCertificate(encoded, exportFile);
            JOptionPane.showMessageDialog(this.frame, res.getString("ExportTrustedCertificateAction.ExportCertificateSuccessful.message"), res.getString("ExportTrustedCertificateAction.ExportCertificate.Title"), 1);
        }
        catch (FileNotFoundException ex) {
            String message = MessageFormat.format(res.getString("ExportTrustedCertificateAction.NoWriteFile.message"), exportFile);
            JOptionPane.showMessageDialog(this.frame, message, res.getString("ExportTrustedCertificateAction.ExportCertificate.Title"), 2);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private X509Certificate getCertificate(String alias) throws CryptoException {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStore keyStore = history.getCurrentState().getKeyStore();
            X509Certificate cert = X509CertUtil.convertCertificate(keyStore.getCertificate(alias));
            return cert;
        }
        catch (KeyStoreException ex) {
            String message = MessageFormat.format(res.getString("ExportTrustedCertificateAction.NoAccessEntry.message"), alias);
            throw new CryptoException(message, ex);
        }
    }

    private void exportEncodedCertificate(byte[] encoded, File exportFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(exportFile);){
            fos.write(encoded);
            fos.flush();
        }
    }
}

