/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.KSE;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;

public class HelpAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;
    private String websiteAddress;

    public HelpAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
        this.putValue("LongDescription", res.getString("HelpAction.statusbar"));
        this.putValue("Name", res.getString("HelpAction.text"));
        this.putValue("ShortDescription", res.getString("HelpAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/help.png"))));
        this.websiteAddress = "https://keystore-explorer.org/doc/" + KSE.getUserManualVersion() + "/";
    }

    @Override
    protected void doAction() {
        try {
            Desktop.getDesktop().browse(URI.create(this.websiteAddress));
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("WebsiteAction.NoLaunchBrowser.message"), this.websiteAddress), KSE.getApplicationName(), 1);
        }
    }
}

