/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.AuthorityCertificatesAction;
import org.kse.gui.actions.NewAction;
import org.kse.gui.dialogs.DGetAlias;
import org.kse.gui.dialogs.DViewCertificate;
import org.kse.gui.error.DError;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class ImportTrustedCertificateAction
extends AuthorityCertificatesAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;
    private X509Certificate trustCertFromConstructor;
    private File certFile;

    public ImportTrustedCertificateAction(KseFrame kseFrame) {
        this(kseFrame, null);
    }

    public ImportTrustedCertificateAction(KseFrame kseFrame, X509Certificate trustCert) {
        super(kseFrame);
        this.trustCertFromConstructor = trustCert;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("ImportTrustedCertificateAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("ImportTrustedCertificateAction.statusbar"));
        this.putValue("Name", res.getString("ImportTrustedCertificateAction.text"));
        this.putValue("ShortDescription", res.getString("ImportTrustedCertificateAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/importcert.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            if (history == null) {
                new NewAction(this.kseFrame).actionPerformed(null);
                history = this.kseFrame.getActiveKeyStoreHistory();
                if (history == null) {
                    return;
                }
            }
            KeyStoreState currentState = history.getCurrentState();
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            X509Certificate trustCert = null;
            if (this.trustCertFromConstructor == null) {
                trustCert = this.showFileSelectionDialog();
                if (trustCert == null) {
                    return;
                }
            } else {
                trustCert = this.trustCertFromConstructor;
            }
            if (this.applicationSettings.getEnableImportTrustedCertTrustCheck()) {
                int selected;
                String matchAlias = X509CertUtil.matchCertificate(keyStore, trustCert);
                if (matchAlias != null && (selected = JOptionPane.showConfirmDialog(this.frame, MessageFormat.format(res.getString("ImportTrustedCertificateAction.TrustCertExistsConfirm.message"), matchAlias), res.getString("ImportTrustedCertificateAction.ImportTrustCert.Title"), 0)) != 0) {
                    return;
                }
                KeyStore caCertificates = this.getCaCertificates();
                KeyStore windowsTrustedRootCertificates = this.getWindowsTrustedRootCertificates();
                ArrayList<KeyStore> compKeyStores = new ArrayList<KeyStore>();
                compKeyStores.add(keyStore);
                if (caCertificates != null) {
                    compKeyStores.add(caCertificates);
                }
                if (windowsTrustedRootCertificates != null) {
                    compKeyStores.add(windowsTrustedRootCertificates);
                }
                if (X509CertUtil.establishTrust(trustCert, compKeyStores.toArray(new KeyStore[compKeyStores.size()])) == null) {
                    int selected2;
                    if (this.certFile != null) {
                        JOptionPane.showMessageDialog(this.frame, res.getString("ImportTrustedCertificateAction.NoTrustPathCertConfirm.message"), res.getString("ImportTrustedCertificateAction.ImportTrustCert.Title"), 1);
                        DViewCertificate dViewCertificate = new DViewCertificate(this.frame, MessageFormat.format(res.getString("ImportTrustedCertificateAction.CertDetailsFile.Title"), this.certFile.getName()), new X509Certificate[]{trustCert}, null, DViewCertificate.NONE);
                        dViewCertificate.setLocationRelativeTo(this.frame);
                        dViewCertificate.setVisible(true);
                    }
                    if ((selected2 = JOptionPane.showConfirmDialog(this.frame, res.getString("ImportTrustedCertificateAction.AcceptTrustCert.message"), res.getString("ImportTrustedCertificateAction.ImportTrustCert.Title"), 0)) != 0) {
                        return;
                    }
                }
            }
            DGetAlias dGetAlias = new DGetAlias(this.frame, res.getString("ImportTrustedCertificateAction.TrustCertEntryAlias.Title"), X509CertUtil.getCertificateAlias(trustCert));
            dGetAlias.setLocationRelativeTo(this.frame);
            dGetAlias.setVisible(true);
            String alias = dGetAlias.getAlias();
            if (alias == null) {
                return;
            }
            if (keyStore.containsAlias(alias)) {
                String message = MessageFormat.format(res.getString("ImportTrustedCertificateAction.OverWriteEntry.message"), alias);
                int selected = JOptionPane.showConfirmDialog(this.frame, message, res.getString("ImportTrustedCertificateAction.ImportTrustCert.Title"), 0);
                if (selected != 0) {
                    return;
                }
                keyStore.deleteEntry(alias);
                newState.removeEntryPassword(alias);
            }
            keyStore.setCertificateEntry(alias, trustCert);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("ImportTrustedCertificateAction.ImportTrustCertSuccessful.message"), res.getString("ImportTrustedCertificateAction.ImportTrustCert.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private X509Certificate showFileSelectionDialog() {
        this.certFile = this.chooseTrustedCertificateFile();
        if (this.certFile == null) {
            return null;
        }
        X509Certificate[] certs = this.openCertificate(this.certFile);
        if (certs == null || certs.length == 0) {
            return null;
        }
        if (certs.length > 1) {
            JOptionPane.showMessageDialog(this.frame, res.getString("ImportTrustedCertificateAction.NoMultipleTrustCertImport.message"), res.getString("ImportTrustedCertificateAction.ImportTrustCert.Title"), 2);
            return null;
        }
        return certs[0];
    }

    private File chooseTrustedCertificateFile() {
        JFileChooser chooser = FileChooserFactory.getX509FileChooser();
        chooser.setCurrentDirectory(CurrentDirectory.get());
        chooser.setDialogTitle(res.getString("ImportTrustedCertificateAction.ImportTrustCert.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("ImportTrustedCertificateAction.ImportTrustCert.button"));
        int rtnValue = chooser.showOpenDialog(this.frame);
        if (rtnValue == 0) {
            File importFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(importFile);
            return importFile;
        }
        return null;
    }
}

