/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.crypto.Password;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class RemoveFromCertificateChainAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;

    public RemoveFromCertificateChainAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("RemoveFromCertificateChainAction.statusbar"));
        this.putValue("Name", res.getString("RemoveFromCertificateChainAction.text"));
        this.putValue("ShortDescription", res.getString("RemoveFromCertificateChainAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/removecert.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            String alias = this.kseFrame.getSelectedEntryAlias();
            Password password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return;
            }
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            Key privKey = keyStore.getKey(alias, password.toCharArray());
            X509Certificate[] certChain = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(keyStore.getCertificateChain(alias)));
            if (certChain.length == 1) {
                JOptionPane.showMessageDialog(this.frame, res.getString("RemoveFromCertificateChainAction.CannotRemoveOnlyCert.message"), res.getString("RemoveFromCertificateChainAction.RemoveFromCertificateChain.Title"), 2);
                return;
            }
            Certificate[] newCertChain = new X509Certificate[certChain.length - 1];
            System.arraycopy(certChain, 0, newCertChain, 0, newCertChain.length);
            keyStore.deleteEntry(alias);
            keyStore.setKeyEntry(alias, privKey, password.toCharArray(), newCertChain);
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("RemoveFromCertificateChainAction.RemoveFromCertificateChainSuccessful.message"), res.getString("RemoveFromCertificateChainAction.RemoveFromCertificateChain.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

