/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.error.DError;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class SetPasswordAction
extends KeyStoreExplorerAction
implements HistoryAction {
    private static final long serialVersionUID = 1L;

    public SetPasswordAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("SetPasswordAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("SetPasswordAction.statusbar"));
        this.putValue("Name", res.getString("SetPasswordAction.text"));
        this.putValue("ShortDescription", res.getString("SetPasswordAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/setpass.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return res.getString("SetPasswordAction.History.text");
    }

    @Override
    protected void doAction() {
        try {
            if (this.setKeyStorePassword()) {
                JOptionPane.showMessageDialog(this.frame, res.getString("SetPasswordAction.SetKeyStorePasswordSuccessful.message"), res.getString("SetPasswordAction.SetKeyStorePassword.Title"), 1);
            }
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    protected boolean setKeyStorePassword() throws CryptoException {
        KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
        KeyStoreState currentState = history.getCurrentState();
        KeyStoreState newState = currentState.createBasisForNextState(this);
        Password password = this.getNewKeyStorePassword();
        if (password == null) {
            return false;
        }
        newState.setPassword(password);
        currentState.append(newState);
        this.kseFrame.updateControls(true);
        return true;
    }
}

