/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.kse.crypto.Password;
import org.kse.crypto.csr.pkcs10.Pkcs10Util;
import org.kse.crypto.csr.spkac.Spkac;
import org.kse.crypto.filetype.CryptoFileType;
import org.kse.crypto.filetype.CryptoFileUtil;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.signing.SignatureType;
import org.kse.crypto.x509.X500NameUtils;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.crypto.x509.X509CertificateGenerator;
import org.kse.crypto.x509.X509CertificateVersion;
import org.kse.crypto.x509.X509ExtensionSet;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.sign.DSignCsr;
import org.kse.gui.error.DError;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class SignCsrAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public SignCsrAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("SignCsrAction.statusbar"));
        this.putValue("Name", res.getString("SignCsrAction.text"));
        this.putValue("ShortDescription", res.getString("SignCsrAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/signcsr.png"))));
    }

    @Override
    protected void doAction() {
        KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
        KeyStoreState currentState = history.getCurrentState();
        String alias = this.kseFrame.getSelectedEntryAlias();
        Password password = this.getEntryPassword(alias, currentState);
        if (password == null) {
            return;
        }
        KeyStore keyStore = currentState.getKeyStore();
        DSignCsr dSignCsr = null;
        X509Certificate[] signingChain = null;
        X509Certificate signingCert = null;
        PrivateKey privateKey = null;
        try {
            privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            Certificate[] certs = keyStore.getCertificateChain(alias);
            KeyPairType keyPairType = KeyPairUtil.getKeyPairType(privateKey);
            signingChain = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(certs));
            signingCert = signingChain[0];
            File csrFile = this.chooseCsrFile();
            if (csrFile == null) {
                return;
            }
            dSignCsr = this.createSignDialogFromCsrFile(csrFile, privateKey, keyPairType, signingCert);
            if (dSignCsr == null) {
                return;
            }
            dSignCsr.setLocationRelativeTo(this.frame);
            dSignCsr.setVisible(true);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
            return;
        }
        if (dSignCsr.getVersion() == null) {
            return;
        }
        this.generateCaReply(history, dSignCsr, signingChain, signingCert, privateKey);
    }

    private DSignCsr createSignDialogFromCsrFile(File csrFile, PrivateKey privateKey, KeyPairType keyPairType, X509Certificate signingCert) {
        try {
            CryptoFileType fileType = CryptoFileUtil.detectFileType(csrFile);
            if (fileType == CryptoFileType.PKCS10_CSR) {
                PKCS10CertificationRequest pkcs10Csr = Pkcs10Util.loadCsr(FileUtils.readFileToByteArray((File)csrFile));
                if (!Pkcs10Util.verifyCsr(pkcs10Csr)) {
                    JOptionPane.showMessageDialog(this.frame, res.getString("SignCsrAction.NoVerifyPkcs10Csr.message"), res.getString("SignCsrAction.SignCsr.Title"), 2);
                    return null;
                }
                return new DSignCsr(this.frame, pkcs10Csr, csrFile, privateKey, keyPairType, signingCert);
            }
            if (fileType == CryptoFileType.SPKAC_CSR) {
                Spkac spkacCsr = new Spkac(FileUtils.readFileToByteArray((File)csrFile));
                if (!spkacCsr.verify()) {
                    JOptionPane.showMessageDialog(this.frame, res.getString("SignCsrAction.NoVerifySpkacCsr.message"), res.getString("SignCsrAction.SignCsr.Title"), 2);
                    return null;
                }
                return new DSignCsr(this.frame, spkacCsr, csrFile, privateKey, keyPairType, signingCert);
            }
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("SignCsrAction.FileNotRecognisedType.message"), csrFile), res.getString("SignCsrAction.SignCsr.Title"), 2);
            return null;
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("SignCsrAction.NotFile.message"), csrFile), res.getString("SignCsrAction.SignCsr.Title"), 2);
            return null;
        }
        catch (Exception ex) {
            String problemStr = MessageFormat.format(res.getString("SignCsrAction.NoOpenCsr.Problem"), csrFile.getName());
            String[] causes = new String[]{res.getString("SignCsrAction.NotCsr.Cause"), res.getString("SignCsrAction.CorruptedCsr.Cause")};
            DProblem dProblem = new DProblem(this.frame, res.getString("SignCsrAction.ProblemOpeningCsr.Title"), new Problem(problemStr, causes, ex));
            dProblem.setLocationRelativeTo(this.frame);
            dProblem.setVisible(true);
            return null;
        }
    }

    private void generateCaReply(KeyStoreHistory history, DSignCsr dSignCsr, X509Certificate[] signingChain, X509Certificate signingCert, PrivateKey privateKey) {
        Provider provider = history.getExplicitProvider();
        X509CertificateVersion version = dSignCsr.getVersion();
        SignatureType signatureType = dSignCsr.getSignatureType();
        Date validityStart = dSignCsr.getValidityStart();
        Date validityEnd = dSignCsr.getValidityEnd();
        BigInteger serialNumber = dSignCsr.getSerialNumber();
        X509ExtensionSet extensions = dSignCsr.getExtensions();
        X500Name subjectDN = dSignCsr.getSubjectDN();
        PublicKey publicKey = dSignCsr.getPublicKey();
        File caReplyFile = dSignCsr.getCaReplyFile();
        try (FileOutputStream fos = new FileOutputStream(caReplyFile);){
            X500Name issuer = X500NameUtils.x500PrincipalToX500Name(signingCert.getSubjectX500Principal());
            X509CertificateGenerator generator = new X509CertificateGenerator(version);
            X509Certificate caReplyCert = generator.generate(subjectDN, issuer, validityStart, validityEnd, publicKey, privateKey, signatureType, serialNumber, extensions, provider);
            X509Certificate[] caReplyChain = new X509Certificate[signingChain.length + 1];
            caReplyChain[0] = caReplyCert;
            System.arraycopy(signingChain, 0, caReplyChain, 1, signingChain.length);
            byte[] caCertEncoded = X509CertUtil.getCertsEncodedPkcs7(caReplyChain);
            fos.write(caCertEncoded);
            JOptionPane.showMessageDialog(this.frame, res.getString("SignCsrAction.SignCsrSuccessful.message"), res.getString("SignCsrAction.SignCsr.Title"), 1);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("SignJarAction.NoWriteFile.message"), caReplyFile), res.getString("SignCsrAction.SignCsr.Title"), 2);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private File chooseCsrFile() {
        JFileChooser chooser = FileChooserFactory.getCsrFileChooser();
        chooser.setCurrentDirectory(CurrentDirectory.get());
        chooser.setDialogTitle(res.getString("SignCsrAction.ChooseCsr.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("SignCsrAction.ChooseCsr.button"));
        int rtnValue = chooser.showOpenDialog(this.frame);
        if (rtnValue == 0) {
            File importFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(importFile);
            return importFile;
        }
        return null;
    }
}

