/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.KSE;
import org.kse.crypto.Password;
import org.kse.crypto.digest.DigestType;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.signing.JarSigner;
import org.kse.crypto.signing.SignatureType;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.sign.DSignJar;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class SignJarAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = -8414470251471035085L;

    public SignJarAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("SignJarAction.statusbar"));
        this.putValue("Name", res.getString("SignJarAction.text"));
        this.putValue("ShortDescription", res.getString("SignJarAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/signjar.png"))));
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            String alias = this.kseFrame.getSelectedEntryAlias();
            Password password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return;
            }
            KeyStore keyStore = currentState.getKeyStore();
            Provider provider = history.getExplicitProvider();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            X509Certificate[] certs = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(keyStore.getCertificateChain(alias)));
            KeyPairType keyPairType = KeyPairUtil.getKeyPairType(privateKey);
            DSignJar dSignJar = new DSignJar(this.frame, privateKey, keyPairType, alias);
            dSignJar.setLocationRelativeTo(this.frame);
            dSignJar.setVisible(true);
            SignatureType signatureType = dSignJar.getSignatureType();
            String signatureName = dSignJar.getSignatureName();
            File inputJarFile = dSignJar.getInputJar();
            File outputJarFile = dSignJar.getOutputJar();
            String tsaUrl = dSignJar.getTimestampingServerUrl();
            if (signatureType == null) {
                return;
            }
            String signer = KSE.getFullApplicationName();
            DigestType digestType = dSignJar.getDigestType();
            if (inputJarFile.equals(outputJarFile)) {
                JarSigner.sign(inputJarFile, privateKey, certs, signatureType, signatureName, signer, digestType, tsaUrl, provider);
            } else {
                JarSigner.sign(inputJarFile, outputJarFile, privateKey, certs, signatureType, signatureName, signer, digestType, tsaUrl, provider);
            }
            JOptionPane.showMessageDialog(this.frame, res.getString("SignJarAction.SignJarSuccessful.message"), res.getString("SignJarAction.SignJar.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

