/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.ProviderTreeCellRend;

public class DProviderInfo
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/resources");
    private JPanel jpButtons;
    private JButton jbCopy;
    private JButton jbOK;
    private JPanel jpProviders;
    private JTree jtrProviders;
    private JScrollPane jspProviders;

    public DProviderInfo(JFrame parent) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents();
    }

    public DProviderInfo(JDialog parent, Dialog.ModalityType modality) {
        super((Window)parent, modality);
        this.initComponents();
    }

    private void initComponents() {
        this.jbCopy = new JButton(res.getString("DProviderInfo.jbCopy.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCopy, res.getString("DProviderInfo.jbCopy.mnemonic").charAt(0));
        this.jbCopy.setToolTipText(res.getString("DProviderInfo.jbCopy.tooltip"));
        this.jbCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DProviderInfo.this);
                    DProviderInfo.this.copyPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DProviderInfo.this);
                }
            }
        });
        this.jbOK = new JButton(res.getString("DProviderInfo.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DProviderInfo.this.okPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, null, this.jbCopy);
        this.jpProviders = new JPanel(new BorderLayout());
        this.jpProviders.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jtrProviders = new JTree(this.createProviderNodes());
        this.jtrProviders.setRowHeight(Math.max(18, this.jtrProviders.getRowHeight()));
        this.jtrProviders.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.jtrProviders);
        this.jtrProviders.setCellRenderer(new ProviderTreeCellRend());
        this.jspProviders = PlatformUtil.createScrollPane(this.jtrProviders, 22, 32);
        this.jspProviders.setPreferredSize(new Dimension(500, 250));
        this.jpProviders.add((Component)this.jspProviders, "Center");
        this.getContentPane().add((Component)this.jpProviders, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.setTitle(res.getString("DProviderInfo.Title"));
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DProviderInfo.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DProviderInfo.this.jbOK.requestFocus();
            }
        });
    }

    private DefaultMutableTreeNode createProviderNodes() {
        DefaultMutableTreeNode topNode = new DefaultMutableTreeNode(res.getString("DProviderInfo.TopNode.text"));
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Provider provider = providers[i];
            String nameVersion = MessageFormat.format(res.getString("DProviderInfo.ProviderNode.text"), provider.getName(), provider.getVersion());
            DefaultMutableTreeNode providerNode = new DefaultMutableTreeNode(nameVersion);
            topNode.add(providerNode);
            providerNode.add(new DefaultMutableTreeNode(provider.getInfo()));
            providerNode.add(new DefaultMutableTreeNode(provider.getClass().getName()));
            DefaultMutableTreeNode servicesNode = new DefaultMutableTreeNode(res.getString("DProviderInfo.ServicesNode.text"));
            providerNode.add(servicesNode);
            this.addServiceNode("AlgorithmParameterGenerator", res.getString("DProviderInfo.Service.AlgorithmParameterGenerator.text"), provider, servicesNode);
            this.addServiceNode("AlgorithmParameters", res.getString("DProviderInfo.Service.AlgorithmParameters.text"), provider, servicesNode);
            this.addServiceNode("CertificateFactory", res.getString("DProviderInfo.Service.CertificateFactory.text"), provider, servicesNode);
            this.addServiceNode("CertPathBuilder", res.getString("DProviderInfo.Service.CertPathBuilder.text"), provider, servicesNode);
            this.addServiceNode("CertPathValidator", res.getString("DProviderInfo.Service.CertPathValidator.text"), provider, servicesNode);
            this.addServiceNode("CertStore", res.getString("DProviderInfo.Service.CertStore.text"), provider, servicesNode);
            this.addServiceNode("Cipher", res.getString("DProviderInfo.Service.Cipher.text"), provider, servicesNode);
            this.addServiceNode("Configuration", res.getString("DProviderInfo.Service.Configuration.text"), provider, servicesNode);
            this.addServiceNode("GssApiMechanism", res.getString("DProviderInfo.Service.GssApiMechanism.text"), provider, servicesNode);
            this.addServiceNode("KeyAgreement", res.getString("DProviderInfo.Service.KeyAgreement.text"), provider, servicesNode);
            this.addServiceNode("KeyFactory", res.getString("DProviderInfo.Service.KeyFactory.text"), provider, servicesNode);
            this.addServiceNode("KeyGenerator", res.getString("DProviderInfo.Service.KeyGenerator.text"), provider, servicesNode);
            this.addServiceNode("KeyInfoFactory", res.getString("DProviderInfo.Service.KeyInfoFactory.text"), provider, servicesNode);
            this.addServiceNode("KeyManagerFactory", res.getString("DProviderInfo.Service.KeyManagerFactory.text"), provider, servicesNode);
            this.addServiceNode("KeyPairGenerator", res.getString("DProviderInfo.Service.KeyPairGenerator.text"), provider, servicesNode);
            this.addServiceNode("KeyStore", res.getString("DProviderInfo.Service.KeyStore.text"), provider, servicesNode);
            this.addServiceNode("Mac", res.getString("DProviderInfo.Service.Mac.text"), provider, servicesNode);
            this.addServiceNode("MessageDigest", res.getString("DProviderInfo.Service.MessageDigest.text"), provider, servicesNode);
            this.addServiceNode("Policy", res.getString("DProviderInfo.Service.Policy.text"), provider, servicesNode);
            this.addServiceNode("SecretKeyFactory", res.getString("DProviderInfo.Service.SecretKeyFactory.text"), provider, servicesNode);
            this.addServiceNode("SecureRandom", res.getString("DProviderInfo.Service.SecureRandom.text"), provider, servicesNode);
            this.addServiceNode("Signature", res.getString("DProviderInfo.Service.Signature.text"), provider, servicesNode);
            this.addServiceNode("SaslClientFactory", res.getString("DProviderInfo.Service.SaslClientFactory.text"), provider, servicesNode);
            this.addServiceNode("SaslServerFactory", res.getString("DProviderInfo.Service.SaslServerFactory.text"), provider, servicesNode);
            this.addServiceNode("SSLContext", res.getString("DProviderInfo.Service.SSLContext.text"), provider, servicesNode);
            this.addServiceNode("TerminalFactory", res.getString("DProviderInfo.Service.TerminalFactory.text"), provider, servicesNode);
            this.addServiceNode("TransformService", res.getString("DProviderInfo.Service.TransformService.text"), provider, servicesNode);
            this.addServiceNode("TrustManagerFactory", res.getString("DProviderInfo.Service.TrustManagerFactory.text"), provider, servicesNode);
            this.addServiceNode("XMLSignatureFactory", res.getString("DProviderInfo.Service.XMLSignatureFactory.text"), provider, servicesNode);
        }
        return topNode;
    }

    private void addServiceNode(String serviceType, String friendlyName, Provider provider, DefaultMutableTreeNode servicesNode) {
        DefaultMutableTreeNode serviceNode = new DefaultMutableTreeNode(friendlyName);
        String[] algorithms = this.getServiceAlgorithms(serviceType, provider);
        for (int algCnt = 0; algCnt < algorithms.length; ++algCnt) {
            String[] aliases;
            String algorithm = algorithms[algCnt];
            DefaultMutableTreeNode algorithmNode = new DefaultMutableTreeNode(algorithm);
            serviceNode.add(algorithmNode);
            String algClass = this.getAlgorithmClass(algorithm, serviceType, provider);
            DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(algClass);
            algorithmNode.add(classNode);
            String[] attributes = this.getAlgorithmAttributes(algorithm, serviceType, provider);
            if (attributes.length > 0) {
                DefaultMutableTreeNode attributesNode = new DefaultMutableTreeNode(res.getString("DProviderInfo.AttributesNode.text"));
                algorithmNode.add(attributesNode);
                for (int attrCnt = 0; attrCnt < attributes.length; ++attrCnt) {
                    DefaultMutableTreeNode attributeNode = new DefaultMutableTreeNode(attributes[attrCnt]);
                    attributesNode.add(attributeNode);
                }
            }
            if ((aliases = this.getAlgorithmAliases(algorithm, serviceType, provider)).length <= 0) continue;
            DefaultMutableTreeNode aliasesNode = new DefaultMutableTreeNode(res.getString("DProviderInfo.AliasesNode.text"));
            algorithmNode.add(aliasesNode);
            for (int aliasCnt = 0; aliasCnt < aliases.length; ++aliasCnt) {
                DefaultMutableTreeNode aliasNode = new DefaultMutableTreeNode(aliases[aliasCnt]);
                aliasesNode.add(aliasNode);
            }
        }
        if (serviceNode.getChildCount() > 0) {
            servicesNode.add(serviceNode);
        }
    }

    private String[] getServiceAlgorithms(String serviceType, Provider provider) {
        String match = serviceType + ".";
        ArrayList<String> algorithmList = new ArrayList<String>();
        Enumeration<?> names = provider.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (!key.startsWith(match) || key.indexOf(32) != -1) continue;
            String algorithm = key.substring(key.indexOf(46) + 1);
            algorithmList.add(algorithm);
        }
        Object[] algorithms = algorithmList.toArray(new String[algorithmList.size()]);
        Arrays.sort(algorithms);
        return algorithms;
    }

    private String getAlgorithmClass(String algorithm, String serviceType, Provider provider) {
        String match = serviceType + "." + algorithm;
        Enumeration<?> names = provider.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (!key.equals(match)) continue;
            return provider.getProperty(key);
        }
        return null;
    }

    private String[] getAlgorithmAttributes(String algorithm, String serviceType, Provider provider) {
        String matchAttr = serviceType + "." + algorithm + " ";
        TreeMap<String, String> attributeMap = new TreeMap<String, String>();
        Enumeration<?> names = provider.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (!key.startsWith(matchAttr)) continue;
            String attrName = key.substring(key.indexOf(32) + 1);
            String attributeDisplay = MessageFormat.format(res.getString("DProviderInfo.AttributeNode.text"), attrName, provider.getProperty(key));
            attributeMap.put(attrName, attributeDisplay);
        }
        ArrayList attributes = new ArrayList();
        for (String key : attributeMap.keySet()) {
            attributes.add(attributeMap.get(key));
        }
        return attributes.toArray(new String[attributes.size()]);
    }

    private String[] getAlgorithmAliases(String algorithm, String serviceType, Provider provider) {
        String matchAlias = "Alg.Alias." + serviceType + ".";
        ArrayList<String> aliasList = new ArrayList<String>();
        Enumeration<?> names = provider.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (!provider.getProperty(key).equals(algorithm) || !key.startsWith(matchAlias)) continue;
            String alias = key.substring(matchAlias.length());
            aliasList.add(alias);
        }
        Object[] aliases = aliasList.toArray(new String[aliasList.size()]);
        Arrays.sort(aliases);
        return aliases;
    }

    private void copyPressed() {
        String info = this.getNodeContents((TreeNode)this.jtrProviders.getModel().getRoot(), 0);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection copy = new StringSelection(info);
        clipboard.setContents(copy, copy);
    }

    private String getNodeContents(TreeNode node, int level) {
        int i;
        StringBuffer strBuff = new StringBuffer();
        for (i = 0; i < level; ++i) {
            strBuff.append('\t');
        }
        strBuff.append(node.toString());
        strBuff.append('\n');
        for (i = 0; i < node.getChildCount(); ++i) {
            strBuff.append(this.getNodeContents(node.getChildAt(i), level + 1));
        }
        return strBuff.toString();
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

