/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.generalname;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.kse.crypto.x509.GeneralNameUtil;

public class GeneralNamesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 4224864830348756671L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/generalname/resources");
    private String columnName = res.getString("GeneralNamesTableModel.GeneralNameColumn");
    private List<GeneralName> data = new ArrayList<GeneralName>();

    public void load(GeneralNames generalNames) {
        GeneralName[] generalNamesArray = generalNames.getNames();
        this.data = new ArrayList<GeneralName>(Arrays.asList(generalNamesArray));
        Collections.sort(this.data, new GeneralNameComparator());
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnName;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data.get(row);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return GeneralName.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void addRow(GeneralName generalName) {
        this.data.add(generalName);
        Collections.sort(this.data, new GeneralNameComparator());
        this.fireTableDataChanged();
    }

    public void removeRow(int row) {
        this.data.remove(row);
        this.fireTableDataChanged();
    }

    public List<GeneralName> getData() {
        return this.data;
    }

    static class GeneralNameComparator
    implements Comparator<GeneralName> {
        GeneralNameComparator() {
        }

        @Override
        public int compare(GeneralName name1, GeneralName name2) {
            return GeneralNameUtil.safeToString(name1, false).compareToIgnoreCase(GeneralNameUtil.safeToString(name2, false));
        }
    }
}

