/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.generalname;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.bouncycastle.asn1.x509.GeneralName;
import org.kse.crypto.x509.GeneralNameUtil;
import org.kse.gui.CursorUtil;
import org.kse.gui.crypto.generalname.DGeneralNameChooser;

public class JGeneralName
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/generalname/resources");
    private JTextField jtfGeneralName;
    private JButton jbEditGeneralName;
    private JButton jbClearGeneralName;
    private String title;
    private GeneralName generalName;

    public JGeneralName(String title) {
        this.title = title;
        this.initComponents();
    }

    private void initComponents() {
        this.jtfGeneralName = new JTextField(40);
        this.jtfGeneralName.setEditable(false);
        GridBagConstraints gbc_jtfGeneralName = new GridBagConstraints();
        gbc_jtfGeneralName.gridwidth = 1;
        gbc_jtfGeneralName.gridheight = 1;
        gbc_jtfGeneralName.gridx = 0;
        gbc_jtfGeneralName.gridy = 0;
        gbc_jtfGeneralName.insets = new Insets(0, 0, 0, 5);
        ImageIcon editIcon = new ImageIcon(this.getClass().getResource("images/edit_general_nm.png"));
        this.jbEditGeneralName = new JButton(editIcon);
        this.jbEditGeneralName.setToolTipText(res.getString("JGeneralName.jbEditGeneralName.tooltip"));
        this.jbEditGeneralName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JGeneralName.this);
                    JGeneralName.this.editGeneralName();
                }
                finally {
                    CursorUtil.setCursorFree(JGeneralName.this);
                }
            }
        });
        GridBagConstraints gbc_jbEditGeneralName = new GridBagConstraints();
        gbc_jbEditGeneralName.gridwidth = 1;
        gbc_jbEditGeneralName.gridheight = 1;
        gbc_jbEditGeneralName.gridx = 1;
        gbc_jbEditGeneralName.gridy = 0;
        gbc_jbEditGeneralName.insets = new Insets(0, 0, 0, 5);
        ImageIcon clearIcon = new ImageIcon(this.getClass().getResource("images/clear_general_nm.png"));
        this.jbClearGeneralName = new JButton(clearIcon);
        this.jbClearGeneralName.setToolTipText(res.getString("JGeneralName.jbClearGeneralName.tooltip"));
        this.jbClearGeneralName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JGeneralName.this);
                    JGeneralName.this.clearGeneralName();
                }
                finally {
                    CursorUtil.setCursorFree(JGeneralName.this);
                }
            }
        });
        GridBagConstraints gbc_jbClearGeneralName = new GridBagConstraints();
        gbc_jbClearGeneralName.gridwidth = 1;
        gbc_jbClearGeneralName.gridheight = 1;
        gbc_jbClearGeneralName.gridx = 2;
        gbc_jbClearGeneralName.gridy = 0;
        gbc_jbClearGeneralName.insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jtfGeneralName, gbc_jtfGeneralName);
        this.add((Component)this.jbEditGeneralName, gbc_jbEditGeneralName);
        this.add((Component)this.jbClearGeneralName, gbc_jbClearGeneralName);
        this.populate();
    }

    public GeneralName getGeneralName() {
        return this.generalName;
    }

    public void setGeneralName(GeneralName generalName) {
        this.generalName = generalName;
        this.populate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jbEditGeneralName.setEnabled(enabled);
        this.jbClearGeneralName.setEnabled(enabled);
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jtfGeneralName.setToolTipText(toolTipText);
    }

    private void populate() {
        if (this.generalName != null) {
            this.jtfGeneralName.setText(GeneralNameUtil.safeToString(this.generalName, false));
            this.jbClearGeneralName.setEnabled(true);
        } else {
            this.jtfGeneralName.setText("");
            this.jbClearGeneralName.setEnabled(false);
        }
        this.jtfGeneralName.setCaretPosition(0);
    }

    private void editGeneralName() {
        Container container = this.getTopLevelAncestor();
        DGeneralNameChooser dGeneralNameChooser = null;
        dGeneralNameChooser = container instanceof JDialog ? new DGeneralNameChooser((JDialog)container, this.title, this.generalName) : new DGeneralNameChooser((JFrame)container, this.title, this.generalName);
        dGeneralNameChooser.setLocationRelativeTo(container);
        dGeneralNameChooser.setVisible(true);
        GeneralName newGeneralName = dGeneralNameChooser.getGeneralName();
        if (newGeneralName == null) {
            return;
        }
        this.setGeneralName(newGeneralName);
    }

    private void clearGeneralName() {
        this.setGeneralName(null);
    }
}

