/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.policymapping;

import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.PolicyMappings;
import org.kse.crypto.x509.PolicyMapping;
import org.kse.utilities.oid.ObjectIdComparator;

public class PolicyMappingsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/policymapping/resources");
    private static ObjectIdComparator objectIdComparator = new ObjectIdComparator();
    private String[] columnNames = new String[2];
    private Object[][] data;

    public PolicyMappingsTableModel() {
        this.columnNames[0] = res.getString("PolicyMappingsTableModel.IssuerDomainPolicyColumn");
        this.columnNames[1] = res.getString("PolicyMappingsTableModel.SubjectDomainPolicyColumn");
        this.data = new Object[0][0];
    }

    public void load(PolicyMappings policyMappings) {
        int i;
        ASN1Sequence policyMappingsSeq = (ASN1Sequence)policyMappings.toASN1Primitive();
        ASN1Encodable[] asn1EncArray = policyMappingsSeq.toArray();
        PolicyMapping[] policyMappingsArray = new PolicyMapping[asn1EncArray.length];
        for (i = 0; i < asn1EncArray.length; ++i) {
            policyMappingsArray[i] = PolicyMapping.getInstance(asn1EncArray[i]);
        }
        Arrays.sort(policyMappingsArray, new IssuerDomainPolicyComparator());
        this.data = new Object[policyMappingsArray.length][2];
        i = 0;
        for (PolicyMapping policyMapping : policyMappingsArray) {
            this.data[i][0] = policyMapping;
            this.data[i][1] = policyMapping;
            ++i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return PolicyMappings.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    static class SubjectDomainPolicyComparator
    implements Comparator<PolicyMapping> {
        SubjectDomainPolicyComparator() {
        }

        @Override
        public int compare(PolicyMapping mapping1, PolicyMapping mapping2) {
            return objectIdComparator.compare(mapping1.getSubjectDomainPolicy(), mapping2.getSubjectDomainPolicy());
        }
    }

    static class IssuerDomainPolicyComparator
    implements Comparator<PolicyMapping> {
        IssuerDomainPolicyComparator() {
        }

        @Override
        public int compare(PolicyMapping mapping1, PolicyMapping mapping2) {
            return objectIdComparator.compare(mapping1.getIssuerDomainPolicy(), mapping2.getIssuerDomainPolicy());
        }
    }
}

