/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.kse.crypto.CryptoException;
import org.kse.crypto.KeyInfo;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.DViewAsn1Dump;
import org.kse.gui.dialogs.DViewAsymmetricKeyFields;
import org.kse.gui.dialogs.DViewPem;
import org.kse.gui.error.DError;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.asn1.Asn1Exception;

public class DViewPublicKey
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private JLabel jlAlgorithm;
    private JTextField jtfAlgorithm;
    private JLabel jlKeySize;
    private JTextField jtfKeySize;
    private JLabel jlFormat;
    private JTextField jtfFormat;
    private JLabel jlEncoded;
    private JTextArea jtaEncoded;
    private JScrollPane jspEncoded;
    private JButton jbPem;
    private JButton jbFields;
    private JButton jbAsn1;
    private JButton jbOK;
    private PublicKey publicKey;

    public DViewPublicKey(JFrame parent, String title, PublicKey publicKey) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.publicKey = publicKey;
        this.initComponents();
    }

    public DViewPublicKey(JDialog parent, String title, PublicKey publicKey) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.publicKey = publicKey;
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        this.jlAlgorithm = new JLabel(res.getString("DViewPublicKey.jlAlgorithm.text"));
        this.jtfAlgorithm = new JTextField();
        this.jtfAlgorithm.setEditable(false);
        this.jtfAlgorithm.setToolTipText(res.getString("DViewPublicKey.jtfAlgorithm.tooltip"));
        this.jlKeySize = new JLabel(res.getString("DViewPublicKey.jlKeySize.text"));
        this.jtfKeySize = new JTextField();
        this.jtfKeySize.setEditable(false);
        this.jtfKeySize.setToolTipText(res.getString("DViewPublicKey.jtfKeySize.tooltip"));
        this.jlFormat = new JLabel(res.getString("DViewPublicKey.jlFormat.text"));
        this.jtfFormat = new JTextField();
        this.jtfFormat.setEditable(false);
        this.jtfFormat.setToolTipText(res.getString("DViewPublicKey.jtfFormat.tooltip"));
        this.jlEncoded = new JLabel(res.getString("DViewPublicKey.jlEncoded.text"));
        this.jtaEncoded = new JTextArea();
        this.jtaEncoded.setFont(new Font("Monospaced", 0, LnfUtil.getDefaultFontSize()));
        this.jtaEncoded.setBackground(this.jtfFormat.getBackground());
        this.jtaEncoded.setEditable(false);
        this.jtaEncoded.setLineWrap(true);
        this.jtaEncoded.setToolTipText(res.getString("DViewPublicKey.jtfEncoded.tooltip"));
        this.jspEncoded = PlatformUtil.createScrollPane(this.jtaEncoded, 20, 31);
        this.jspEncoded.setBorder(this.jtfFormat.getBorder());
        this.jbPem = new JButton(res.getString("DViewPublicKey.jbPem.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbPem, res.getString("DViewPublicKey.jbPem.mnemonic").charAt(0));
        this.jbPem.setToolTipText(res.getString("DViewPublicKey.jbPem.tooltip"));
        this.jbFields = new JButton(res.getString("DViewPublicKey.jbFields.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbFields, res.getString("DViewPublicKey.jbFields.mnemonic").charAt(0));
        this.jbFields.setToolTipText(res.getString("DViewPublicKey.jbFields.tooltip"));
        this.jbAsn1 = new JButton(res.getString("DViewPublicKey.jbAsn1.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbAsn1, res.getString("DViewPublicKey.jbAsn1.mnemonic").charAt(0));
        this.jbAsn1.setToolTipText(res.getString("DViewPublicKey.jbAsn1.tooltip"));
        this.jbOK = new JButton(res.getString("DViewPublicKey.jbOK.text"));
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "[right]unrel[]", "[]unrel[]"));
        pane.add((Component)this.jlAlgorithm, "");
        pane.add((Component)this.jtfAlgorithm, "growx, pushx, wrap");
        pane.add((Component)this.jlKeySize, "");
        pane.add((Component)this.jtfKeySize, "growx, pushx, wrap");
        pane.add((Component)this.jlFormat, "");
        pane.add((Component)this.jtfFormat, "growx, pushx, wrap");
        pane.add((Component)this.jlEncoded, "");
        pane.add((Component)this.jspEncoded, "width 400lp:400lp:400lp, height 150lp:150lp:150lp, wrap");
        pane.add((Component)this.jbPem, "spanx, split");
        pane.add((Component)this.jbFields, "");
        pane.add((Component)this.jbAsn1, "wrap");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap");
        pane.add((Component)this.jbOK, "spanx, tag ok");
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewPublicKey.this.okPressed();
            }
        });
        this.jbPem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewPublicKey.this);
                    DViewPublicKey.this.pemEncodingPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewPublicKey.this);
                }
            }
        });
        this.jbFields.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewPublicKey.this);
                    DViewPublicKey.this.fieldsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewPublicKey.this);
                }
            }
        });
        this.jbAsn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewPublicKey.this);
                    DViewPublicKey.this.asn1DumpPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewPublicKey.this);
                }
            }
        });
        this.setResizable(false);
        this.populateDialog();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewPublicKey.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewPublicKey.this.jbOK.requestFocus();
            }
        });
    }

    private void populateDialog() throws CryptoException {
        KeyInfo keyInfo = KeyPairUtil.getKeyInfo(this.publicKey);
        this.jtfAlgorithm.setText(keyInfo.getAlgorithm());
        Integer keyLength = keyInfo.getSize();
        if (keyLength != null) {
            this.jtfKeySize.setText(MessageFormat.format(res.getString("DViewPublicKey.jtfKeySize.text"), "" + keyLength));
        } else {
            this.jtfKeySize.setText(MessageFormat.format(res.getString("DViewPublicKey.jtfKeySize.text"), "?"));
        }
        this.jtfFormat.setText(this.publicKey.getFormat());
        this.jtaEncoded.setText(new BigInteger(1, this.publicKey.getEncoded()).toString(16).toUpperCase());
        this.jtaEncoded.setCaretPosition(0);
        if (this.publicKey instanceof RSAPublicKey || this.publicKey instanceof DSAPublicKey) {
            this.jbFields.setEnabled(true);
        } else {
            this.jbFields.setEnabled(false);
        }
    }

    private void pemEncodingPressed() {
        try {
            DViewPem dViewCsrPem = new DViewPem((JDialog)this, res.getString("DViewPublicKey.Pem.Title"), this.publicKey);
            dViewCsrPem.setLocationRelativeTo(this);
            dViewCsrPem.setVisible(true);
        }
        catch (CryptoException e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void fieldsPressed() {
        if (this.publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPub = (RSAPublicKey)this.publicKey;
            DViewAsymmetricKeyFields dViewAsymmetricKeyFields = new DViewAsymmetricKeyFields((JDialog)this, res.getString("DViewPublicKey.RsaFields.Title"), rsaPub);
            dViewAsymmetricKeyFields.setLocationRelativeTo(this);
            dViewAsymmetricKeyFields.setVisible(true);
        } else if (this.publicKey instanceof DSAPublicKey) {
            DSAPublicKey dsaPub = (DSAPublicKey)this.publicKey;
            DViewAsymmetricKeyFields dViewAsymmetricKeyFields = new DViewAsymmetricKeyFields((JDialog)this, res.getString("DViewPublicKey.DsaFields.Title"), dsaPub);
            dViewAsymmetricKeyFields.setLocationRelativeTo(this);
            dViewAsymmetricKeyFields.setVisible(true);
        }
    }

    private void asn1DumpPressed() {
        try {
            DViewAsn1Dump dViewAsn1Dump = new DViewAsn1Dump((JDialog)this, this.publicKey);
            dViewAsn1Dump.setLocationRelativeTo(this);
            dViewAsn1Dump.setVisible(true);
        }
        catch (IOException | Asn1Exception e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        KeyPair keyPair = keyGen.genKeyPair();
        DViewPublicKey dialog = new DViewPublicKey(new JFrame(), "Title", keyPair.getPublic());
        DialogViewer.run(dialog);
    }
}

