/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.crypto.x509.X509ExtensionType;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;

public class DAddExtensionType
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private static final X509ExtensionType[] SUPPORTED_EXTENSIONS = new X509ExtensionType[]{X509ExtensionType.AUTHORITY_INFORMATION_ACCESS, X509ExtensionType.AUTHORITY_KEY_IDENTIFIER, X509ExtensionType.BASIC_CONSTRAINTS, X509ExtensionType.CERTIFICATE_POLICIES, X509ExtensionType.EXTENDED_KEY_USAGE, X509ExtensionType.INHIBIT_ANY_POLICY, X509ExtensionType.ISSUER_ALTERNATIVE_NAME, X509ExtensionType.KEY_USAGE, X509ExtensionType.NAME_CONSTRAINTS, X509ExtensionType.NETSCAPE_BASE_URL, X509ExtensionType.NETSCAPE_CA_POLICY_URL, X509ExtensionType.NETSCAPE_CA_REVOCATION_URL, X509ExtensionType.NETSCAPE_CERTIFICATE_RENEWAL_URL, X509ExtensionType.NETSCAPE_CERTIFICATE_TYPE, X509ExtensionType.NETSCAPE_COMMENT, X509ExtensionType.NETSCAPE_REVOCATION_URL, X509ExtensionType.NETSCAPE_SSL_SERVER_NAME, X509ExtensionType.POLICY_CONSTRAINTS, X509ExtensionType.POLICY_MAPPINGS, X509ExtensionType.PRIVATE_KEY_USAGE_PERIOD, X509ExtensionType.SUBJECT_ALTERNATIVE_NAME, X509ExtensionType.SUBJECT_INFORMATION_ACCESS, X509ExtensionType.SUBJECT_KEY_IDENTIFIER};
    private JPanel jpExtensionTypes;
    private JLabel jlExtensionTypes;
    private JList<X509ExtensionType> jltExtensionTypes;
    private JScrollPane jspExtensionTypes;
    private JCheckBox jcbCriticalExtension;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private X509Extension extensions;
    private X509ExtensionType extension;
    private boolean isCritical;

    public DAddExtensionType(JDialog parent, X509Extension extensions) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(res.getString("DAddExtensionType.Title"));
        this.extensions = extensions;
        this.initComponents();
    }

    private void initComponents() {
        this.jpExtensionTypes = new JPanel(new BorderLayout(5, 5));
        this.jpExtensionTypes.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jlExtensionTypes = new JLabel(res.getString("DAddExtensionType.jlExtensionTypes.text"));
        this.jltExtensionTypes = new JList();
        this.jltExtensionTypes.setPrototypeCellValue(X509ExtensionType.NETSCAPE_CERTIFICATE_RENEWAL_URL);
        this.jltExtensionTypes.setToolTipText(res.getString("DAddExtensionType.jltExtensionTypes.tooltip"));
        this.jltExtensionTypes.setSelectionMode(0);
        this.jltExtensionTypes.setBorder(new EtchedBorder());
        this.jltExtensionTypes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DAddExtensionType.this.maybeAddExtension(evt);
            }
        });
        this.jspExtensionTypes = new JScrollPane(this.jltExtensionTypes);
        this.jcbCriticalExtension = new JCheckBox(res.getString("DAddExtensionType.jcbCriticalExtension.text"));
        this.jcbCriticalExtension.setMnemonic(res.getString("DAddExtensionType.jcbCriticalExtension.mnemonic").charAt(0));
        this.jcbCriticalExtension.setToolTipText(res.getString("DAddExtensionType.jcbCriticalExtension.tooltip"));
        this.jpExtensionTypes.add((Component)this.jlExtensionTypes, "North");
        this.jpExtensionTypes.add((Component)this.jspExtensionTypes, "Center");
        this.jpExtensionTypes.add((Component)this.jcbCriticalExtension, "South");
        this.jbOK = new JButton(res.getString("DAddExtensionType.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAddExtensionType.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DAddExtensionType.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAddExtensionType.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DAddExtensionType.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.populateExtensionTypes();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpExtensionTypes, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DAddExtensionType.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void populateExtensionTypes() {
        ArrayList<X509ExtensionType> availableExtensions = new ArrayList<X509ExtensionType>();
        for (X509ExtensionType extentionType : SUPPORTED_EXTENSIONS) {
            if (this.extensions.getExtensionValue(extentionType.oid()) != null) continue;
            availableExtensions.add(extentionType);
        }
        this.jltExtensionTypes.setListData((X509ExtensionType[])availableExtensions.toArray(new X509ExtensionType[availableExtensions.size()]));
        if (!availableExtensions.isEmpty()) {
            this.jltExtensionTypes.setSelectedIndex(0);
        }
    }

    public X509ExtensionType getExtensionType() {
        return this.extension;
    }

    public boolean isExtensionCritical() {
        return this.isCritical;
    }

    private void okPressed() {
        if (this.jltExtensionTypes.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(this, res.getString("DAddExtensionType.ExtensionSelectionReq.message"), this.getTitle(), 2);
            return;
        }
        this.extension = this.jltExtensionTypes.getSelectedValue();
        this.isCritical = this.jcbCriticalExtension.isSelected();
        this.closeDialog();
    }

    private void maybeAddExtension(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            int index = this.jltExtensionTypes.locationToIndex(evt.getPoint());
            this.extension = this.jltExtensionTypes.getModel().getElementAt(index);
            this.isCritical = this.jcbCriticalExtension.isSelected();
            this.closeDialog();
        }
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

