/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kse.crypto.CryptoException;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.crypto.x509.X509Ext;
import org.kse.crypto.x509.X509ExtensionSet;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.JKseTable;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.DViewAsn1Dump;
import org.kse.gui.dialogs.DViewCertificate;
import org.kse.gui.dialogs.DViewCrl;
import org.kse.gui.dialogs.extensions.DAddExtensions;
import org.kse.gui.dialogs.extensions.ExtensionsTableCellRend;
import org.kse.gui.dialogs.extensions.ExtensionsTableHeadRend;
import org.kse.gui.dialogs.extensions.ExtensionsTableModel;
import org.kse.gui.error.DError;
import org.kse.utilities.asn1.Asn1Exception;
import org.kse.utilities.oid.ObjectIdComparator;

public class DViewExtensions
extends JEscDialog
implements HyperlinkListener {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private JPanel jpExtensions;
    private JPanel jpExtensionsTable;
    private JScrollPane jspExtensionsTable;
    private JKseTable jtExtensions;
    private JPanel jpExtensionValue;
    private JLabel jlExtensionValue;
    private JPanel jpExtensionValueTextArea;
    private JScrollPane jspExtensionValue;
    private JEditorPane jepExtensionValue;
    private JPanel jpExtensionActionPanel;
    private JButton jbAsn1;
    private JPanel jpOK;
    private JButton jbOK;
    private X509Extension extensions;

    public DViewExtensions(JFrame parent, String title, X509Extension extensions) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.extensions = extensions;
        this.initComponents();
    }

    public DViewExtensions(JDialog parent, String title, X509Extension extensions) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.extensions = extensions;
        this.initComponents();
    }

    private void initComponents() {
        ExtensionsTableModel extensionsTableModel = new ExtensionsTableModel();
        this.jtExtensions = new JKseTable(extensionsTableModel);
        TableRowSorter<ExtensionsTableModel> sorter = new TableRowSorter<ExtensionsTableModel>(extensionsTableModel);
        sorter.setComparator(2, new ObjectIdComparator());
        this.jtExtensions.setRowSorter(sorter);
        this.jtExtensions.setShowGrid(false);
        this.jtExtensions.setRowMargin(0);
        this.jtExtensions.getColumnModel().setColumnMargin(0);
        this.jtExtensions.getTableHeader().setReorderingAllowed(false);
        this.jtExtensions.setAutoResizeMode(4);
        this.jtExtensions.setRowHeight(Math.max(18, this.jtExtensions.getRowHeight()));
        for (int i = 0; i < this.jtExtensions.getColumnCount(); ++i) {
            TableColumn column = this.jtExtensions.getColumnModel().getColumn(i);
            column.setHeaderRenderer(new ExtensionsTableHeadRend(this.jtExtensions.getTableHeader().getDefaultRenderer()));
            column.setCellRenderer(new ExtensionsTableCellRend());
        }
        TableColumn criticalCol = this.jtExtensions.getColumnModel().getColumn(0);
        criticalCol.setResizable(false);
        criticalCol.setMinWidth(28);
        criticalCol.setMaxWidth(28);
        criticalCol.setPreferredWidth(28);
        ListSelectionModel selectionModel = this.jtExtensions.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    try {
                        CursorUtil.setCursorBusy(DViewExtensions.this);
                        DViewExtensions.this.updateExtensionValue();
                    }
                    finally {
                        CursorUtil.setCursorFree(DViewExtensions.this);
                    }
                }
            }
        });
        this.jspExtensionsTable = PlatformUtil.createScrollPane(this.jtExtensions, 20, 31);
        this.jspExtensionsTable.getViewport().setBackground(this.jtExtensions.getBackground());
        this.jpExtensionsTable = new JPanel(new BorderLayout(5, 5));
        this.jpExtensionsTable.setPreferredSize(new Dimension(500, 200));
        this.jpExtensionsTable.add((Component)this.jspExtensionsTable, "Center");
        this.jpExtensionValue = new JPanel(new BorderLayout(5, 5));
        this.jlExtensionValue = new JLabel(res.getString("DViewExtensions.jlExtensionValue.text"));
        this.jpExtensionValue.add((Component)this.jlExtensionValue, "North");
        this.jepExtensionValue = new JEditorPane();
        this.jepExtensionValue.setFont(new Font("Monospaced", 0, LnfUtil.getDefaultFontSize()));
        this.jepExtensionValue.setEditable(false);
        this.jepExtensionValue.setToolTipText(res.getString("DViewExtensions.jtaExtensionValue.tooltip"));
        this.jepExtensionValue.putClientProperty("JTextArea.infoBackground", Boolean.TRUE);
        this.jepExtensionValue.setContentType("text/html");
        this.jepExtensionValue.addHyperlinkListener(this);
        this.jepExtensionValue.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.jspExtensionValue = PlatformUtil.createScrollPane(this.jepExtensionValue, 20, 30);
        this.jpExtensionValueTextArea = new JPanel(new BorderLayout(5, 5));
        this.jpExtensionValueTextArea.setPreferredSize(new Dimension(500, 200));
        this.jpExtensionValueTextArea.add((Component)this.jspExtensionValue, "Center");
        this.jpExtensionValue.add((Component)this.jpExtensionValueTextArea, "Center");
        this.jbAsn1 = new JButton(res.getString("DViewExtensions.jbAsn1.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbAsn1, res.getString("DViewExtensions.jbAsn1.mnemonic").charAt(0));
        this.jbAsn1.setToolTipText(res.getString("DViewExtensions.jbAsn1.tooltip"));
        this.jbAsn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewExtensions.this);
                    DViewExtensions.this.asn1DumpPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewExtensions.this);
                }
            }
        });
        JButton jbSaveTemplate = new JButton(res.getString("DAddExtensions.jbSaveTemplate.text"));
        jbSaveTemplate.setMnemonic(res.getString("DAddExtensions.jbSaveTemplate.mnemonic").charAt(0));
        jbSaveTemplate.setToolTipText(res.getString("DAddExtensions.jbSaveTemplate.tooltip"));
        jbSaveTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewExtensions.this);
                    DAddExtensions.saveTemplatePressed(new X509ExtensionSet(DViewExtensions.this.extensions), DViewExtensions.this);
                }
                finally {
                    CursorUtil.setCursorFree(DViewExtensions.this);
                }
            }
        });
        this.jpExtensionActionPanel = new JPanel(new FlowLayout(2));
        this.jpExtensionActionPanel.add(jbSaveTemplate);
        this.jpExtensionActionPanel.add(this.jbAsn1);
        this.jpExtensionValue.add((Component)this.jpExtensionActionPanel, "South");
        this.jpExtensions = new JPanel(new GridLayout(2, 1, 5, 5));
        this.jpExtensions.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpExtensions.add(this.jpExtensionsTable);
        this.jpExtensions.add(this.jpExtensionValue);
        this.jbOK = new JButton(res.getString("DViewExtensions.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewExtensions.this.okPressed();
            }
        });
        this.jpOK = PlatformUtil.createDialogButtonPanel(this.jbOK);
        extensionsTableModel.load(this.extensions);
        if (extensionsTableModel.getRowCount() > 0) {
            this.jtExtensions.changeSelection(0, 0, false, false);
        }
        this.getContentPane().add((Component)this.jpExtensions, "Center");
        this.getContentPane().add((Component)this.jpOK, "South");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewExtensions.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewExtensions.this.jbOK.requestFocus();
            }
        });
    }

    private void updateExtensionValue() {
        int selectedRow = this.jtExtensions.getSelectedRow();
        if (selectedRow == -1) {
            this.jepExtensionValue.setText("");
            this.jbAsn1.setEnabled(false);
        } else {
            String oid = ((ASN1ObjectIdentifier)this.jtExtensions.getValueAt(selectedRow, 2)).getId();
            byte[] value = this.extensions.getExtensionValue(oid);
            boolean criticality = (Boolean)this.jtExtensions.getValueAt(selectedRow, 0);
            X509Ext ext = new X509Ext(oid, value, criticality);
            try {
                this.jepExtensionValue.setText("<html><body>" + ext.getStringValue().replace(X509Ext.INDENT.getIndentChar().toString(), "&nbsp;").replace("\n", "<br/>") + "</body></html>");
            }
            catch (Exception e) {
                this.jepExtensionValue.setText("");
                DError.displayError(this, (Throwable)e);
            }
            this.jepExtensionValue.setCaretPosition(0);
            this.jbAsn1.setEnabled(true);
        }
    }

    private void asn1DumpPressed() {
        int selectedRow = this.jtExtensions.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        String oid = ((ASN1ObjectIdentifier)this.jtExtensions.getValueAt(selectedRow, 2)).getId();
        byte[] value = this.extensions.getExtensionValue(oid);
        boolean criticality = (Boolean)this.jtExtensions.getValueAt(selectedRow, 0);
        X509Ext extension = new X509Ext(oid, value, criticality);
        try {
            DViewAsn1Dump dViewAsn1Dump = new DViewAsn1Dump((JDialog)this, extension);
            dViewAsn1Dump.setLocationRelativeTo(this);
            dViewAsn1Dump.setVisible(true);
        }
        catch (IOException | Asn1Exception e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                URL url = e.getURL();
                if (url != null) {
                    if (url.getPath().endsWith(".cer") || url.getPath().endsWith(".crt")) {
                        this.downloadCert(url);
                    } else if (url.getPath().endsWith(".crl")) {
                        this.downloadCrl(url);
                    } else {
                        Desktop.getDesktop().browse(url.toURI());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void downloadCrl(URL url) throws IOException, CryptoException {
        URLConnection urlConn = url.openConnection();
        try (InputStream is = urlConn.getInputStream();){
            X509CRL crl = X509CertUtil.loadCRL(IOUtils.toByteArray((InputStream)is));
            if (crl != null) {
                DViewCrl dViewCrl = new DViewCrl(this, MessageFormat.format(res.getString("DViewExtensions.ViewCrl.Title"), url.toString()), Dialog.ModalityType.DOCUMENT_MODAL, crl);
                dViewCrl.setLocationRelativeTo(this);
                dViewCrl.setVisible(true);
            }
        }
    }

    private void downloadCert(URL url) throws IOException, CryptoException {
        URLConnection urlConn = url.openConnection();
        try (InputStream is = urlConn.getInputStream();){
            X509Certificate[] certs = X509CertUtil.loadCertificates(IOUtils.toByteArray((InputStream)is));
            if (certs != null && certs.length > 0) {
                DViewCertificate dViewCertificate = new DViewCertificate(this, MessageFormat.format(res.getString("DViewExtensions.ViewCert.Title"), url.toString()), certs, null, DViewCertificate.NONE);
                dViewCertificate.setLocationRelativeTo(this);
                dViewCertificate.setVisible(true);
            }
        }
    }
}

