/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.importexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JavaFXFileChooser;
import org.kse.gui.PlatformUtil;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.io.FileNameUtil;

public class DExportCertificates
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/importexport/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpOptions;
    private JLabel jlExportLength;
    private JRadioButton jrbExportHead;
    private JRadioButton jrbExportChain;
    private JLabel jlExportFormat;
    private JRadioButton jrbExportX509;
    private JRadioButton jrbExportPkcs7;
    private JRadioButton jrbExportPkiPath;
    private JRadioButton jrbExportSpc;
    private JLabel jlExportPem;
    private JCheckBox jcbExportPem;
    private JLabel jlExportFile;
    private JTextField jtfExportFile;
    private JButton jbBrowse;
    private JPanel jpButtons;
    private JButton jbExport;
    private JButton jbCancel;
    private String entryAlias;
    private boolean chain;
    private boolean exportSelected = false;
    private File exportFile;
    private boolean exportChain;
    private boolean formatX509;
    private boolean formatPkcs7;
    private boolean formatPkiPath;
    private boolean formatSpc;
    private boolean pemEncode;

    public DExportCertificates(JFrame parent, String entryAlias, boolean chain) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.entryAlias = entryAlias;
        this.chain = chain;
        this.initComponents();
    }

    private void initComponents() {
        GridBagConstraints gbcLbl = new GridBagConstraints();
        gbcLbl.gridx = 0;
        gbcLbl.gridwidth = 3;
        gbcLbl.gridheight = 1;
        gbcLbl.insets = new Insets(5, 5, 5, 5);
        gbcLbl.anchor = 13;
        GridBagConstraints gbcEdCtrl = new GridBagConstraints();
        gbcEdCtrl.gridx = 3;
        gbcEdCtrl.gridwidth = 3;
        gbcEdCtrl.gridheight = 1;
        gbcEdCtrl.insets = new Insets(5, 5, 5, 5);
        gbcEdCtrl.anchor = 17;
        this.jlExportLength = new JLabel(res.getString("DExportCertificates.jlExportLength.text"));
        GridBagConstraints gbc_jlExportLength = (GridBagConstraints)gbcLbl.clone();
        gbc_jlExportLength.gridy = 0;
        this.jrbExportHead = new JRadioButton(res.getString("DExportCertificates.jrbExportHead.text"));
        this.jrbExportHead.setToolTipText(res.getString("DExportCertificates.jrbExportHead.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbExportHead, res.getString("DExportCertificates.jrbExportHead.mnemonic").charAt(0));
        GridBagConstraints gbc_jrbExportHead = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jrbExportHead.gridy = 0;
        this.jrbExportChain = new JRadioButton(res.getString("DExportCertificates.jrbExportChain.text"));
        this.jrbExportChain.setToolTipText(res.getString("DExportCertificates.jrbExportChain.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbExportChain, res.getString("DExportCertificates.jrbExportChain.mnemonic").charAt(0));
        GridBagConstraints gbc_jrbExportChain = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jrbExportChain.gridy = 0;
        gbc_jrbExportChain.gridx = 6;
        ButtonGroup bgExportLength = new ButtonGroup();
        bgExportLength.add(this.jrbExportHead);
        bgExportLength.add(this.jrbExportChain);
        this.jrbExportHead.setSelected(true);
        this.jlExportFormat = new JLabel(res.getString("DExportCertificates.jlExportFormat.text"));
        GridBagConstraints gbc_jlExportFormat = (GridBagConstraints)gbcLbl.clone();
        gbc_jlExportFormat.gridy = 1;
        this.jrbExportX509 = new JRadioButton(res.getString("DExportCertificates.jrbExportX509.text"));
        this.jrbExportX509.setToolTipText(res.getString("DExportCertificates.jrbExportX509.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbExportX509, res.getString("DExportCertificates.jrbExportX509.mnemonic").charAt(0));
        GridBagConstraints gbc_jrbExportX509 = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jrbExportX509.gridy = 1;
        this.jrbExportPkcs7 = new JRadioButton(res.getString("DExportCertificates.jrbExportPkcs7.text"));
        this.jrbExportPkcs7.setToolTipText(res.getString("DExportCertificates.jrbExportPkcs7.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbExportPkcs7, res.getString("DExportCertificates.jrbExportPkcs7.mnemonic").charAt(0));
        GridBagConstraints gbc_jrbExportPkcs7 = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jrbExportPkcs7.gridy = 1;
        gbc_jrbExportPkcs7.gridx = 6;
        this.jrbExportPkiPath = new JRadioButton(res.getString("DExportCertificates.jrbExportPkiPath.text"));
        this.jrbExportPkiPath.setToolTipText(res.getString("DExportCertificates.jrbExportPkiPath.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbExportPkiPath, res.getString("DExportCertificates.jrbExportPkiPath.mnemonic").charAt(0));
        GridBagConstraints gbc_jrbExportPkiPath = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jrbExportPkiPath.gridy = 1;
        gbc_jrbExportPkiPath.gridx = 9;
        this.jrbExportSpc = new JRadioButton(res.getString("DExportCertificates.jrbExportSpc.text"));
        this.jrbExportSpc.setToolTipText(res.getString("DExportCertificates.jrbExportSpc.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jrbExportSpc, res.getString("DExportCertificates.jrbExportSpc.mnemonic").charAt(0));
        GridBagConstraints gbc_jrbExportSpc = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jrbExportSpc.gridy = 1;
        gbc_jrbExportSpc.gridx = 12;
        ButtonGroup bgExportFormat = new ButtonGroup();
        bgExportFormat.add(this.jrbExportX509);
        bgExportFormat.add(this.jrbExportPkcs7);
        bgExportFormat.add(this.jrbExportPkiPath);
        bgExportFormat.add(this.jrbExportSpc);
        this.jrbExportX509.setSelected(true);
        this.jlExportPem = new JLabel(res.getString("DExportCertificates.jlExportPem.text"));
        GridBagConstraints gbc_jlExportPem = (GridBagConstraints)gbcLbl.clone();
        gbc_jlExportPem.gridy = 2;
        this.jcbExportPem = new JCheckBox();
        this.jcbExportPem.setSelected(true);
        this.jcbExportPem.setToolTipText(res.getString("DExportCertificates.jcbExportPem.tooltip"));
        GridBagConstraints gbc_jcbExportPem = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jcbExportPem.gridy = 2;
        this.jlExportFile = new JLabel(res.getString("DExportCertificates.jlExportFile.text"));
        GridBagConstraints gbc_jlExportFile = (GridBagConstraints)gbcLbl.clone();
        gbc_jlExportFile.gridy = 3;
        this.jtfExportFile = new JTextField(30);
        this.jtfExportFile.setToolTipText(res.getString("DExportCertificates.jtfExportFile.tooltip"));
        GridBagConstraints gbc_jtfExportFile = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jtfExportFile.gridy = 3;
        gbc_jtfExportFile.gridwidth = 12;
        gbc_jtfExportFile.fill = 2;
        this.jbBrowse = new JButton(res.getString("DExportCertificates.jbBrowse.text"));
        this.jbBrowse.setToolTipText(res.getString("DExportCertificates.jbBrowse.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbBrowse, res.getString("DExportCertificates.jbBrowse.mnemonic").charAt(0));
        GridBagConstraints gbc_jbBrowse = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jbBrowse.gridy = 3;
        gbc_jbBrowse.gridx = 15;
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExportCertificates.this);
                    DExportCertificates.this.browsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExportCertificates.this);
                }
            }
        });
        this.jpOptions = new JPanel(new GridBagLayout());
        this.jpOptions.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()), new EmptyBorder(5, 5, 5, 5)));
        if (this.chain) {
            this.jpOptions.add((Component)this.jlExportLength, gbc_jlExportLength);
            this.jpOptions.add((Component)this.jrbExportHead, gbc_jrbExportHead);
            this.jpOptions.add((Component)this.jrbExportChain, gbc_jrbExportChain);
        } else {
            --gbc_jlExportFormat.gridy;
            --gbc_jrbExportX509.gridy;
            --gbc_jrbExportPkcs7.gridy;
            --gbc_jrbExportPkiPath.gridy;
            --gbc_jrbExportSpc.gridy;
            --gbc_jlExportPem.gridy;
            --gbc_jcbExportPem.gridy;
            --gbc_jlExportFile.gridy;
            --gbc_jtfExportFile.gridy;
            --gbc_jbBrowse.gridy;
        }
        this.jpOptions.add((Component)this.jlExportFormat, gbc_jlExportFormat);
        this.jpOptions.add((Component)this.jrbExportX509, gbc_jrbExportX509);
        this.jpOptions.add((Component)this.jrbExportPkcs7, gbc_jrbExportPkcs7);
        this.jpOptions.add((Component)this.jrbExportPkiPath, gbc_jrbExportPkiPath);
        this.jpOptions.add((Component)this.jrbExportSpc, gbc_jrbExportSpc);
        this.jpOptions.add((Component)this.jlExportPem, gbc_jlExportPem);
        this.jpOptions.add((Component)this.jcbExportPem, gbc_jcbExportPem);
        this.jpOptions.add((Component)this.jlExportFile, gbc_jlExportFile);
        this.jpOptions.add((Component)this.jtfExportFile, gbc_jtfExportFile);
        this.jpOptions.add((Component)this.jbBrowse, gbc_jbBrowse);
        this.jrbExportChain.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (DExportCertificates.this.jrbExportChain.isSelected() && DExportCertificates.this.jrbExportX509.isSelected()) {
                    DExportCertificates.this.jcbExportPem.setEnabled(false);
                    DExportCertificates.this.jcbExportPem.setSelected(true);
                } else {
                    DExportCertificates.this.jcbExportPem.setEnabled(true);
                }
            }
        });
        this.jrbExportX509.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (DExportCertificates.this.jrbExportX509.isSelected()) {
                    DExportCertificates.this.updateFileExtension("cer");
                    if (DExportCertificates.this.jrbExportChain.isSelected()) {
                        DExportCertificates.this.jcbExportPem.setEnabled(false);
                        DExportCertificates.this.jcbExportPem.setSelected(true);
                    } else {
                        DExportCertificates.this.jcbExportPem.setEnabled(true);
                    }
                }
            }
        });
        this.jrbExportPkcs7.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (DExportCertificates.this.jrbExportPkcs7.isSelected()) {
                    DExportCertificates.this.jcbExportPem.setEnabled(true);
                    DExportCertificates.this.updateFileExtension("p7b");
                }
            }
        });
        this.jrbExportSpc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (DExportCertificates.this.jrbExportSpc.isSelected()) {
                    DExportCertificates.this.jcbExportPem.setEnabled(false);
                    DExportCertificates.this.jcbExportPem.setSelected(false);
                    DExportCertificates.this.updateFileExtension("spc");
                } else {
                    DExportCertificates.this.jcbExportPem.setEnabled(true);
                }
            }
        });
        this.jrbExportPkiPath.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (DExportCertificates.this.jrbExportPkiPath.isSelected()) {
                    DExportCertificates.this.jcbExportPem.setEnabled(false);
                    DExportCertificates.this.jcbExportPem.setSelected(false);
                    DExportCertificates.this.updateFileExtension("pkipath");
                } else {
                    DExportCertificates.this.jcbExportPem.setEnabled(true);
                }
            }
        });
        this.jbExport = new JButton(res.getString("DExportCertificates.jbExport.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbExport, res.getString("DExportCertificates.jbExport.mnemonic").charAt(0));
        this.jbExport.setToolTipText(res.getString("DExportCertificates.jbExport.tooltip"));
        this.jbExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExportCertificates.this);
                    DExportCertificates.this.exportPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExportCertificates.this);
                }
            }
        });
        this.jbCancel = new JButton(res.getString("DExportCertificates.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExportCertificates.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExportCertificates.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbExport, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpOptions, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DExportCertificates.this.closeDialog();
            }
        });
        if (this.chain) {
            this.setTitle(MessageFormat.format(res.getString("DExportCertificates.CertificateChain.Title"), this.entryAlias));
        } else {
            this.setTitle(MessageFormat.format(res.getString("DExportCertificates.Certificate.Title"), this.entryAlias));
        }
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbExport);
        this.populateExportFileName();
        this.pack();
    }

    private void updateFileExtension(String newExt) {
        String currentFileName = this.jtfExportFile.getText();
        String newFileName = FileNameUtil.removeExtension(currentFileName) + "." + newExt;
        this.jtfExportFile.setText(newFileName);
    }

    private void populateExportFileName() {
        File currentDirectory = CurrentDirectory.get();
        String sanitizedAlias = FileNameUtil.cleanFileName(this.entryAlias);
        File csrFile = new File(currentDirectory, sanitizedAlias + "." + "cer");
        this.jtfExportFile.setText(csrFile.getPath());
    }

    public boolean exportSelected() {
        return this.exportSelected;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public boolean exportHead() {
        return !this.exportChain;
    }

    public boolean exportChain() {
        return this.exportChain;
    }

    public boolean exportFormatX509() {
        return this.formatX509;
    }

    public boolean exportFormatPkcs7() {
        return this.formatPkcs7;
    }

    public boolean exportFormatPkiPath() {
        return this.formatPkiPath;
    }

    public boolean exportFormatSpc() {
        return this.formatSpc;
    }

    public boolean pemEncode() {
        return this.pemEncode;
    }

    private void browsePressed() {
        int rtnValue;
        JFileChooser chooser = null;
        chooser = this.jrbExportX509.isSelected() ? FileChooserFactory.getX509FileChooser() : (this.jrbExportPkcs7.isSelected() ? FileChooserFactory.getPkcs7FileChooser() : (this.jrbExportPkiPath.isSelected() ? FileChooserFactory.getPkiPathFileChooser() : FileChooserFactory.getSpcFileChooser()));
        File currentExportFile = new File(this.jtfExportFile.getText().trim());
        if (currentExportFile.getParentFile() != null && currentExportFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentExportFile.getParentFile());
            chooser.setSelectedFile(currentExportFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DExportCertificates.ChooseExportFile.Title"));
        chooser.setMultiSelectionEnabled(false);
        int n = rtnValue = JavaFXFileChooser.isFxAvailable() ? chooser.showSaveDialog(this) : chooser.showDialog(this, res.getString("DExportCertificates.ChooseExportFile.button"));
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfExportFile.setText(chosenFile.toString());
            this.jtfExportFile.setCaretPosition(0);
        }
    }

    private void exportPressed() {
        String message;
        int selected;
        String exportFileStr;
        String simpleTitle = res.getString("DExportCertificates.Certificate.Simple.Title");
        if (this.chain) {
            simpleTitle = res.getString("DExportCertificates.CertificateChain.Simple.Title");
        }
        if ((exportFileStr = this.jtfExportFile.getText().trim()).length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DExportCertificates.ExportFileRequired.message"), simpleTitle, 2);
            return;
        }
        File exportFile = new File(exportFileStr);
        if (exportFile.isFile() && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DExportCertificates.OverWriteExportFile.message"), exportFile), simpleTitle, 0)) != 0) {
            return;
        }
        this.exportFile = exportFile;
        this.exportChain = this.jrbExportChain.isSelected();
        this.formatX509 = this.jrbExportX509.isSelected();
        this.formatPkcs7 = this.jrbExportPkcs7.isSelected();
        this.formatPkiPath = this.jrbExportPkiPath.isSelected();
        this.formatSpc = this.jrbExportSpc.isSelected();
        this.pemEncode = this.jcbExportPem.isSelected();
        this.exportSelected = true;
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        DExportCertificates dialog = new DExportCertificates(new JFrame(), "alias (test)", true);
        DialogViewer.run(dialog);
    }
}

