/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.importexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.kse.crypto.Password;
import org.kse.crypto.privatekey.OpenSslPbeType;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JavaFXFileChooser;
import org.kse.gui.PlatformUtil;
import org.kse.gui.password.JPasswordQualityField;
import org.kse.gui.password.PasswordQualityConfig;
import org.kse.utilities.io.FileNameUtil;

public class DExportPrivateKeyOpenSsl
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/importexport/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpOptions;
    private JLabel jlEncrypt;
    private JCheckBox jcbEncrypt;
    private JLabel jlPbeAlg;
    private JComboBox<OpenSslPbeType> jcbPbeAlg;
    private JLabel jlPassword;
    private JComponent jpfPassword;
    private JLabel jlConfirmPassword;
    private JPasswordField jpfConfirmPassword;
    private JLabel jlExportPem;
    private JCheckBox jcbExportPem;
    private JLabel jlExportFile;
    private JTextField jtfExportFile;
    private JButton jbBrowse;
    private JPanel jpButtons;
    private JButton jbExport;
    private JButton jbCancel;
    private String entryAlias;
    private PasswordQualityConfig passwordQualityConfig;
    private boolean exportSelected = false;
    private File exportFile;
    private boolean encrypt;
    private OpenSslPbeType pbeAlgorithm;
    private Password exportPassword;
    private boolean pemEncode;

    public DExportPrivateKeyOpenSsl(JFrame parent, String entryAlias, PasswordQualityConfig passwordQualityConfig) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.entryAlias = entryAlias;
        this.passwordQualityConfig = passwordQualityConfig;
        this.initComponents();
    }

    private void initComponents() {
        GridBagConstraints gbcLbl = new GridBagConstraints();
        gbcLbl.gridx = 0;
        gbcLbl.gridwidth = 3;
        gbcLbl.gridheight = 1;
        gbcLbl.insets = new Insets(5, 5, 5, 5);
        gbcLbl.anchor = 13;
        GridBagConstraints gbcEdCtrl = new GridBagConstraints();
        gbcEdCtrl.gridx = 3;
        gbcEdCtrl.gridwidth = 3;
        gbcEdCtrl.gridheight = 1;
        gbcEdCtrl.insets = new Insets(5, 5, 5, 5);
        gbcEdCtrl.anchor = 17;
        this.jlEncrypt = new JLabel(res.getString("DExportPrivateKeyOpenSsl.jlEncrypt.text"));
        GridBagConstraints gbc_jlEncrypt = (GridBagConstraints)gbcLbl.clone();
        gbc_jlEncrypt.gridy = 0;
        this.jcbEncrypt = new JCheckBox();
        this.jcbEncrypt.setSelected(true);
        this.jcbEncrypt.setToolTipText(res.getString("DExportPrivateKeyOpenSsl.jcbEncrypt.tooltip"));
        GridBagConstraints gbc_jcbEncrypt = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jcbEncrypt.gridy = 0;
        this.jcbEncrypt.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (DExportPrivateKeyOpenSsl.this.jcbEncrypt.isSelected()) {
                    DExportPrivateKeyOpenSsl.this.jcbExportPem.setSelected(true);
                    DExportPrivateKeyOpenSsl.this.jcbExportPem.setEnabled(false);
                } else {
                    DExportPrivateKeyOpenSsl.this.jcbExportPem.setEnabled(true);
                }
            }
        });
        this.jlPbeAlg = new JLabel(res.getString("DExportPrivateKeyOpenSsl.jlPbeAlg.text"));
        GridBagConstraints gbc_jlPbeAlg = (GridBagConstraints)gbcLbl.clone();
        gbc_jlPbeAlg.gridy = 1;
        this.jcbPbeAlg = new JComboBox();
        this.populatePbeAlgs();
        this.jcbPbeAlg.setToolTipText(res.getString("DExportPrivateKeyOpenSsl.jcbPbeAlg.tooltip"));
        this.jcbPbeAlg.setSelectedIndex(0);
        GridBagConstraints gbc_jcbPbeAlg = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jcbPbeAlg.gridy = 1;
        this.jlPassword = new JLabel(res.getString("DExportPrivateKeyOpenSsl.jlPassword.text"));
        GridBagConstraints gbc_jlPassword = (GridBagConstraints)gbcLbl.clone();
        gbc_jlPassword.gridy = 2;
        this.jpfPassword = this.passwordQualityConfig.getEnabled() ? (this.passwordQualityConfig.getEnforced() ? new JPasswordQualityField(15, this.passwordQualityConfig.getMinimumQuality()) : new JPasswordQualityField(15)) : new JPasswordField(15);
        this.jpfPassword.setToolTipText(res.getString("DExportPrivateKeyOpenSsl.jpqfPassword.tooltip"));
        GridBagConstraints gbc_jpfPassword = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jpfPassword.gridy = 2;
        this.jlConfirmPassword = new JLabel(res.getString("DExportPrivateKeyOpenSsl.jlConfirmPassword.text"));
        GridBagConstraints gbc_jlConfirmPassword = (GridBagConstraints)gbcLbl.clone();
        gbc_jlConfirmPassword.gridy = 3;
        this.jpfConfirmPassword = new JPasswordField(15);
        this.jpfConfirmPassword.setToolTipText(res.getString("DExportPrivateKeyOpenSsl.jpfConfirmPassword.tooltip"));
        GridBagConstraints gbc_jpfConfirmPassword = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jpfConfirmPassword.gridy = 3;
        this.jlExportPem = new JLabel(res.getString("DExportPrivateKeyOpenSsl.jlExportPem.text"));
        GridBagConstraints gbc_jlExportPem = (GridBagConstraints)gbcLbl.clone();
        gbc_jlExportPem.gridy = 4;
        this.jcbExportPem = new JCheckBox();
        this.jcbExportPem.setSelected(true);
        this.jcbExportPem.setEnabled(false);
        this.jcbExportPem.setToolTipText(res.getString("DExportPrivateKeyOpenSsl.jcbExportPem.tooltip"));
        GridBagConstraints gbc_jcbExportPem = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jcbExportPem.gridy = 4;
        this.jlExportFile = new JLabel(res.getString("DExportPrivateKeyOpenSsl.jlExportFile.text"));
        GridBagConstraints gbc_jlExportFile = (GridBagConstraints)gbcLbl.clone();
        gbc_jlExportFile.gridy = 5;
        this.jtfExportFile = new JTextField(30);
        this.jtfExportFile.setToolTipText(res.getString("DExportPrivateKeyOpenSsl.jtfExportFile.tooltip"));
        GridBagConstraints gbc_jtfExportFile = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jtfExportFile.gridy = 5;
        gbc_jtfExportFile.gridwidth = 6;
        this.jbBrowse = new JButton(res.getString("DExportPrivateKeyOpenSsl.jbBrowse.text"));
        this.jbBrowse.setToolTipText(res.getString("DExportPrivateKeyOpenSsl.jbBrowse.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbBrowse, res.getString("DExportPrivateKeyOpenSsl.jbBrowse.mnemonic").charAt(0));
        GridBagConstraints gbc_jbBrowse = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jbBrowse.gridy = 5;
        gbc_jbBrowse.gridx = 9;
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExportPrivateKeyOpenSsl.this);
                    DExportPrivateKeyOpenSsl.this.browsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExportPrivateKeyOpenSsl.this);
                }
            }
        });
        this.jpOptions = new JPanel(new GridBagLayout());
        this.jpOptions.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()), new EmptyBorder(5, 5, 5, 5)));
        this.jpOptions.add((Component)this.jlEncrypt, gbc_jlEncrypt);
        this.jpOptions.add((Component)this.jcbEncrypt, gbc_jcbEncrypt);
        this.jpOptions.add((Component)this.jlPbeAlg, gbc_jlPbeAlg);
        this.jpOptions.add(this.jcbPbeAlg, gbc_jcbPbeAlg);
        this.jpOptions.add((Component)this.jlPassword, gbc_jlPassword);
        this.jpOptions.add((Component)this.jpfPassword, gbc_jpfPassword);
        this.jpOptions.add((Component)this.jlConfirmPassword, gbc_jlConfirmPassword);
        this.jpOptions.add((Component)this.jpfConfirmPassword, gbc_jpfConfirmPassword);
        this.jpOptions.add((Component)this.jlExportPem, gbc_jlExportPem);
        this.jpOptions.add((Component)this.jcbExportPem, gbc_jcbExportPem);
        this.jpOptions.add((Component)this.jlExportFile, gbc_jlExportFile);
        this.jpOptions.add((Component)this.jtfExportFile, gbc_jtfExportFile);
        this.jpOptions.add((Component)this.jbBrowse, gbc_jbBrowse);
        this.jcbEncrypt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (DExportPrivateKeyOpenSsl.this.jcbEncrypt.isSelected()) {
                    DExportPrivateKeyOpenSsl.this.jcbPbeAlg.setEnabled(true);
                    DExportPrivateKeyOpenSsl.this.jpfPassword.setEnabled(true);
                    DExportPrivateKeyOpenSsl.this.jpfConfirmPassword.setEnabled(true);
                } else {
                    DExportPrivateKeyOpenSsl.this.jcbPbeAlg.setEnabled(false);
                    DExportPrivateKeyOpenSsl.this.jpfPassword.setEnabled(false);
                    if (DExportPrivateKeyOpenSsl.this.jpfPassword instanceof JPasswordQualityField) {
                        ((JPasswordQualityField)DExportPrivateKeyOpenSsl.this.jpfPassword).setText("");
                    } else {
                        ((JPasswordField)DExportPrivateKeyOpenSsl.this.jpfPassword).setText("");
                    }
                    DExportPrivateKeyOpenSsl.this.jpfConfirmPassword.setEnabled(false);
                    DExportPrivateKeyOpenSsl.this.jpfConfirmPassword.setText("");
                }
            }
        });
        this.jbExport = new JButton(res.getString("DExportPrivateKeyOpenSsl.jbExport.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbExport, res.getString("DExportPrivateKeyOpenSsl.jbExport.mnemonic").charAt(0));
        this.jbExport.setToolTipText(res.getString("DExportPrivateKeyOpenSsl.jbExport.tooltip"));
        this.jbExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExportPrivateKeyOpenSsl.this);
                    DExportPrivateKeyOpenSsl.this.exportPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExportPrivateKeyOpenSsl.this);
                }
            }
        });
        this.jbCancel = new JButton(res.getString("DExportPrivateKeyOpenSsl.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExportPrivateKeyOpenSsl.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExportPrivateKeyOpenSsl.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbExport, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpOptions, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DExportPrivateKeyOpenSsl.this.closeDialog();
            }
        });
        this.setTitle(MessageFormat.format(res.getString("DExportPrivateKeyOpenSsl.Title"), this.entryAlias));
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbExport);
        this.populateExportFileName();
        this.pack();
    }

    private void populateExportFileName() {
        File currentDirectory = CurrentDirectory.get();
        String sanitizedAlias = FileNameUtil.cleanFileName(this.entryAlias);
        File csrFile = new File(currentDirectory, sanitizedAlias + "." + "key");
        this.jtfExportFile.setText(csrFile.getPath());
    }

    public boolean exportSelected() {
        return this.exportSelected;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public boolean encrypt() {
        return this.encrypt;
    }

    public OpenSslPbeType getPbeAlgorithm() {
        return this.pbeAlgorithm;
    }

    public Password getExportPassword() {
        return this.exportPassword;
    }

    public boolean pemEncode() {
        return this.pemEncode;
    }

    private void populatePbeAlgs() {
        OpenSslPbeType[] pbeAlgs = OpenSslPbeType.values();
        for (int i = 0; i < pbeAlgs.length; ++i) {
            this.jcbPbeAlg.addItem(pbeAlgs[i]);
        }
        this.jcbPbeAlg.setSelectedIndex(0);
    }

    private void browsePressed() {
        int rtnValue;
        JFileChooser chooser = FileChooserFactory.getOpenSslPvkFileChooser();
        File currentExportFile = new File(this.jtfExportFile.getText().trim());
        if (currentExportFile.getParentFile() != null && currentExportFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentExportFile.getParentFile());
            chooser.setSelectedFile(currentExportFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DExportPrivateKeyOpenSsl.ChooseExportFile.Title"));
        chooser.setMultiSelectionEnabled(false);
        int n = rtnValue = JavaFXFileChooser.isFxAvailable() ? chooser.showSaveDialog(this) : chooser.showDialog(this, res.getString("DExportPrivateKeyOpenSsl.ChooseExportFile.button"));
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfExportFile.setText(chosenFile.toString());
            this.jtfExportFile.setCaretPosition(0);
        }
    }

    private void exportPressed() {
        String message;
        int selected;
        this.encrypt = this.jcbEncrypt.isSelected();
        if (this.encrypt) {
            Password firstPassword;
            this.pbeAlgorithm = (OpenSslPbeType)this.jcbPbeAlg.getSelectedItem();
            if (this.jpfPassword instanceof JPasswordQualityField) {
                char[] firstPasswordChars = ((JPasswordQualityField)this.jpfPassword).getPassword();
                if (firstPasswordChars == null) {
                    JOptionPane.showMessageDialog(this, res.getString("DExportPrivateKeyOpenSsl.MinimumPasswordQualityNotMet.message"), res.getString("DExportPrivateKeyOpenSsl.Simple.Title"), 2);
                    return;
                }
                firstPassword = new Password(firstPasswordChars);
            } else {
                firstPassword = new Password(((JPasswordField)this.jpfPassword).getPassword());
            }
            Password confirmPassword = new Password(this.jpfConfirmPassword.getPassword());
            if (firstPassword.equals(confirmPassword)) {
                this.exportPassword = firstPassword;
            } else {
                JOptionPane.showMessageDialog(this, res.getString("DExportPrivateKeyOpenSsl.PasswordsNoMatch.message"), res.getString("DExportPrivateKeyOpenSsl.Simple.Title"), 2);
                return;
            }
        }
        this.pemEncode = this.jcbExportPem.isSelected();
        String exportFileChars = this.jtfExportFile.getText().trim();
        if (exportFileChars.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DExportPrivateKeyOpenSsl.ExportFileRequired.message"), res.getString("DExportPrivateKeyOpenSsl.Simple.Title"), 2);
            return;
        }
        File exportFile = new File(exportFileChars);
        if (exportFile.isFile() && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DExportPrivateKeyOpenSsl.OverWriteExportFile.message"), exportFile), res.getString("DExportPrivateKeyOpenSsl.Simple.Title"), 0)) != 0) {
            return;
        }
        this.exportFile = exportFile;
        this.exportSelected = true;
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

