/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.importexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JavaFXFileChooser;
import org.kse.gui.PlatformUtil;
import org.kse.utilities.io.FileNameUtil;

public class DExportPublicKeyOpenSsl
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/importexport/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpOptions;
    private JLabel jlExportPem;
    private JCheckBox jcbExportPem;
    private JLabel jlExportFile;
    private JTextField jtfExportFile;
    private JButton jbBrowse;
    private JPanel jpButtons;
    private JButton jbExport;
    private JButton jbCancel;
    private String entryAlias;
    private boolean exportSelected = false;
    private File exportFile;
    private boolean pemEncode;

    public DExportPublicKeyOpenSsl(JFrame parent, String entryAlias) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.entryAlias = entryAlias;
        this.initComponents();
    }

    private void initComponents() {
        GridBagConstraints gbcLbl = new GridBagConstraints();
        gbcLbl.gridx = 0;
        gbcLbl.gridwidth = 3;
        gbcLbl.gridheight = 1;
        gbcLbl.insets = new Insets(5, 5, 5, 5);
        gbcLbl.anchor = 13;
        GridBagConstraints gbcEdCtrl = new GridBagConstraints();
        gbcEdCtrl.gridx = 3;
        gbcEdCtrl.gridwidth = 3;
        gbcEdCtrl.gridheight = 1;
        gbcEdCtrl.insets = new Insets(5, 5, 5, 5);
        gbcEdCtrl.anchor = 17;
        this.jlExportPem = new JLabel(res.getString("DExportPublicKeyOpenSsl.jlExportPem.text"));
        GridBagConstraints gbc_jlExportPem = (GridBagConstraints)gbcLbl.clone();
        gbc_jlExportPem.gridy = 4;
        this.jcbExportPem = new JCheckBox();
        this.jcbExportPem.setSelected(true);
        this.jcbExportPem.setToolTipText(res.getString("DExportPublicKeyOpenSsl.jcbExportPem.tooltip"));
        GridBagConstraints gbc_jcbExportPem = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jcbExportPem.gridy = 4;
        this.jlExportFile = new JLabel(res.getString("DExportPublicKeyOpenSsl.jlExportFile.text"));
        GridBagConstraints gbc_jlExportFile = (GridBagConstraints)gbcLbl.clone();
        gbc_jlExportFile.gridy = 5;
        this.jtfExportFile = new JTextField(30);
        this.jtfExportFile.setToolTipText(res.getString("DExportPublicKeyOpenSsl.jtfExportFile.tooltip"));
        GridBagConstraints gbc_jtfExportFile = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jtfExportFile.gridy = 5;
        gbc_jtfExportFile.gridwidth = 6;
        this.jbBrowse = new JButton(res.getString("DExportPublicKeyOpenSsl.jbBrowse.text"));
        this.jbBrowse.setToolTipText(res.getString("DExportPublicKeyOpenSsl.jbBrowse.tooltip"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbBrowse, res.getString("DExportPublicKeyOpenSsl.jbBrowse.mnemonic").charAt(0));
        GridBagConstraints gbc_jbBrowse = (GridBagConstraints)gbcEdCtrl.clone();
        gbc_jbBrowse.gridy = 5;
        gbc_jbBrowse.gridx = 9;
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExportPublicKeyOpenSsl.this);
                    DExportPublicKeyOpenSsl.this.browsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExportPublicKeyOpenSsl.this);
                }
            }
        });
        this.jpOptions = new JPanel(new GridBagLayout());
        this.jpOptions.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()), new EmptyBorder(5, 5, 5, 5)));
        this.jpOptions.add((Component)this.jlExportPem, gbc_jlExportPem);
        this.jpOptions.add((Component)this.jcbExportPem, gbc_jcbExportPem);
        this.jpOptions.add((Component)this.jlExportFile, gbc_jlExportFile);
        this.jpOptions.add((Component)this.jtfExportFile, gbc_jtfExportFile);
        this.jpOptions.add((Component)this.jbBrowse, gbc_jbBrowse);
        this.jbExport = new JButton(res.getString("DExportPublicKeyOpenSsl.jbExport.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbExport, res.getString("DExportPublicKeyOpenSsl.jbExport.mnemonic").charAt(0));
        this.jbExport.setToolTipText(res.getString("DExportPublicKeyOpenSsl.jbExport.tooltip"));
        this.jbExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DExportPublicKeyOpenSsl.this);
                    DExportPublicKeyOpenSsl.this.exportPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DExportPublicKeyOpenSsl.this);
                }
            }
        });
        this.jbCancel = new JButton(res.getString("DExportPublicKeyOpenSsl.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExportPublicKeyOpenSsl.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExportPublicKeyOpenSsl.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbExport, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpOptions, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DExportPublicKeyOpenSsl.this.closeDialog();
            }
        });
        this.setTitle(MessageFormat.format(res.getString("DExportPublicKeyOpenSsl.Title"), this.entryAlias));
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbExport);
        this.populateExportFileName();
        this.pack();
    }

    private void populateExportFileName() {
        File currentDirectory = CurrentDirectory.get();
        String sanitizedAlias = FileNameUtil.cleanFileName(this.entryAlias);
        File csrFile = new File(currentDirectory, sanitizedAlias + "." + "pub");
        this.jtfExportFile.setText(csrFile.getPath());
    }

    public boolean exportSelected() {
        return this.exportSelected;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public boolean pemEncode() {
        return this.pemEncode;
    }

    private void browsePressed() {
        int rtnValue;
        JFileChooser chooser = FileChooserFactory.getPublicKeyFileChooser();
        File currentExportFile = new File(this.jtfExportFile.getText().trim());
        if (currentExportFile.getParentFile() != null && currentExportFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentExportFile.getParentFile());
            chooser.setSelectedFile(currentExportFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DExportPublicKeyOpenSsl.ChooseExportFile.Title"));
        chooser.setMultiSelectionEnabled(false);
        int n = rtnValue = JavaFXFileChooser.isFxAvailable() ? chooser.showSaveDialog(this) : chooser.showDialog(this, res.getString("DExportPublicKeyOpenSsl.ChooseExportFile.button"));
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfExportFile.setText(chosenFile.toString());
            this.jtfExportFile.setCaretPosition(0);
        }
    }

    private void exportPressed() {
        String message;
        int selected;
        this.pemEncode = this.jcbExportPem.isSelected();
        String exportFileStr = this.jtfExportFile.getText().trim();
        if (exportFileStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DExportPublicKeyOpenSsl.ExportFileRequired.message"), res.getString("DExportPublicKeyOpenSsl.Simple.Title"), 2);
            return;
        }
        File exportFile = new File(exportFileStr);
        if (exportFile.isFile() && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DExportPublicKeyOpenSsl.OverWriteExportFile.message"), exportFile), res.getString("DExportPublicKeyOpenSsl.Simple.Title"), 0)) != 0) {
            return;
        }
        this.exportFile = exportFile;
        this.exportSelected = true;
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

