/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dnchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.kse.crypto.x509.KseX500NameStyle;
import org.kse.gui.dnchooser.RdnPanelList;

public class DistinguishedNameChooser
extends JPanel {
    private static final long serialVersionUID = 2886549944489669970L;
    private boolean editable;
    private X500Name currentName;
    private String defaultName;
    private RdnPanelList listPanel;

    public DistinguishedNameChooser(X500Name dn, boolean editable, String defaultDN) {
        this.editable = editable;
        if (dn == null || dn.getRDNs().length == 0) {
            if (defaultDN == null || defaultDN.isEmpty()) {
                defaultDN = "CN=, OU=, O=, L=, ST=, C=";
            }
            this.currentName = new X500Name((X500NameStyle)KseX500NameStyle.INSTANCE, defaultDN);
        } else {
            this.currentName = dn;
        }
        this.defaultName = defaultDN;
        this.init();
    }

    private void init() {
        this.listPanel = new RdnPanelList(this.currentName, this.editable);
        JScrollPane jScrollPane = new JScrollPane(this.listPanel);
        jScrollPane.setViewportBorder(null);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    public X500Name getDN() {
        boolean noEmptyRdns = true;
        List<RDN> rdns = this.listPanel.getRdns(noEmptyRdns);
        Collections.reverse(rdns);
        return new X500Name(rdns.toArray(new RDN[rdns.size()]));
    }

    public X500Name getDNWithEmptyRdns() {
        List<RDN> rdns = this.listPanel.getRdns(false);
        Collections.reverse(rdns);
        return new X500Name(rdns.toArray(new RDN[rdns.size()]));
    }

    public JTextField getFirstTextField() {
        return this.listPanel.getFirstTextField();
    }

    public void reset() {
        this.currentName = new X500Name(this.defaultName);
        this.removeAll();
        this.init();
        this.revalidate();
        this.repaint(50L);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame frame = new JFrame();
        frame.setSize(800, 400);
        X500Name dn = new X500Name((X500NameStyle)KseX500NameStyle.INSTANCE, "CN=test, OU=Development, OU=Software, O=ACME Ltd., C=UK, E=test@example.com, UID=123456");
        String defaultDN = "CN=, OU=, O=, C=";
        final DistinguishedNameChooser nameChooser = new DistinguishedNameChooser(dn, true, defaultDN);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)nameChooser, "Center");
        JButton resetButton = new JButton("Reset to Default DN");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                nameChooser.reset();
            }
        });
        frame.getContentPane().add((Component)resetButton, "North");
        JButton showNameButton = new JButton("Print Name");
        showNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.out.println(nameChooser.getDN().toString());
            }
        });
        frame.getContentPane().add((Component)showNameButton, "South");
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

