/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dnchooser;

import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.kse.crypto.x509.KseX500NameStyle;
import org.kse.gui.dnchooser.OidDisplayNameMapping;
import org.kse.gui.dnchooser.RdnPanel;
import org.kse.utilities.StringUtils;

public class RdnPanelList
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<RdnPanel> entries = new ArrayList<RdnPanel>();
    private boolean editable;
    private static final String[] comboBoxEntries = OidDisplayNameMapping.getDisplayNames();

    public RdnPanelList(X500Name x500Name, boolean editable) {
        this.setLayout((LayoutManager)new MigLayout("insets dialog, flowy", "[right]", "[]rel[]"));
        List<RDN> rdnsAsList = Arrays.asList(x500Name.getRDNs());
        Collections.reverse(rdnsAsList);
        for (RDN rdn : rdnsAsList) {
            this.editable = editable;
            for (AttributeTypeAndValue atav : rdn.getTypesAndValues()) {
                String type = OidDisplayNameMapping.getDisplayNameForOid(atav.getType().getId());
                String value = atav.getValue().toString();
                this.addItem(new RdnPanel(new JComboBox<String>(comboBoxEntries), type, value, this, editable));
            }
        }
    }

    public void cloneEntry(RdnPanel entry) {
        Object selected = entry.getComboBox().getSelectedItem();
        RdnPanel clone = new RdnPanel(new JComboBox<String>(comboBoxEntries), selected.toString(), "", this, this.editable);
        this.addItemAfter(clone, entry);
    }

    private void addItem(RdnPanel entry) {
        this.entries.add(entry);
        this.add(entry);
        this.refresh();
    }

    private void addItemAfter(RdnPanel entryToAdd, RdnPanel afterThisEntry) {
        this.entries.add(this.entries.indexOf(afterThisEntry) + 1, entryToAdd);
        this.removeAll();
        for (RdnPanel entry : this.entries) {
            this.add(entry);
        }
        this.refresh();
    }

    public void removeItem(RdnPanel entry) {
        this.entries.remove(entry);
        this.remove(entry);
        this.refresh();
    }

    public List<RDN> getRdns(boolean noEmptyRdns) {
        ArrayList<RDN> rdns = new ArrayList<RDN>();
        for (RdnPanel rdnPanel : this.entries) {
            ASN1ObjectIdentifier attrType = OidDisplayNameMapping.getOidForDisplayName(rdnPanel.getAttributeName());
            if (noEmptyRdns && StringUtils.trimAndConvertEmptyToNull(rdnPanel.getAttributeValue()) == null) continue;
            ASN1Encodable attrValue = KseX500NameStyle.INSTANCE.stringToValue(attrType, rdnPanel.getAttributeValue());
            rdns.add(new RDN(new AttributeTypeAndValue(attrType, attrValue)));
        }
        return rdns;
    }

    public JTextField getFirstTextField() {
        RdnPanel rdnPanel = this.entries.get(0);
        if (rdnPanel != null) {
            return rdnPanel.getTextField();
        }
        return new JTextField();
    }

    private void refresh() {
        this.revalidate();
        this.repaint(50L);
        if (this.entries.size() == 1) {
            this.entries.get(0).enableMinus(false);
        } else {
            for (RdnPanel e : this.entries) {
                e.enableMinus(true);
            }
        }
    }
}

